if __FILE__ == $0
	$LOAD_PATH.unshift '../lib' 
	require 'test/unit'
	require 'test/unit/ui/console/testrunner'
	require 'cgikit'
	require 'TestApp/app'
	require 'TestApp/ResetPage/ResetPage'
	require 'test_common'
end


class TestElementReset < Test::Unit::TestCase
	include CGIKit, TestCommon

	def setup
		@app = testapp()
		@app.main = ResetPage
		@does_test_other = true
	end

	def test_api_correct
		dec = {:TestAPI => {:element => Reset, :value => :test}}
		store = DeclarationStore.new_from_hash(dec)
		assert_nothing_raised { store.validate_api }
	end

	def test_api_nothing_bound
		dec = {:TestAPI => {:element => Reset}}
		store = DeclarationStore.new_from_hash(dec)
		assert_nothing_raised(ValidationError) { store.validate_api }
	end

	def test_attributes
		response = @app.run
		command = Command.new(response)
		assert_equal(ResetPage::TEST_VALUE, \
			command.control(ResetPage::TEST_VALUE_NAME)[:value])
		assert_equal(false, command.control(ResetPage::TEST_ENABLED_NAME).enabled?)
	end

	def test_other
		response = @app.run
		command = Command.new(response)
		assert(TestCommon.test_other(command))
	end

end


if __FILE__ == $0 then
	suite = TestElementReset.suite
	runner = Test::Unit::UI::Console::TestRunner.new suite
	runner.start
end
