if __FILE__ == $0
	$LOAD_PATH.unshift '../lib' 
	require 'test/unit'
	require 'test/unit/ui/console/testrunner'
	require 'cgikit'
	require 'TestApp/app'
	require 'TestApp/StringPage/StringPage'
	require 'test_common'
end


class TestElementString < Test::Unit::TestCase
	include CGIKit, TestCommon

	def setup
		@app = testapp()
		@app.main = StringPage
	end

	def test_api_correct
		dec = {:TestAPI => {:element => String, :value => :test}}
		store = DeclarationStore.new_from_hash(dec)
		assert_nothing_raised { store.validate_api }
	end

	def test_api_not_bound_value
		dec = {:TestAPI => {:element => String}}
		store = DeclarationStore.new_from_hash(dec)
		assert_raises(ValidationError) { store.validate_api }
	end

	def test_attributes
		response = @app.run
		assert(StringPage.test_value(response.content))
		assert(StringPage.test_empty(response.content))
		assert(StringPage.test_escape_on(response.content))
		assert(StringPage.test_escape_off(response.content))
		assert(StringPage.test_br(response.content))
	end

end


if __FILE__ == $0 then
	suite = TestElementString.suite
	runner = Test::Unit::UI::Console::TestRunner.new suite
	runner.start
end
