/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.chaplet.nova.server;

import java.text.ParseException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import jp.sourceforge.chaplet.ConfigLoader;
import jp.sourceforge.chaplet.nova.server.Hand;

public class HandManager {
    private HashMap handMap = new HashMap();
    private int maxHand = 4;

    public HandManager() {
        String numHand = ConfigLoader.getInstance().load().getProperty("jp.sourceforge.chaplet.nova.numHand");
        if (numHand != null && numHand.length() > 0) {
            try {
                this.maxHand = Integer.parseInt(numHand);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public void setProperties(Properties properties) {
        int i = 0;
        Iterator iter = this.handMap.keySet().iterator();
        while (iter.hasNext()) {
            String name = iter.next().toString();
            Hand hand = (Hand)this.handMap.get(name);
            properties.setProperty("nova.hand." + i, hand.toString());
            ++i;
        }
    }

    public void getProperties(Properties properties) {
        this.handMap.clear();
        int i = 0;
        while (true) {
            String element = properties.getProperty("nova.hand." + i);
            try {
                if (element == null) break;
                Hand hand = new Hand();
                hand.parse(element);
                this.handMap.put(hand.getName(), hand);
                ++i;
            }
            catch (ParseException parseException) {}
        }
    }

    public int addHandOf(String name) {
        Hand hand = (Hand)this.handMap.get(name);
        if (hand == null) {
            hand = new Hand();
            hand.setName(name);
            this.handMap.put(name, hand);
            return 0;
        }
        return hand.addHand();
    }

    public boolean removeHandOf(String userName, int handNo) {
        Hand hand = (Hand)this.handMap.get(userName);
        if (hand == null) {
            return false;
        }
        return hand.removeHand(handNo);
    }

    public boolean removeHandOf(String userName) {
        return this.handMap.remove(userName) != null;
    }

    public String[] getHandOf(String userName, int handNo) {
        Hand hand = (Hand)this.handMap.get(userName);
        if (hand == null) {
            return null;
        }
        return hand.getHand(handNo);
    }

    public Hand getHandOf(String userName) {
        return (Hand)this.handMap.get(userName);
    }

    public void switchHand(String[] hand1, String[] hand2, String card, String[] newHand1, String[] newHand2) {
        int found = 0;
        newHand1[0] = hand1[0];
        newHand1[1] = hand1[1];
        int i = 2;
        while (i < hand1.length) {
            if (hand1[i].equals(card) && found == 0) {
                found = 1;
            } else {
                newHand1[i - found] = hand1[i];
            }
            ++i;
        }
        System.arraycopy(hand2, 0, newHand2, 0, hand2.length);
        newHand2[hand2.length] = card;
    }

    public String switchReaction(String card) {
        if (card.length() == 3) {
            return card.substring(0, 2);
        }
        return String.valueOf(card) + "_";
    }

    public Hand[] getAllHands() {
        return this.handMap.values().toArray(new Hand[this.handMap.size()]);
    }

    public int getMaxHand() {
        return this.maxHand;
    }
}

