/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.chaplet.dice.server;

import java.text.ParseException;
import java.util.Random;
import java.util.StringTokenizer;

public class DiceManager {
    private Random random = new Random();

    public boolean isValid(String rule) {
        try {
            rule = this.evalValiable(rule);
            int numDice = this.getNumDice(rule);
            int die = this.getDie(rule);
            return true;
        }
        catch (ParseException e) {
            return false;
        }
    }

    public int[] roleSum(String rule, int bonus, int numRerole) throws ParseException {
        rule = this.evalValiable(rule);
        int numDice = this.getNumDice(rule);
        int die = this.getDie(rule);
        if (numRerole >= 0 && numDice > numRerole) {
            numDice = numRerole;
        }
        int[] result = new int[numDice + 1];
        result[0] = bonus;
        int i = 1;
        while (i <= numDice) {
            result[i] = this.random.nextInt(die) + 1;
            result[0] = result[0] + result[i];
            ++i;
        }
        return result;
    }

    public int[] roleCount(String rule, int target, boolean upperRole, int numRerole) throws ParseException {
        rule = this.evalValiable(rule);
        int numDice = this.getNumDice(rule);
        if (numRerole >= 0 && numDice > numRerole) {
            numDice = numRerole;
        }
        int die = this.getDie(rule);
        int[] result = new int[numDice + 1];
        int i = 1;
        while (i <= numDice) {
            result[i] = this.random.nextInt(die) + 1;
            if (upperRole) {
                if (result[i] >= target) {
                    result[0] = result[0] + 1;
                }
            } else if (result[i] <= target) {
                result[0] = result[0] + 1;
            }
            ++i;
        }
        return result;
    }

    public String evalValiable(String rule) throws ParseException {
        int valiableStart = rule.indexOf(58);
        if (valiableStart < 0) {
            return rule;
        }
        StringTokenizer tokenizer = new StringTokenizer(rule, ":");
        StringBuffer base = new StringBuffer(tokenizer.nextToken());
        while (tokenizer.hasMoreTokens()) {
            String expression = tokenizer.nextToken();
            int equalPos = expression.indexOf(61);
            if (equalPos < 0) {
                throw new ParseException(expression, 0);
            }
            String valiable = expression.substring(0, equalPos).trim();
            String valiableStr = String.valueOf('[') + valiable + ']';
            String valueStr = expression.substring(equalPos + 1).trim();
            int valiablePos = base.indexOf(valiableStr);
            if (valiablePos < 0) continue;
            try {
                int num = Integer.parseInt(valueStr);
                base.replace(valiablePos, valiablePos + valiableStr.length(), valueStr);
            }
            catch (NumberFormatException e) {
                throw new ParseException(expression, 0);
            }
        }
        return base.toString().trim();
    }

    public int getNumDice(String rule) throws ParseException {
        int dPos = rule.indexOf(68);
        if (dPos < 0) {
            throw new ParseException(rule, 0);
        }
        try {
            return Integer.parseInt(rule.substring(0, dPos));
        }
        catch (NumberFormatException e) {
            throw new ParseException(rule, dPos);
        }
    }

    public int getDie(String rule) throws ParseException {
        int dPos = rule.indexOf(68);
        if (dPos < 0) {
            throw new ParseException(rule, 0);
        }
        try {
            return Integer.parseInt(rule.substring(dPos + 1));
        }
        catch (NumberFormatException e) {
            throw new ParseException(rule, dPos);
        }
    }
}

