/*
 * Decompiled with CFR 0.152.
 */
package com.cloudgarden.resource;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Widget;

public class SWTResourceManager {
    private static HashMap resources = new HashMap();
    private static Vector users = new Vector();
    private static SWTResourceManager instance = new SWTResourceManager();
    private static DisposeListener disposeListener = new DisposeListener(){

        public void widgetDisposed(DisposeEvent e) {
            users.remove(e.getSource());
            if (users.size() == 0) {
                SWTResourceManager.dispose();
            }
        }
    };
    static /* synthetic */ Class class$0;

    public static void registerResourceUser(Widget widget) {
        if (users.contains(widget)) {
            return;
        }
        widget.addDisposeListener(disposeListener);
    }

    public static void dispose() {
        Iterator it = resources.keySet().iterator();
        while (it.hasNext()) {
            Object resource = resources.get(it.next());
            if (resource instanceof Font) {
                ((Font)resource).dispose();
                continue;
            }
            if (resource instanceof Color) {
                ((Color)resource).dispose();
                continue;
            }
            if (resource instanceof Image) {
                ((Image)resource).dispose();
                continue;
            }
            if (!(resource instanceof Cursor)) continue;
            ((Cursor)resource).dispose();
        }
        resources.clear();
    }

    public static Font getFont(String name, int size, int style) {
        return SWTResourceManager.getFont(name, size, style, false, false);
    }

    public static Font getFont(String name, int size, int style, boolean strikeout, boolean underline) {
        String fontName = String.valueOf(name) + "|" + size + "|" + style + "|" + strikeout + "|" + underline;
        if (resources.containsKey(fontName)) {
            return (Font)resources.get(fontName);
        }
        FontData fd = new FontData(name, size, style);
        if (strikeout || underline) {
            try {
                Object lf;
                Class<?> lfCls = Class.forName("org.eclipse.swt.internal.win32.LOGFONT");
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.swt.graphics.FontData");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((lf = clazz.getField("data").get(fd)) != null && lfCls != null) {
                    if (strikeout) {
                        lfCls.getField("lfStrikeOut").set(lf, new Byte(1));
                    }
                    if (underline) {
                        lfCls.getField("lfUnderline").set(lf, new Byte(1));
                    }
                }
            }
            catch (Throwable e) {
                System.err.println("Unable to set underline or strikeout (probably on a non-Windows platform). " + e);
            }
        }
        Font font = new Font((Device)Display.getDefault(), fd);
        resources.put(fontName, font);
        return font;
    }

    public static Image getImage(String url, Control widget) {
        Image img = SWTResourceManager.getImage(url);
        img.setBackground(widget.getBackground());
        return img;
    }

    public static Image getImage(String url) {
        try {
            url = url.replace('\\', '/');
            if (url.startsWith("/")) {
                url = url.substring(1);
            }
            if (resources.containsKey(url)) {
                return (Image)resources.get(url);
            }
            Image img = new Image((Device)Display.getDefault(), instance.getClass().getClassLoader().getResourceAsStream(url));
            if (img != null) {
                resources.put(url, img);
            }
            return img;
        }
        catch (Exception e) {
            System.err.println("SWTResourceManager.getImage: Error getting image " + url + ", " + e);
            return null;
        }
    }

    public static Color getColor(int red, int green, int blue) {
        String name = "COLOR:" + red + "," + green + "," + blue;
        if (resources.containsKey(name)) {
            return (Color)resources.get(name);
        }
        Color color = new Color((Device)Display.getDefault(), red, green, blue);
        resources.put(name, color);
        return color;
    }
}

