/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.chaplet.core.client;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import jp.sourceforge.chaplet.NetUtil;
import jp.sourceforge.chaplet.core.client.IChatListener;
import org.apache.commons.logging.LogFactory;

public class ChatConnection {
    private Socket socket;
    private BufferedWriter writer;
    private BufferedReader reader;
    private ArrayList listenerList = new ArrayList();
    private LinkedList runList = new LinkedList();
    private boolean logined = false;
    private Thread mainThread;

    public void connect(String host, int port, String userName) throws IOException {
        this.socket = new Socket(host, port);
        this.writer = NetUtil.getWriter(this.socket);
        this.reader = NetUtil.getReader(this.socket);
        this.writer.write("login");
        this.writer.newLine();
        this.writer.write(userName);
        this.writer.newLine();
        this.writer.write(46);
        this.writer.newLine();
        this.writer.flush();
        this.logined = true;
        this.mainThread = new Thread(new Runnable(){

            public void run() {
                ChatConnection.this.mainLoop();
            }
        }, "client-messageLoop");
        Thread recieveThread = new Thread(new Runnable(){

            public void run() {
                ChatConnection.this.recieveLoop();
            }
        }, "client-recieveLoop");
        this.mainThread.start();
        recieveThread.start();
        this.notifyConnect(host);
    }

    private void mainLoop() {
        while (this.logined) {
            String[] request = null;
            ChatConnection chatConnection = this;
            synchronized (chatConnection) {
                while (this.runList.size() == 0) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                }
                if (!this.logined) {
                    return;
                }
                if (this.runList.size() == 0) {
                    return;
                }
                request = (String[])this.runList.removeFirst();
                this.notifyAll();
            }
            if (request == null) {
                return;
            }
            try {
                int i = 0;
                while (i < request.length) {
                    NetUtil.writeLine(this.writer, request[i]);
                    ++i;
                }
                this.writer.write(46);
                this.writer.newLine();
                this.writer.flush();
            }
            catch (Exception e) {
                LogFactory.getLog(this.getClass()).error((Object)request[0], (Throwable)e);
                this.notifyErrorOccured();
            }
        }
    }

    private void recieveLoop() {
        while (this.logined && this.socket != null && this.socket.isConnected()) {
            try {
                IChatListener listener;
                Iterator iter;
                String[] line = NetUtil.getRequest(this.reader);
                if (line == null || line.length == 0) {
                    this.logined = false;
                    ChatConnection chatConnection = this;
                    synchronized (chatConnection) {
                        this.notifyAll();
                    }
                    return;
                }
                if (line[0].startsWith("ok/") || line[0].startsWith("ng/")) {
                    iter = this.listenerList.iterator();
                    while (iter.hasNext()) {
                        listener = (IChatListener)iter.next();
                        listener.responseRecieved(line);
                    }
                    continue;
                }
                iter = this.listenerList.iterator();
                while (iter.hasNext()) {
                    listener = (IChatListener)iter.next();
                    listener.messageRecieved(line);
                }
            }
            catch (SocketException e) {
                this.notifyErrorDisconnect();
                try {
                    this.socket.close();
                }
                catch (IOException e1) {
                    LogFactory.getLog(this.getClass()).error((Object)"recieveLoop", (Throwable)e1);
                    this.notifyErrorOccured();
                }
                this.socket = null;
                this.logined = false;
                break;
            }
            catch (Exception e) {
                LogFactory.getLog(this.getClass()).error((Object)"recieveLoop", (Throwable)e);
                this.notifyErrorOccured();
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() {
        block8: {
            if (this.socket == null) return;
            if (this.socket.isConnected() == false) return;
            try {
                try {
                    this.socket.shutdownInput();
                    this.socket.shutdownOutput();
                    this.reader.read();
                }
                catch (IOException e) {
                    LogFactory.getLog(this.getClass()).error((Object)"close", (Throwable)e);
                    this.notifyErrorOccured();
                }
            }
            catch (Throwable var3_2) {
                var2_3 = null;
                try {
                    this.socket.close();
                    throw var3_2;
                }
                catch (IOException e) {
                    LogFactory.getLog(this.getClass()).error((Object)"close", (Throwable)e);
                }
                throw var3_2;
            }
            {
                var2_4 = null;
            }
            ** try [egrp 2[TRYBLOCK] [3 : 72->82)] { 
lbl25:
            // 1 sources

            this.socket.close();
            break block8;
lbl27:
            // 1 sources

            catch (IOException e) {
                LogFactory.getLog(this.getClass()).error((Object)"close", (Throwable)e);
            }
        }
        this.mainThread.interrupt();
        this.notifyDisconnect();
    }

    public void sendMessage(String[] message) {
        ChatConnection chatConnection = this;
        synchronized (chatConnection) {
            this.runList.addLast(message);
            this.notifyAll();
        }
    }

    public boolean addChatListener(IChatListener listener) {
        return this.listenerList.add(listener);
    }

    public boolean removeChatListener(IChatListener listener) {
        return this.listenerList.remove(listener);
    }

    private void notifyConnect(String serverName) {
        Iterator iter = this.listenerList.iterator();
        while (iter.hasNext()) {
            IChatListener listener = (IChatListener)iter.next();
            listener.connectionEstablished(serverName);
        }
    }

    private void notifyDisconnect() {
        Iterator iter = this.listenerList.iterator();
        while (iter.hasNext()) {
            IChatListener listener = (IChatListener)iter.next();
            listener.connectionClosed();
        }
    }

    private void notifyErrorDisconnect() {
        Iterator iter = this.listenerList.iterator();
        while (iter.hasNext()) {
            IChatListener listener = (IChatListener)iter.next();
            listener.connectionClosedByError();
        }
    }

    private void notifyErrorOccured() {
        Iterator iter = this.listenerList.iterator();
        while (iter.hasNext()) {
            IChatListener listener = (IChatListener)iter.next();
            listener.errorOccured();
        }
    }
}

