/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.chaplet.core.client;

import java.util.HashMap;
import jp.sourceforge.chaplet.core.client.ChatClient;
import jp.sourceforge.chaplet.core.client.ChatConnection;
import jp.sourceforge.chaplet.core.client.ClientAction;
import jp.sourceforge.chaplet.core.ui.IConfigDialog;
import jp.sourceforge.chaplet.core.ui.IPluginView;
import org.eclipse.swt.widgets.Composite;

public abstract class ClientPlugin {
    private ChatClient ctl;
    private HashMap actionMap = new HashMap();

    public final void init(ChatClient ctl) throws Exception {
        this.ctl = ctl;
        this.init();
    }

    public void init() throws Exception {
    }

    public abstract void initSWT(Composite var1);

    public void destroy() {
    }

    protected void addAction(String name, ClientAction action) {
        this.actionMap.put(name, action);
    }

    protected void removeAction(String name) {
        this.actionMap.remove(name);
    }

    protected ClientAction getAction(String name) {
        return (ClientAction)this.actionMap.get(name);
    }

    public abstract Composite getSWTComponent();

    public ChatClient getController() {
        return this.ctl;
    }

    protected ChatConnection getConnection() {
        return this.ctl.getConnection();
    }

    public abstract IPluginView getPluginView();

    public abstract String getPluginId();

    public IConfigDialog initConfigDialog(Composite parent) {
        return null;
    }

    public void setGM(boolean gm) {
        this.getPluginView().setGM(gm);
    }
}

