/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.chaplet.core.server;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import java.util.TreeMap;
import jp.sourceforge.chaplet.ActionResult;
import jp.sourceforge.chaplet.ConfigLoader;
import jp.sourceforge.chaplet.Configuration;
import jp.sourceforge.chaplet.Plugin;
import jp.sourceforge.chaplet.core.server.ActivatePluginAction;
import jp.sourceforge.chaplet.core.server.ChatServerAction;
import jp.sourceforge.chaplet.core.server.ClientProxy;
import jp.sourceforge.chaplet.core.server.IServerListener;
import jp.sourceforge.chaplet.core.server.LoginServerAction;
import jp.sourceforge.chaplet.core.server.LogoutServerAction;
import jp.sourceforge.chaplet.core.server.ServerAction;
import jp.sourceforge.chaplet.core.server.ServerPlugin;
import jp.sourceforge.chaplet.core.server.SetGMAction;
import jp.sourceforge.chaplet.core.server.User;
import jp.sourceforge.chaplet.core.server.UserManager;
import jp.sourceforge.chaplet.core.server.WritingServerAction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ChatServer
extends ServerPlugin {
    private UserManager userManager = new UserManager();
    private ArrayList proxyList = new ArrayList();
    private ServerSocket serverSocket;
    private ArrayList listenerList = new ArrayList();
    private ServerPlugin primaryPlugin;
    private Log log = LogFactory.getLog(this.getClass());
    private TreeMap pluginMap = new TreeMap();
    private String owner;

    public static void main(String[] args) {
        try {
            ChatServer server = new ChatServer("RL");
            server.init();
            server.loop();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ChatServer(String masterName) {
        this.owner = masterName;
        this.userManager.setMasterName(masterName);
    }

    public void init() throws Exception {
        Configuration conf = ConfigLoader.getInstance().load();
        Iterator iter = conf.pluginIterator();
        while (iter.hasNext()) {
            Plugin plugin = (Plugin)iter.next();
            try {
                ServerPlugin serverPlugin = plugin.getServerPlugin();
                serverPlugin.init(this);
                this.addPlugin(serverPlugin);
            }
            catch (Exception e) {
                this.log.error((Object)plugin.getPluginId(), (Throwable)e);
            }
        }
        ServerAction[] actions = new ServerAction[]{new LoginServerAction(), new LogoutServerAction(), new ChatServerAction(), new WritingServerAction(), new ActivatePluginAction(), new SetGMAction()};
        int i = 0;
        while (i < actions.length) {
            actions[i].init(this, this);
            ++i;
        }
        this.addAction("login", actions[0]);
        this.addAction("logout", actions[1]);
        this.addAction("chat", actions[2]);
        this.addAction("writing", actions[3]);
        this.addAction("activateplugin", actions[4]);
        this.addAction("setgm", actions[5]);
    }

    public void loop() {
        Thread thread = new Thread(new Runnable(){

            public void run() {
                Socket socket = null;
                Configuration conf = ConfigLoader.getInstance().load();
                try {
                    ChatServer.this.serverSocket = new ServerSocket();
                    InetSocketAddress address = new InetSocketAddress(conf.getPort());
                    ChatServer.this.serverSocket.bind(address);
                    ChatServer.this.notifyServerStarted();
                }
                catch (BindException e) {
                    ChatServer.this.notifyFailedToStartServer();
                    return;
                }
                catch (IOException e) {
                    ChatServer.this.log.error((Object)"loop", (Throwable)e);
                    ChatServer.this.notifyErrorOccured();
                    return;
                }
                try {
                    while (true) {
                        socket = ChatServer.this.serverSocket.accept();
                        ClientProxy proxy = new ClientProxy();
                        proxy.init(ChatServer.this, socket);
                        ChatServer.this.addProxy(proxy);
                        proxy.start();
                    }
                }
                catch (BindException e) {
                    ChatServer.this.log.error((Object)"bind", (Throwable)e);
                    ChatServer.this.notifyErrorOccured();
                }
                catch (SocketException e) {
                    if (e.getMessage().equalsIgnoreCase("socket closed")) {
                        ChatServer.this.notifyServerStopped();
                    } else {
                        ChatServer.this.log.error((Object)"loop", (Throwable)e);
                    }
                    try {
                        socket.close();
                        ChatServer.this.serverSocket.close();
                    }
                    catch (IOException e1) {
                        ChatServer.this.log.debug((Object)"loop", (Throwable)e);
                    }
                }
                catch (IOException e) {
                    ChatServer.this.log.error((Object)"loop", (Throwable)e);
                    ChatServer.this.notifyErrorOccured();
                }
            }
        }, "server-loop");
        thread.start();
    }

    public void sendLog(String[] logs) {
        this.sendLog(logs, null);
    }

    public void sendLog(String[] logs, ClientProxy proxy) {
        ClientProxy[] proxies = this.proxyList.toArray(new ClientProxy[this.proxyList.size()]);
        int i = 0;
        while (i < proxies.length) {
            if (proxy == null || proxy != proxies[i]) {
                proxies[i].sendMessage(logs);
            }
            ++i;
        }
    }

    public void sendStatus(ClientProxy proxy) {
        User[] users = this.userManager.getAllUsers();
        String[] message = new String[users.length * 3 + 1];
        message[0] = "status";
        int i = 0;
        while (i < users.length) {
            message[i * 3 + 1] = users[i].getDisplayName();
            String string = message[i * 3 + 2] = users[i].isWriting() ? "y" : "n";
            if (this.primaryPlugin != null) {
                message[i * 3 + 3] = this.primaryPlugin.getUserStatus(users[i]);
                if (message[i * 3 + 3] == null || message[i * 3 + 3].length() == 0) {
                    message[i * 3 + 3] = " ";
                }
            }
            ++i;
        }
        proxy.sendMessage(message);
    }

    public void sendStatus() {
        ClientProxy[] proxies = this.proxyList.toArray(new ClientProxy[this.proxyList.size()]);
        int i = 0;
        while (i < proxies.length) {
            this.sendStatus(proxies[i]);
            ++i;
        }
    }

    public boolean addProxy(ClientProxy proxy) {
        return this.proxyList.add(proxy);
    }

    public boolean removeProxy(ClientProxy proxy) {
        if (this.proxyList.remove(proxy)) {
            this.userManager.logout(proxy.getName());
            this.sendStatus();
            return true;
        }
        return false;
    }

    public Iterator getProxyIterator() {
        return this.proxyList.iterator();
    }

    public boolean execute(ClientProxy proxy, String[] lines) throws IOException {
        try {
            ServerAction command = this.getAction(lines[0]);
            ServerAction pluginCommand = this.getPluginAction(lines[0]);
            ActionResult result = ActionResult.NULL;
            if (pluginCommand != null) {
                result = pluginCommand.getExecutionTime().execute(command, pluginCommand, lines, proxy);
            } else if (command != null) {
                result = command.execute(lines, proxy);
            }
            if (result == ActionResult.DISCONNECT) {
                this.proxyList.remove(proxy);
                this.userManager.logout(proxy.getName());
                proxy.sendDisconnect();
                this.sendLog(lines);
                this.sendStatus();
                return false;
            }
            return true;
        }
        catch (Exception e) {
            this.log.error((Object)"execute", (Throwable)e);
            this.notifyErrorOccured();
            return true;
        }
    }

    public ClientProxy getProxy(String name) {
        Iterator iter = this.proxyList.iterator();
        while (iter.hasNext()) {
            ClientProxy proxy = (ClientProxy)iter.next();
            if (!proxy.getName().equals(name)) continue;
            return proxy;
        }
        return null;
    }

    public void stop() {
        ClientProxy[] proxies = this.proxyList.toArray(new ClientProxy[this.proxyList.size()]);
        int i = 0;
        while (i < proxies.length) {
            proxies[i].sendDisconnect();
            ++i;
        }
        Thread thread = new Thread(new Runnable(){

            public void run() {
                while (ChatServer.this.proxyList.size() > 0) {
                    try {
                        Thread.sleep(3000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                try {
                    ChatServer.this.serverSocket.close();
                }
                catch (IOException e) {
                    ChatServer.this.log.error((Object)"server socket close", (Throwable)e);
                }
            }
        }, "server-waitToDestroyProxies");
        thread.start();
    }

    public boolean addServerListener(IServerListener listener) {
        return this.listenerList.add(listener);
    }

    public boolean removeServerListener(IServerListener listener) {
        return this.listenerList.remove(listener);
    }

    private void notifyServerStarted() {
        Iterator iter = this.listenerList.iterator();
        while (iter.hasNext()) {
            IServerListener listener = (IServerListener)iter.next();
            listener.serverStarted();
        }
    }

    public UserManager getUserManager() {
        return this.userManager;
    }

    public ServerPlugin getPrimaryPlugin() {
        return this.primaryPlugin;
    }

    public boolean setPrimaryPlugin(String pluginId) {
        ServerPlugin plugin = this.getPlugin(pluginId);
        if (plugin != null) {
            this.primaryPlugin = plugin;
            return true;
        }
        return false;
    }

    public void save(String fileName) {
        Properties properties = new Properties();
        this.setProperties(properties);
        if (this.primaryPlugin != null) {
            this.primaryPlugin.setProperties(properties);
        }
        FileOutputStream stream = null;
        try {
            stream = new FileOutputStream(fileName);
            properties.store(stream, null);
        }
        catch (IOException e) {
            this.log.error((Object)"save", (Throwable)e);
            this.notifyErrorOccured();
        }
    }

    public void load(String fileName) {
        Properties properties = new Properties();
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(fileName);
            properties.load(stream);
        }
        catch (IOException e) {
            this.notifyErrorOccured();
            this.log.error((Object)"save", (Throwable)e);
        }
        this.getProperties(properties);
        if (this.primaryPlugin != null) {
            this.primaryPlugin.getProperties(properties);
        }
        this.sendStatus();
        if (this.primaryPlugin != null) {
            Iterator iter = this.getProxyIterator();
            while (iter.hasNext()) {
                ClientProxy proxy = (ClientProxy)iter.next();
                this.primaryPlugin.sendPluginStatus(proxy);
            }
            this.primaryPlugin.sendPluginStatus();
        }
    }

    public void addPlugin(ServerPlugin newPlugin) {
        this.pluginMap.put(newPlugin.getPluginId(), newPlugin);
    }

    public ServerPlugin getPlugin(String name) {
        return (ServerPlugin)this.pluginMap.get(name);
    }

    public String getPluginId() {
        return "jp.sourceforge.chaplet.core";
    }

    public ServerAction getPluginAction(String actionName) {
        ServerAction action;
        if (this.primaryPlugin != null && (action = this.primaryPlugin.getAction(actionName)) != null) {
            return action;
        }
        Iterator iter = this.pluginMap.keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            ServerPlugin plugin = (ServerPlugin)this.pluginMap.get(key);
            ServerAction action2 = plugin.getAction(actionName);
            if (action2 == null) continue;
            return action2;
        }
        return null;
    }

    private void notifyErrorDisconnect() {
        Iterator iter = this.listenerList.iterator();
        while (iter.hasNext()) {
            IServerListener listener = (IServerListener)iter.next();
            listener.connectionClosedByError();
        }
    }

    private void notifyServerStopped() {
        Iterator iter = this.listenerList.iterator();
        while (iter.hasNext()) {
            IServerListener listener = (IServerListener)iter.next();
            listener.serverStopped();
        }
    }

    private void notifyErrorOccured() {
        Iterator iter = this.listenerList.iterator();
        while (iter.hasNext()) {
            IServerListener listener = (IServerListener)iter.next();
            listener.errorOccured();
        }
    }

    private void notifyFailedToStartServer() {
        Iterator iter = this.listenerList.iterator();
        while (iter.hasNext()) {
            IServerListener listener = (IServerListener)iter.next();
            listener.failedToStartServer();
        }
    }

    public void reload() throws Exception {
        Iterator iter = this.pluginMap.keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            ServerPlugin plugin = (ServerPlugin)this.pluginMap.get(key);
            plugin.reload();
        }
    }

    public String getOwner() {
        return this.owner;
    }

    public Iterator getPluginIterator() {
        return this.pluginMap.values().iterator();
    }
}

