/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.chaplet.core.server;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;
import java.util.LinkedList;
import jp.sourceforge.chaplet.NetUtil;
import jp.sourceforge.chaplet.core.server.ChatServer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ClientProxy {
    private ChatServer server;
    private Socket socket;
    private LinkedList messageQueue = new LinkedList();
    private BufferedWriter writer;
    private BufferedReader reader;
    private String name;
    private Log log = LogFactory.getLog(this.getClass());
    private Thread mainThread;

    public void init(ChatServer server, Socket socket) throws IOException {
        this.server = server;
        this.socket = socket;
        this.writer = NetUtil.getWriter(socket);
        this.reader = NetUtil.getReader(socket);
    }

    public void start() {
        this.mainThread = new Thread(new Runnable(){

            public void run() {
                ClientProxy.this.messageLoop();
            }
        }, "server-messageLoop");
        Thread recieveThread = new Thread(new Runnable(){

            public void run() {
                ClientProxy.this.recieveLoop();
            }
        }, "server-recieveLoop");
        this.mainThread.start();
        recieveThread.start();
    }

    public void sendDisconnect() {
        this.sendMessage(new String[]{"disconnect"});
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void destroy() throws IOException {
        try {
            this.socket.shutdownInput();
            this.socket.shutdownOutput();
            this.reader.read();
            this.reader.close();
            this.writer.close();
            this.mainThread.interrupt();
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.socket.close();
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        this.socket.close();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public synchronized void sendMessage(String[] message) {
        this.messageQueue.addLast(message);
        this.notifyAll();
    }

    private void recieveLoop() {
        block5: {
            while (true) {
                try {
                    String[] line = NetUtil.getRequest(this.reader);
                    if (line == null || line.length == 0) break;
                    this.server.execute(this, line);
                }
                catch (Exception e) {
                    if (e instanceof SocketException && (e.getMessage().equals("socket closed") || e.getMessage().equals("Connection reset"))) break;
                    this.log.error((Object)"recieveLoop", (Throwable)e);
                    break;
                }
            }
            this.server.removeProxy(this);
            try {
                this.destroy();
            }
            catch (IOException e1) {
                if (e1.getMessage().equals("Socket is closed")) break block5;
                this.log.error((Object)"recieveLoop", (Throwable)e1);
            }
        }
    }

    private void messageLoop() {
        while (true) {
            String[] request = null;
            ClientProxy clientProxy = this;
            synchronized (clientProxy) {
                while (this.messageQueue.size() == 0) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                }
                if (this.messageQueue.size() == 0) {
                    return;
                }
                request = (String[])this.messageQueue.removeFirst();
                this.notifyAll();
            }
            try {
                int i = 0;
                while (i < request.length) {
                    NetUtil.writeLine(this.writer, request[i]);
                    ++i;
                }
                this.writer.write(46);
                this.writer.newLine();
                this.writer.flush();
            }
            catch (Exception e) {
                this.log.error((Object)request[0], (Throwable)e);
                this.server.removeProxy(this);
                return;
            }
        }
    }
}

