/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.chaplet;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.util.ArrayList;
import jp.sourceforge.chaplet.ChatUtils;

public final class NetUtil {
    public static BufferedReader getReader(Socket socket) throws IOException {
        InputStream inputStream = socket.getInputStream();
        return new BufferedReader(new InputStreamReader(inputStream));
    }

    public static BufferedWriter getWriter(Socket socket) throws IOException {
        OutputStream outputStream = socket.getOutputStream();
        return new BufferedWriter(new OutputStreamWriter(outputStream));
    }

    public static String[] getRequest(BufferedReader reader) throws IOException {
        ArrayList<String> list = new ArrayList<String>();
        String line;
        while ((line = reader.readLine()) != null && !line.equals(".")) {
            if (line.startsWith("..")) {
                line = line.substring(1);
            }
            list.add(line);
        }
        return list.toArray(new String[list.size()]);
    }

    public static void writeLine(BufferedWriter writer, String message) throws IOException {
        String[] lines = ChatUtils.split(message, "\r\n");
        int i = 0;
        while (i < lines.length) {
            if (lines[i].equals(".")) {
                lines[i] = "..";
            }
            writer.write(lines[i]);
            writer.newLine();
            ++i;
        }
    }
}

