/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.chaplet.core.client;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeMap;
import jp.sourceforge.chaplet.ActionResult;
import jp.sourceforge.chaplet.ConfigLoader;
import jp.sourceforge.chaplet.Configuration;
import jp.sourceforge.chaplet.Plugin;
import jp.sourceforge.chaplet.UserStatus;
import jp.sourceforge.chaplet.core.client.ActivatePluginAction;
import jp.sourceforge.chaplet.core.client.ChatClientAction;
import jp.sourceforge.chaplet.core.client.ChatConnection;
import jp.sourceforge.chaplet.core.client.ClientAction;
import jp.sourceforge.chaplet.core.client.ClientPlugin;
import jp.sourceforge.chaplet.core.client.DisconnectAction;
import jp.sourceforge.chaplet.core.client.IChatListener;
import jp.sourceforge.chaplet.core.client.LoginAction;
import jp.sourceforge.chaplet.core.client.LogoutAction;
import jp.sourceforge.chaplet.core.client.SetGMAction;
import jp.sourceforge.chaplet.core.client.StatusAction;
import jp.sourceforge.chaplet.core.server.ChatServer;
import jp.sourceforge.chaplet.core.server.IServerListener;
import jp.sourceforge.chaplet.core.server.ServerPlugin;
import jp.sourceforge.chaplet.core.ui.IMainView;
import jp.sourceforge.chaplet.core.ui.IPluginView;
import jp.sourceforge.chaplet.core.ui.MainForm;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.MessageBox;

public class ChatClient
extends ClientPlugin {
    private MainForm form;
    private ChatConnection connection;
    private ChatServer server;
    private boolean isServer;
    private TreeMap pluginMap = new TreeMap();
    private Log log = LogFactory.getLog(this.getClass());
    private UserStatus[] status;

    public ChatClient() {
        ClientAction[] actions = new ClientAction[]{new ChatClientAction(), new LoginAction(), new LogoutAction(), new StatusAction(), new ActivatePluginAction(), new DisconnectAction(), new SetGMAction()};
        int i = 0;
        while (i < actions.length) {
            actions[i].init(this, this);
            ++i;
        }
        this.addAction("chat", actions[0]);
        this.addAction("login", actions[1]);
        this.addAction("logout", actions[2]);
        this.addAction("status", actions[3]);
        this.addAction("activateplugin", actions[4]);
        this.addAction("disconnect", actions[5]);
        this.addAction("setgm", actions[6]);
    }

    public void init() throws IOException {
        Configuration conf = ConfigLoader.getInstance().load();
        Iterator iter = conf.pluginIterator();
        while (iter.hasNext()) {
            Plugin plugin = (Plugin)iter.next();
            try {
                ClientPlugin clientPlugin = plugin.getClientPlugin();
                clientPlugin.init(this);
                this.addPlugin(clientPlugin);
            }
            catch (Exception e) {
                this.log.error((Object)plugin.getPluginId(), (Throwable)e);
            }
        }
        this.connection = new ChatConnection();
        this.connection.addChatListener(new IChatListener(){

            public void messageRecieved(String[] message) {
                ClientAction command = ChatClient.this.getAction(message[0]);
                ClientAction pluginCommand = ChatClient.this.getPluginAction(message[0]);
                ActionResult result = ActionResult.NULL;
                if (pluginCommand != null) {
                    result = pluginCommand.getExecutionTime().messageRecieved(command, pluginCommand, message);
                } else if (command != null) {
                    result = command.messageRecieved(message);
                }
                if (result == ActionResult.DISCONNECT) {
                    ChatClient.this.disconnect();
                }
            }

            public void responseRecieved(String[] response) {
                Configuration conf = ConfigLoader.getInstance().load();
                ClientAction command = ChatClient.this.getAction(response[0].substring(3));
                ClientAction pluginCommand = ChatClient.this.getPluginAction(response[0].substring(3));
                ActionResult result = ActionResult.NULL;
                if (pluginCommand != null) {
                    result = pluginCommand.getExecutionTime().responseRecieved(command, pluginCommand, response);
                } else if (command != null) {
                    result = command.responseRecieved(response);
                }
                if (result == ActionResult.DISCONNECT) {
                    ChatClient.this.disconnect();
                }
            }

            public void connectionEstablished(String serverName) {
                ChatClient.this.form.setStatus("\u63a5\u7d9a\u4e2d");
                ChatClient.this.form.setMessage(String.valueOf(serverName) + " \u306b\u63a5\u7d9a\u3057\u307e\u3057\u305f\u3002");
            }

            public void connectionClosed() {
                ChatClient.this.form.setStatus("");
                ChatClient.this.form.setMessage("\u30b5\u30fc\u30d0\u3068\u306e\u63a5\u7d9a\u3092\u9589\u3058\u307e\u3057\u305f\u3002");
                ChatClient.this.form.setLoginOK(false);
            }

            public void connectionClosedByError() {
                ChatClient.this.form.setStatus("");
                ChatClient.this.form.setMessage("\u30b5\u30fc\u30d0\u3068\u306e\u901a\u4fe1\u304c\u5207\u308c\u307e\u3057\u305f\u3002");
                ChatClient.this.form.setLoginOK(false);
            }

            public void errorOccured() {
                ChatClient.this.form.setStatus("\u30a8\u30e9\u30fc\uff01");
                ChatClient.this.form.setMessage("\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002\u8a73\u7d30\u306f\u30ed\u30b0\u30d5\u30a1\u30a4\u30eb\u3092\u78ba\u8a8d\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
            }
        });
    }

    public synchronized boolean login() {
        Configuration conf = ConfigLoader.getInstance().load();
        if (conf.getUrl() == null || conf.getUrl().length() == 0) {
            this.form.setMessage("\u63a5\u7d9a\u5931\u6557\u3067\u3059\u3002\u5148\u306b\u30b5\u30fc\u30d0\u306e\u30a2\u30c9\u30ec\u30b9\u3092\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
            return false;
        }
        if (conf.getName() == null || conf.getName().length() == 0) {
            this.form.setMessage("\u63a5\u7d9a\u5931\u6557\u3067\u3059\u3002\u5148\u306b\u3042\u306a\u305f\u306e\u540d\u524d\u3092\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
            return false;
        }
        try {
            this.connection.connect(conf.getUrl(), 10001, conf.getName());
            return true;
        }
        catch (Exception e) {
            this.form.setMessage("\u30b5\u30fc\u30d0 " + conf.getUrl() + " \u3078\u306e\u63a5\u7d9a\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
            this.log.error((Object)"login", (Throwable)e);
            return false;
        }
    }

    private void disconnect() {
        this.connection.close();
        Configuration conf = ConfigLoader.getInstance().load();
        if (!this.form.isDisposed()) {
            this.form.appendSystemLog(String.valueOf(conf.getName()) + " \u3055\u3093\u304c\u30ed\u30b0\u30a2\u30a6\u30c8\u3057\u307e\u3057\u305f\u3002");
            this.form.setLoginOK(false);
        }
    }

    public synchronized boolean logout() {
        Thread thread = new Thread(new Runnable(){

            public void run() {
                try {
                    if (ChatClient.this.isServer) {
                        ChatClient.this.isServer = false;
                        ChatClient.this.server.stop();
                    } else {
                        Configuration conf = ConfigLoader.getInstance().load();
                        ChatClient.this.connection.sendMessage(new String[]{"logout", conf.getName()});
                    }
                }
                catch (Exception e) {
                    ChatClient.this.log.error((Object)"logout", (Throwable)e);
                }
            }
        });
        thread.start();
        return false;
    }

    public synchronized void chat(String subName, String message, boolean handleVisible) {
        try {
            Configuration conf = ConfigLoader.getInstance().load();
            String name = conf.getName();
            if (subName != null && subName.length() > 0) {
                name = handleVisible ? String.valueOf(name) + "/" + subName : subName;
            }
            this.connection.sendMessage(new String[]{"chat", name, message});
        }
        catch (Exception e) {
            this.log.error((Object)"chat", (Throwable)e);
            return;
        }
    }

    public boolean isGM() {
        Configuration conf = ConfigLoader.getInstance().load();
        return conf.isGM();
    }

    public void setView(MainForm form) {
        this.form = form;
        Configuration conf = ConfigLoader.getInstance().load();
        Iterator iter = this.pluginMap.keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            ClientPlugin clientPlugin = (ClientPlugin)this.pluginMap.get(key);
            clientPlugin.initSWT(form);
            form.addPluginView(clientPlugin.getPluginView());
            String state = conf.getDefaultViewState(clientPlugin.getPluginView());
            if (state.equals("tab")) {
                form.showAsTabItem(clientPlugin.getPluginView());
                continue;
            }
            if (!state.equals("window")) continue;
            form.showAsWindow(clientPlugin.getPluginView());
        }
    }

    public boolean writing(boolean w, String alias) {
        if (alias == null || alias.length() == 0) {
            this.connection.sendMessage(new String[]{"writing", w ? "y" : "n"});
        } else {
            this.connection.sendMessage(new String[]{"writing", w ? "y" : "n", alias});
        }
        return true;
    }

    public void startServer() {
        Configuration conf = ConfigLoader.getInstance().load();
        conf.setUrl("127.0.0.1");
        if (conf.getName() == null || conf.getName().length() == 0) {
            this.form.setMessage("\u63a5\u7d9a\u5931\u6557\u3067\u3059\u3002\u5148\u306b\u3042\u306a\u305f\u306e\u540d\u524d\u3092\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
            return;
        }
        Thread thread = new Thread(new Runnable(){

            public void run() {
                Configuration conf = ConfigLoader.getInstance().load();
                try {
                    ChatClient.this.server = new ChatServer(conf.getName());
                    ChatClient.this.server.addServerListener(new IServerListener(this){
                        final /* synthetic */ 3 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void serverStarted() {
                            ChatClient.access$2(3.access$0(this.this$1)).appendSystemLog("\u30b5\u30fc\u30d0\u3092\u958b\u59cb\u3057\u307e\u3057\u305f\u3002");
                            3.access$0(this.this$1).login();
                        }

                        public void connectionClosedByError() {
                            ChatClient.access$2(3.access$0(this.this$1)).setMessage("\u30b5\u30fc\u30d0\u304c\u5f37\u5236\u7d42\u4e86\u3057\u307e\u3057\u305f\u3002\u30b5\u30fc\u30d0\u306e\u518d\u8d77\u52d5\u304c\u3067\u304d\u307e\u3059\u3002");
                        }

                        public void errorOccured() {
                            ChatClient.access$2(3.access$0(this.this$1)).setMessage("\u30b5\u30fc\u30d0\u3067\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002");
                        }

                        public void serverStopped() {
                            if (!ChatClient.access$2(3.access$0(this.this$1)).isDisposed()) {
                                ChatClient.access$2(3.access$0(this.this$1)).appendSystemLog("\u30b5\u30fc\u30d0\u3092\u7d42\u4e86\u3057\u307e\u3057\u305f\u3002");
                                ChatClient.access$2(3.access$0(this.this$1)).setMessage("\u30b5\u30fc\u30d0\u3092\u7d42\u4e86\u3057\u307e\u3057\u305f\u3002");
                                ChatClient.access$2(3.access$0(this.this$1)).setStatus("");
                                ChatClient.access$2(3.access$0(this.this$1)).setLoginOK(false);
                            }
                        }

                        public void failedToStartServer() {
                            ChatClient.access$2(3.access$0(this.this$1)).setMessage("\u30b5\u30fc\u30d0\u306e\u958b\u59cb\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
                        }
                    });
                    ChatClient.this.server.init();
                    ChatClient.this.server.setPrimaryPlugin("jp.sourceforge.chaplet.nova");
                    ChatClient.this.server.loop();
                    ChatClient.this.isServer = true;
                }
                catch (Exception e) {
                    ChatClient.this.log.error((Object)"startServer", (Throwable)e);
                    ChatClient.this.form.setMessage("\u30b5\u30fc\u30d0\u306e\u958b\u59cb\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
                }
            }

            static /* synthetic */ ChatClient access$0(3 var0) {
                return var0.ChatClient.this;
            }
        });
        thread.start();
    }

    public void initSWT(Composite parent) {
        this.form = new MainForm(parent, 0);
    }

    public Composite getSWTComponent() {
        return this.form;
    }

    public void setView(IMainView form) {
        this.form = (MainForm)form;
    }

    public IMainView getView() {
        return this.form;
    }

    protected ChatConnection getConnection() {
        return this.connection;
    }

    public IPluginView getPluginView() {
        return this.form;
    }

    public void loadServerSetting(final String fileName) {
        Thread thread = new Thread(new Runnable(){

            public void run() {
                ChatClient.this.server.load(fileName);
                ChatClient.this.form.getDisplay().asyncExec(new Runnable(this){
                    final /* synthetic */ 5 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        MessageBox dialog = new MessageBox(ChatClient.access$2(5.access$0(this.this$1)).getShell());
                        dialog.setText("Chaplet Platform");
                        dialog.setMessage("\u30ed\u30fc\u30c9\u306b\u6210\u529f\u3057\u307e\u3057\u305f\u3002");
                        dialog.open();
                    }
                });
            }

            static /* synthetic */ ChatClient access$0(5 var0) {
                return var0.ChatClient.this;
            }
        });
        thread.start();
    }

    public void saveServerSetting(final String fileName) {
        Thread thread = new Thread(new Runnable(){

            public void run() {
                ChatClient.this.server.save(fileName);
                ChatClient.this.form.getDisplay().asyncExec(new Runnable(this){
                    final /* synthetic */ 7 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        MessageBox dialog = new MessageBox(ChatClient.access$2(7.access$0(this.this$1)).getShell());
                        dialog.setText("Chaplet Platform");
                        dialog.setMessage("\u30bb\u30fc\u30d6\u306b\u6210\u529f\u3057\u307e\u3057\u305f\u3002");
                        dialog.open();
                    }
                });
            }

            static /* synthetic */ ChatClient access$0(7 var0) {
                return var0.ChatClient.this;
            }
        });
        thread.start();
    }

    public String getPluginId() {
        return "jp.sourceforge.chaplet.core";
    }

    public ClientPlugin getPlugin(String pluginId) {
        return (ClientPlugin)this.pluginMap.get(pluginId);
    }

    public void addPlugin(ClientPlugin clientPlugin) {
        this.pluginMap.put(clientPlugin.getPluginId(), clientPlugin);
    }

    private ClientAction getPluginAction(String actionName) {
        Iterator iter = this.pluginMap.keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            ClientPlugin plugin = (ClientPlugin)this.pluginMap.get(key);
            ClientAction action = plugin.getAction(actionName);
            if (action == null) continue;
            return action;
        }
        return null;
    }

    public void activatePlugin(String pluginId) {
        this.connection.sendMessage(new String[]{"activateplugin", pluginId});
    }

    public Iterator pluginIterator() {
        return this.pluginMap.values().iterator();
    }

    public void reload() {
        try {
            this.server.reload();
        }
        catch (Exception e) {
            this.form.setMessage("\u30b5\u30fc\u30d0\u306e\u8a2d\u5b9a\u306e\u518d\u8aad\u8fbc\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
            this.log.error((Object)"reload", (Throwable)e);
        }
    }

    public void showStatus(UserStatus[] status) {
        this.status = status;
        this.form.showStatus(status);
    }

    public UserStatus[] getStatus() {
        return this.status;
    }

    public void destroy() {
        Iterator iter = this.pluginMap.values().iterator();
        while (iter.hasNext()) {
            ClientPlugin plugin = (ClientPlugin)iter.next();
            plugin.destroy();
        }
    }

    public void setGM(boolean gm) {
        ConfigLoader.getInstance().load().setGM(gm);
        super.setGM(gm);
        Iterator iter = this.pluginMap.values().iterator();
        while (iter.hasNext()) {
            ClientPlugin plugin = (ClientPlugin)iter.next();
            plugin.setGM(gm);
        }
    }

    public void callSetGM(String name) {
        this.getConnection().sendMessage(new String[]{"setgm", name});
    }

    public ArrayList getPluginList() {
        if (this.isServer && this.server != null) {
            ArrayList list = new ArrayList();
            Iterator iter = this.server.getPluginIterator();
            while (iter.hasNext()) {
                ServerPlugin plugin = (ServerPlugin)iter.next();
                String[] stringArray = new String[2];
            }
            return list;
        }
        return null;
    }
}

