/*
 * Decompiled with CFR 0.152.
 */
package application;

import application.AbstractBean;
import application.Action;
import application.ApplicationContext;
import application.ProxyActions;
import application.ResourceMap;
import application.Task;
import java.awt.ActiveEvent;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.PaintEvent;
import java.util.EventListener;
import java.util.EventObject;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ProxyActions(value={"cut", "copy", "paste", "delete"})
public abstract class Application
extends AbstractBean {
    private static final Logger logger = Logger.getLogger(Application.class.getName());
    private final List<ExitListener> exitListeners = new CopyOnWriteArrayList<ExitListener>();

    public static synchronized void launch(final Class<? extends Application> applicationClass, final String[] args) {
        Runnable doCreateAndShowGUI = new Runnable(){

            public void run() {
                try {
                    ApplicationContext ac = ApplicationContext.getInstance();
                    ac.setApplicationClass(applicationClass);
                    Application.initBeforeApplicationConstructed();
                    Application application = (Application)applicationClass.newInstance();
                    ac.setApplication(application);
                    application.initialize(args);
                    application.startup();
                    Application application2 = application;
                    application2.getClass();
                    application2.new DoWaitForEmptyEventQ().execute();
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Application failed to launch", e);
                }
            }
        };
        SwingUtilities.invokeLater(doCreateAndShowGUI);
    }

    private static void initBeforeApplicationConstructed() {
        try {
            System.setProperty("java.net.useSystemProxies", "true");
        }
        catch (SecurityException ignoreException) {
            // empty catch block
        }
        ApplicationContext ac = ApplicationContext.getInstance();
        ResourceMap appResourceMap = ac.getResourceMap();
        String key = "Application.lookAndFeel";
        String lnfResource = appResourceMap.getString(key, new Object[0]);
        String lnf = lnfResource == null ? "system" : lnfResource;
        try {
            if (lnf.equalsIgnoreCase("system")) {
                String name = UIManager.getSystemLookAndFeelClassName();
                UIManager.setLookAndFeel(name);
            } else if (!lnf.equalsIgnoreCase("default")) {
                UIManager.setLookAndFeel(lnf);
            }
        }
        catch (Exception e) {
            String s = "Couldn't set LookandFeel " + key + " = \"" + lnfResource + "\"";
            logger.log(Level.WARNING, s, e);
        }
    }

    protected void initialize(String[] args) {
    }

    protected abstract void startup();

    protected void ready() {
    }

    protected void shutdown() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForEmptyEventQ() {
        boolean qEmpty = false;
        JPanel placeHolder = new JPanel();
        EventQueue q = Toolkit.getDefaultToolkit().getSystemEventQueue();
        while (!qEmpty) {
            NotifyingEvent e = new NotifyingEvent(placeHolder);
            q.postEvent(e);
            NotifyingEvent notifyingEvent = e;
            synchronized (notifyingEvent) {
                while (!e.isDispatched()) {
                    try {
                        e.wait();
                    }
                    catch (InterruptedException ie) {}
                }
                qEmpty = e.isEventQEmpty();
            }
        }
    }

    public final void exit() {
        this.exit(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exit(EventObject event) {
        for (ExitListener listener : this.exitListeners) {
            if (listener.canExit(event)) continue;
            return;
        }
        try {
            for (ExitListener listener : this.exitListeners) {
                try {
                    listener.willExit(event);
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "ExitListener.willExit() failed", e);
                }
            }
            this.shutdown();
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "unexpected error in Application.shutdown()", e);
        }
        finally {
            System.exit(0);
        }
    }

    public void addExitListener(ExitListener listener) {
        this.exitListeners.add(listener);
    }

    public void removeExitListener(ExitListener listener) {
        this.exitListeners.remove(listener);
    }

    public ExitListener[] getExitListeners() {
        int size = this.exitListeners.size();
        return this.exitListeners.toArray(new ExitListener[size]);
    }

    @Action
    public void quit(ActionEvent e) {
        this.exit(e);
    }

    public static interface ExitListener
    extends EventListener {
        public boolean canExit(EventObject var1);

        public void willExit(EventObject var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DoWaitForEmptyEventQ
    extends Task<Void, Void> {
        private DoWaitForEmptyEventQ() {
        }

        protected Void doInBackground() {
            Application.this.waitForEmptyEventQ();
            return null;
        }

        @Override
        protected void finished() {
            Application.this.ready();
        }
    }

    private static class NotifyingEvent
    extends PaintEvent
    implements ActiveEvent {
        private boolean dispatched = false;
        private boolean qEmpty = false;

        NotifyingEvent(Component c) {
            super(c, 801, null);
        }

        synchronized boolean isDispatched() {
            return this.dispatched;
        }

        synchronized boolean isEventQEmpty() {
            return this.qEmpty;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dispatch() {
            EventQueue q = Toolkit.getDefaultToolkit().getSystemEventQueue();
            NotifyingEvent notifyingEvent = this;
            synchronized (notifyingEvent) {
                this.qEmpty = q.peekEvent() == null;
                this.dispatched = true;
                this.notifyAll();
            }
        }
    }
}

