/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.chaplet.core.server;

import java.util.HashMap;
import java.util.Properties;
import jp.sf.chaplet.core.server.ChatServer;
import jp.sf.chaplet.core.server.ClientProxy;
import jp.sf.chaplet.core.server.ServerAction;
import jp.sf.chaplet.core.server.User;

public abstract class ServerPlugin {
    protected ChatServer server;
    private HashMap<String, ServerAction> actionMap = new HashMap();

    public final void init(ChatServer server) throws Exception {
        this.server = server;
        this.init();
    }

    public void init() throws Exception {
    }

    public void destroy() throws Exception {
    }

    public void save() throws Exception {
    }

    protected void addAction(String name, ServerAction action) {
        this.actionMap.put(name, action);
    }

    protected void removeAction(String name) {
        this.actionMap.remove(name);
    }

    protected ServerAction getAction(String name) {
        return this.actionMap.get(name);
    }

    public String getUserStatus(User user) {
        return "";
    }

    public void setProperties(Properties properties) {
    }

    public void getProperties(Properties properties) {
    }

    public void sendPluginStatus(ClientProxy proxy) {
    }

    public void sendPluginStatus() {
    }

    public abstract String getPluginId();

    public void reload() throws Exception {
    }
}

