/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.chaplet.dx;

import java.util.ArrayList;
import java.util.Random;
import jp.sf.chaplet.dx.DiceResult;
import jp.sf.chaplet.dx.DiceRoll;

public class DiceRoller {
    private Random random = new Random(System.currentTimeMillis());
    private static DiceRoller instance = new DiceRoller();
    private int maxCritical = 50;

    public static DiceRoller getInstance() {
        return instance;
    }

    public DiceResult rollDamage(DiceRoll roll) {
        DiceResult result = new DiceResult();
        ArrayList<Integer> diceList = new ArrayList<Integer>();
        int i = 0;
        while (i < roll.getNumDice()) {
            int num = this.random.nextInt(10) + 1;
            diceList.add(num);
            result.addSum(num);
            ++i;
        }
        result.setBonus(roll.getBonus());
        result.getDiceList().add(diceList);
        result.addSum(roll.getBonus());
        return result;
    }

    public DiceResult rollSum(DiceRoll roll) {
        DiceResult result = new DiceResult();
        result.setBonus(roll.getBonus());
        this.rollSumRec(roll.getNumDice(), roll, result);
        return result;
    }

    private void rollSumRec(int numDice, DiceRoll roll, DiceResult result) {
        int critical = 0;
        int max = 0;
        ArrayList<Integer> diceList = new ArrayList<Integer>();
        int i = 0;
        while (i < numDice) {
            int num = this.random.nextInt(10) + 1;
            diceList.add(num);
            if (num >= roll.getCritical()) {
                ++critical;
            }
            if (max < num) {
                max = num;
            }
            ++i;
        }
        result.getDiceList().add(diceList);
        if (critical > 0 && result.getCriticalTime() < this.maxCritical) {
            result.addSum(10);
            this.rollSumRec(critical, roll, result);
        } else {
            result.addSum(max);
            result.addSum(roll.getBonus());
        }
    }
}

