/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.chaplet.nova;

public class Card {
    private int suite;
    private int rank;

    public Card(String s) {
        if (s.length() < 2) {
            this.suite = 4;
            this.rank = 0;
        } else {
            switch (s.charAt(0)) {
                case 'S': {
                    this.suite = 0;
                    break;
                }
                case 'C': {
                    this.suite = 1;
                    break;
                }
                case 'H': {
                    this.suite = 2;
                    break;
                }
                case 'D': {
                    this.suite = 3;
                    break;
                }
                default: {
                    this.suite = 4;
                    this.rank = 0;
                }
            }
            if (this.suite != 4) {
                switch (s.charAt(1)) {
                    case 'J': {
                        this.rank = 11;
                        break;
                    }
                    case 'Q': {
                        this.rank = 12;
                        break;
                    }
                    case 'K': {
                        this.rank = 13;
                        break;
                    }
                    case 'A': {
                        this.rank = 1;
                        break;
                    }
                    case 'T': {
                        this.rank = 10;
                        break;
                    }
                    default: {
                        this.rank = s.charAt(1) - 48;
                    }
                }
            }
        }
    }

    public Card(int suite, int rank) {
        this.suite = suite;
        this.rank = rank;
    }

    public int getRank() {
        return this.rank;
    }

    public void setRank(int rank) {
        this.rank = rank;
    }

    public int getSuite() {
        return this.suite;
    }

    public void setSuite(int suite) {
        this.suite = suite;
    }

    public boolean isRed() {
        return this.suite == 3 || this.suite == 2;
    }

    public String getRankString() {
        switch (this.rank) {
            case 1: {
                return "A";
            }
            case 11: {
                return "J";
            }
            case 12: {
                return "Q";
            }
            case 13: {
                return "K";
            }
            case 0: {
                return "JK";
            }
        }
        return String.valueOf(this.rank);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        switch (this.suite) {
            case 0: {
                sb.append('S');
                break;
            }
            case 1: {
                sb.append('C');
                break;
            }
            case 2: {
                sb.append('H');
                break;
            }
            case 3: {
                sb.append('D');
                break;
            }
        }
        switch (this.rank) {
            case 1: {
                sb.append('A');
                break;
            }
            case 11: {
                sb.append('J');
                break;
            }
            case 12: {
                sb.append('Q');
                break;
            }
            case 13: {
                sb.append('K');
                break;
            }
            case 10: {
                sb.append('T');
                break;
            }
            case 0: {
                sb.append("JK");
                break;
            }
            default: {
                sb.append(String.valueOf(this.rank));
            }
        }
        return sb.toString();
    }

    public boolean isJoker() {
        return this.suite == 4;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Card)) {
            return false;
        }
        Card card = (Card)obj;
        return this.rank == card.rank && this.suite == card.suite;
    }

    public int hashCode() {
        return this.suite * 13 + this.rank;
    }
}

