/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.chaplet.nova.server;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import jp.sf.chaplet.nova.NovaUtil;

public class Hand {
    private String name;
    private TreeMap<Integer, ArrayList<String>> cardMap = new TreeMap();

    public Hand() {
        this.cardMap.put(new Integer(0), new ArrayList());
    }

    public String handString() {
        StringBuffer sb = new StringBuffer("  ");
        for (Integer key : this.cardMap.keySet()) {
            if (key == 0) continue;
            ArrayList<String> list = this.cardMap.get(key);
            int numReaction = 0;
            for (String element : list) {
                if (element.length() <= 2 || element.charAt(2) != '_') continue;
                ++numReaction;
            }
            sb.append(list.size() - numReaction);
            if (numReaction > 0) {
                sb.append('(');
                sb.append(numReaction);
                sb.append(')');
            }
            sb.append('/');
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public boolean toProt(String[] card, int protNo) {
        ArrayList<String> hand = this.cardMap.get(new Integer(0));
        int i = 0;
        while (i < card.length) {
            if (!hand.contains(card[i])) {
                return false;
            }
            ++i;
        }
        ArrayList<String> plot = this.cardMap.get(new Integer(protNo));
        if (plot == null) {
            return false;
        }
        int i2 = 0;
        while (i2 < card.length) {
            plot.add(card[i2]);
            hand.remove(card[i2]);
            ++i2;
        }
        return true;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean addCard(int handNo, String card) {
        return this.cardMap.get(new Integer(handNo)).add(card);
    }

    public String[] getHand(int handNo) {
        ArrayList<String> cardList = this.cardMap.get(new Integer(handNo));
        if (cardList == null) {
            return null;
        }
        return cardList.toArray(new String[cardList.size()]);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.getName());
        for (Integer key : this.cardMap.keySet()) {
            ArrayList<String> cardList = this.cardMap.get(key);
            sb.append('[');
            sb.append(key);
            Iterator<String> iter = cardList.iterator();
            while (iter.hasNext()) {
                sb.append(',');
                sb.append(iter.next());
            }
            sb.append(']');
        }
        return sb.toString();
    }

    public boolean removeHand(int handNo) {
        return this.cardMap.remove(new Integer(handNo)) != null;
    }

    public int addHand() {
        int i = 0;
        while (true) {
            ArrayList<String> cardList;
            if ((cardList = this.cardMap.get(new Integer(i))) == null) {
                cardList = new ArrayList();
                this.cardMap.put(new Integer(i), cardList);
                return i;
            }
            ++i;
        }
    }

    public String getCard(int handNo, int index) {
        return this.cardMap.get(new Integer(handNo)).get(index);
    }

    public int getCardCount(int handNo) {
        return this.cardMap.get(new Integer(handNo)).size();
    }

    public String setCard(int handNo, int index, String card) {
        return this.cardMap.get(new Integer(handNo)).set(index, card);
    }

    public boolean removeCard(int handNo, String card) {
        ArrayList<String> cardList = this.cardMap.get(new Integer(handNo));
        if (cardList == null) {
            return false;
        }
        Iterator<String> iter = cardList.iterator();
        while (iter.hasNext()) {
            String aCard = iter.next();
            if (!aCard.equals(card)) continue;
            iter.remove();
            return true;
        }
        return false;
    }

    public int handSize() {
        return this.cardMap.size();
    }

    public boolean toReaction(int protNo, String card, boolean isReaction) {
        ArrayList<String> cardList = this.cardMap.get(new Integer(protNo));
        if (cardList == null) {
            return false;
        }
        int i = 0;
        while (i < cardList.size()) {
            String element = cardList.get(i);
            if (NovaUtil.isSameCard(element, card)) {
                if (isReaction) {
                    cardList.set(i, String.valueOf(card.substring(0, 2)) + '_');
                } else {
                    cardList.set(i, card.substring(0, 2));
                }
                return true;
            }
            ++i;
        }
        return false;
    }

    public int getProtOrder(int protNo) {
        int order = 0;
        Set<Integer> keySet = this.cardMap.keySet();
        for (Integer key : keySet) {
            if (key == protNo) {
                return order;
            }
            ++order;
        }
        if (order == keySet.size()) {
            return -1;
        }
        return order;
    }

    public void parse(String str) throws ParseException {
        StringTokenizer tokenizer = new StringTokenizer(str, "[]");
        try {
            this.name = tokenizer.nextToken();
            while (tokenizer.hasMoreTokens()) {
                String element = tokenizer.nextToken();
                StringTokenizer subTokenizer = new StringTokenizer(element, ",");
                int handNo = Integer.parseInt(subTokenizer.nextToken());
                if (!this.cardMap.containsKey(new Integer(handNo))) {
                    handNo = this.addHand();
                }
                while (subTokenizer.hasMoreTokens()) {
                    this.addCard(handNo, subTokenizer.nextToken());
                }
            }
        }
        catch (RuntimeException e) {
            throw new ParseException(e.getMessage(), 0);
        }
    }

    public int getNumPlot() {
        return this.cardMap.size() - 1;
    }

    public int[] getPlotNoList() {
        Set<Integer> set = this.cardMap.keySet();
        int[] plotNos = new int[set.size() - 1];
        int i = 0;
        for (Integer element : set) {
            if (element <= 0) continue;
            plotNos[i] = element;
            ++i;
        }
        return plotNos;
    }

    public void clear() {
        this.cardMap.clear();
        this.cardMap.put(new Integer(0), new ArrayList());
    }
}

