/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.chaplet.nova.server;

import java.util.HashMap;
import java.util.Map;
import jp.sf.chaplet.nova.server.Hand;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HandManager {
    private HashMap<String, Hand> handMap = new HashMap();
    private int maxHand = 4;

    public void getProperties(Map<String, Object> map) {
        for (String sessionId : this.handMap.keySet()) {
            Hand hand = this.handMap.get(sessionId);
            String[] cards = hand.getHand(0);
            StringBuilder sb = new StringBuilder();
            int j = 0;
            while (j < cards.length) {
                sb.append(cards[j]);
                sb.append(',');
                ++j;
            }
            if (sb.length() > 0) {
                sb.deleteCharAt(sb.length() - 1);
            }
            map.put("hand." + sessionId + ".0", sb.toString());
            int[] plotNo = hand.getPlotNoList();
            int i = 0;
            while (i < plotNo.length) {
                String[] cards2 = hand.getHand(plotNo[i]);
                StringBuilder sb2 = new StringBuilder();
                int j2 = 0;
                while (j2 < cards2.length) {
                    sb2.append(cards2[j2]);
                    sb2.append(',');
                    ++j2;
                }
                if (sb2.length() > 0) {
                    sb2.deleteCharAt(sb2.length() - 1);
                }
                map.put("hand." + sessionId + "." + (i + 1), sb2.toString());
                ++i;
            }
        }
    }

    public void setProperties(Map<String, Object> map) {
        this.handMap.clear();
        for (String key : map.keySet()) {
            if (!key.startsWith("hand.")) continue;
            String[] values = key.split("\\.");
            String sessionId = values[1];
            int plotNo = Integer.parseInt(values[2]);
            Hand hand = this.handMap.get(sessionId);
            if (hand == null) {
                hand = new Hand();
                this.handMap.put(sessionId, hand);
                hand.setName(sessionId);
            }
            String[] cards = ((String)map.get(key)).split("\\,");
            if (plotNo != 0) {
                plotNo = hand.addHand();
            }
            String[] stringArray = cards;
            int n = cards.length;
            int n2 = 0;
            while (n2 < n) {
                String card = stringArray[n2];
                hand.addCard(plotNo, card);
                ++n2;
            }
        }
    }

    public int addHandOf(String sessionId) {
        Hand hand = this.handMap.get(sessionId);
        if (hand == null) {
            hand = new Hand();
            hand.setName(sessionId);
            this.handMap.put(sessionId, hand);
            return 0;
        }
        return hand.addHand();
    }

    public boolean removeHandOf(String sessionId, int handNo) {
        Hand hand = this.handMap.get(sessionId);
        if (hand == null) {
            return false;
        }
        return hand.removeHand(handNo);
    }

    public boolean removeHandOf(String sessionId) {
        return this.handMap.remove(sessionId) != null;
    }

    public String[] getHandOf(String sessionId, int handNo) {
        Hand hand = this.handMap.get(sessionId);
        if (hand == null) {
            return null;
        }
        return hand.getHand(handNo);
    }

    public Hand getHandOf(String sessionId) {
        return this.handMap.get(sessionId);
    }

    public void switchHand(String[] hand1, String[] hand2, String card, String[] newHand1, String[] newHand2) {
        int found = 0;
        newHand1[0] = hand1[0];
        newHand1[1] = hand1[1];
        int i = 2;
        while (i < hand1.length) {
            if (hand1[i].equals(card) && found == 0) {
                found = 1;
            } else {
                newHand1[i - found] = hand1[i];
            }
            ++i;
        }
        System.arraycopy(hand2, 0, newHand2, 0, hand2.length);
        newHand2[hand2.length] = card;
    }

    public String switchReaction(String card) {
        if (card.length() == 3) {
            return card.substring(0, 2);
        }
        return String.valueOf(card) + "_";
    }

    public Hand[] getAllHands() {
        return this.handMap.values().toArray(new Hand[this.handMap.size()]);
    }

    public int getMaxHand() {
        return this.maxHand;
    }

    public void clear() {
        for (String sessionId : this.handMap.keySet()) {
            Hand hand = this.handMap.get(sessionId);
            hand.clear();
        }
    }
}

