/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.chaplet.nova.server;

import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import jp.sf.chaplet.StorageUtils;
import jp.sf.chaplet.core.server.ClientProxy;
import jp.sf.chaplet.core.server.ServerPlugin;
import jp.sf.chaplet.core.server.User;
import jp.sf.chaplet.nova.NovaConfig;
import jp.sf.chaplet.nova.server.AddCharacterAction;
import jp.sf.chaplet.nova.server.CardManager;
import jp.sf.chaplet.nova.server.FeedAction;
import jp.sf.chaplet.nova.server.GiveCardAction;
import jp.sf.chaplet.nova.server.Hand;
import jp.sf.chaplet.nova.server.HandManager;
import jp.sf.chaplet.nova.server.HandToPileAction;
import jp.sf.chaplet.nova.server.InitializeAction;
import jp.sf.chaplet.nova.server.LoginServerAction;
import jp.sf.chaplet.nova.server.LogoutServerAction;
import jp.sf.chaplet.nova.server.PlotToHandAction;
import jp.sf.chaplet.nova.server.PlotToPileAction;
import jp.sf.chaplet.nova.server.ReactionAction;
import jp.sf.chaplet.nova.server.RemoveCharacterAction;
import jp.sf.chaplet.nova.server.SceneAction;
import jp.sf.chaplet.nova.server.ShowPlotAction;
import jp.sf.chaplet.nova.server.TarotManager;
import jp.sf.chaplet.nova.server.ToPlotAction;
import jp.sf.chaplet.nova.server.YamabikiAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NovaServerPlugin
extends ServerPlugin {
    private HandManager handManager = new HandManager();
    private CardManager cardManager = new CardManager();
    private TarotManager tarotManager = new TarotManager();

    public String getUserStatus(User user) {
        Hand hand = this.handManager.getHandOf(user.getSessionId());
        if (hand != null) {
            return hand.handString();
        }
        return "";
    }

    public void reload() throws Exception {
        NovaConfig config = (NovaConfig)StorageUtils.load((String)"novaconf.xml", NovaConfig.class);
        this.tarotManager.setConfig(config);
        this.cardManager.setNumDeck(config.getNumDeck());
        this.cardManager.setNumJoker(config.getNumJoker());
        this.tarotManager.init();
        this.cardManager.init();
        this.handManager.clear();
    }

    public void init() throws Exception {
        LoginServerAction loginAction = new LoginServerAction();
        this.addAction("login", loginAction);
        this.addAction("nova:status", loginAction);
        this.addAction("logout", new LogoutServerAction());
        this.addAction("nova:feed", new FeedAction());
        this.addAction("nova:handtopile", new HandToPileAction());
        this.addAction("nova:addchara", new AddCharacterAction());
        this.addAction("nova:plottopile", new PlotToPileAction());
        this.addAction("nova:reaction", new ReactionAction());
        this.addAction("nova:delchara", new RemoveCharacterAction());
        this.addAction("nova:scene", new SceneAction());
        this.addAction("nova:toplot", new ToPlotAction());
        this.addAction("nova:yamabiki", new YamabikiAction());
        this.addAction("nova:givecard", new GiveCardAction());
        this.addAction("nova:tohand", new PlotToHandAction());
        this.addAction("nova:init", new InitializeAction());
        this.addAction("nova:showplot", new ShowPlotAction());
        NovaConfig config = (NovaConfig)StorageUtils.load((String)"novaconf.xml", NovaConfig.class);
        this.tarotManager.setConfig(config);
        this.cardManager.setNumDeck(config.getNumDeck());
        this.cardManager.setNumJoker(config.getNumJoker());
        this.tarotManager.init();
        this.cardManager.init();
    }

    public CardManager getCardManager() {
        return this.cardManager;
    }

    public HandManager getHandManager() {
        return this.handManager;
    }

    public TarotManager getTarotManager() {
        return this.tarotManager;
    }

    public void save(Map<String, Object> map) {
        this.cardManager.getProperties(map);
        this.tarotManager.getProperties(map);
        this.handManager.getProperties(map);
    }

    public void load(Map<String, Object> map) {
        this.cardManager.setProperties(map);
        this.tarotManager.setProperties(map);
        this.handManager.setProperties(map);
    }

    public void sendPluginStatus() {
        try {
            this.getAction("nova:scene").execute(new String[]{"nova:scene", "no"}, null);
        }
        catch (IOException e) {
            this.getLogger().log(Level.SEVERE, "scene", e);
        }
    }

    public void sendPluginStatus(ClientProxy proxy) {
        Hand hand = this.getHandManager().getHandOf(proxy.getSessionId());
        String[] cards = hand.getHand(0);
        String[] resp = new String[cards.length + 1];
        resp[0] = "ok/nova:feed";
        int i = 0;
        while (i < cards.length) {
            resp[i + 1] = cards[i];
            ++i;
        }
        proxy.sendMessage(resp);
        try {
            this.getAction("nova:status").execute(new String[]{"nova:status"}, proxy);
        }
        catch (IOException e) {
            this.getLogger().log(Level.SEVERE, "scene", e);
        }
    }

    public String getPluginId() {
        return "jp.sf.chaplet.nova";
    }
}

