/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.chaplet.nova.ui;

import application.ApplicationContext;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import jp.sf.chaplet.core.client.ClientPlugin;
import jp.sf.chaplet.core.ui.IPrefView;
import jp.sf.chaplet.core.ui.SinglePrefDialog;
import jp.sf.chaplet.nova.Card;
import jp.sf.chaplet.nova.Plot;
import jp.sf.chaplet.nova.PlotChara;
import jp.sf.chaplet.nova.ui.BasicPrefPanel;
import jp.sf.chaplet.nova.ui.CardListRenderer;
import jp.sf.chaplet.nova.ui.INovaView;
import jp.sf.chaplet.nova.ui.PlotTableCellRenderer;
import jp.sf.chaplet.nova.ui.PlotTableModel;

public class NovaView
extends JPanel
implements INovaView {
    private static final long serialVersionUID = 1L;
    private JScrollPane jScrollPane = null;
    private JList handList = null;
    private CardListRenderer cardListRenderer = null;
    private DefaultListModel cardListModel = null;
    private JPanel buttonPanel = null;
    private JButton feedButton = null;
    private JScrollPane jScrollPane1 = null;
    private JTable plotTable = null;
    private PlotTableModel plotTableModel = null;
    private PlotTableCellRenderer plotTableCellRenderer = null;
    private JButton toPileButton = null;
    private JButton yamabikiButton = null;
    private JButton toPlotButton = null;
    private JPanel button2Panel = null;
    private JButton toHandButton = null;
    private JPanel button3Panel = null;
    private JButton plotToPileButton = null;
    private JPanel scenePanel = null;
    private JLabel sceneLabel = null;
    private JButton sceneButton = null;
    private JButton prefButton = null;
    private JButton addCharaButton = null;
    private ActionMap actionMap;
    private JPanel jPanel = null;
    private JButton initButton = null;
    private JButton removeCharacterButton = null;
    private JButton toReactionButton = null;
    private JButton otherFuncButton = null;
    private JPopupMenu otherFuncPopup = null;
    private JMenuItem giveCardItem = null;
    private JMenuItem showPlotItem = null;

    public NovaView() {
        this.initialize();
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints101 = new GridBagConstraints();
        gridBagConstraints101.gridx = 1;
        gridBagConstraints101.fill = 2;
        gridBagConstraints101.anchor = 15;
        gridBagConstraints101.gridy = 4;
        GridBagConstraints gridBagConstraints31 = new GridBagConstraints();
        gridBagConstraints31.gridx = 0;
        gridBagConstraints31.fill = 2;
        gridBagConstraints31.gridwidth = 2;
        gridBagConstraints31.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints31.gridy = 0;
        GridBagConstraints gridBagConstraints21 = new GridBagConstraints();
        gridBagConstraints21.gridx = 1;
        gridBagConstraints21.fill = 2;
        gridBagConstraints21.anchor = 11;
        gridBagConstraints21.gridy = 3;
        GridBagConstraints gridBagConstraints12 = new GridBagConstraints();
        gridBagConstraints12.gridx = 0;
        gridBagConstraints12.fill = 2;
        gridBagConstraints12.gridy = 2;
        GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
        gridBagConstraints11.fill = 1;
        gridBagConstraints11.weighty = 10.0;
        gridBagConstraints11.gridx = 0;
        gridBagConstraints11.gridy = 3;
        gridBagConstraints11.gridheight = 2;
        gridBagConstraints11.weightx = 5.0;
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.weightx = 1.0;
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.anchor = 11;
        gridBagConstraints1.ipadx = 0;
        gridBagConstraints1.gridy = 1;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 5.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridx = 0;
        this.setSize(355, 360);
        this.setLayout(new GridBagLayout());
        this.add((Component)this.getJScrollPane(), gridBagConstraints);
        this.add((Component)this.getButtonPanel(), gridBagConstraints1);
        this.add((Component)this.getJScrollPane1(), gridBagConstraints11);
        this.add((Component)this.getButton2Panel(), gridBagConstraints12);
        this.add((Component)this.getButton3Panel(), gridBagConstraints21);
        this.add((Component)this.getScenePanel(), gridBagConstraints31);
        this.add((Component)this.getJPanel(), gridBagConstraints101);
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setVerticalScrollBarPolicy(22);
            this.jScrollPane.setViewportView(this.getHandList());
        }
        return this.jScrollPane;
    }

    public JList getHandList() {
        if (this.handList == null) {
            this.handList = new JList();
            this.handList.setVisibleRowCount(0);
            this.handList.setCellRenderer(this.getCardListRenderer());
            this.handList.setModel(this.getCardListModel());
            this.handList.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2 && SwingUtilities.isLeftMouseButton(e)) {
                        NovaView.this.actionMap.get("handToPile").actionPerformed(new ActionEvent(NovaView.this.getHandList(), 1001, "handToPile"));
                    }
                }
            });
            this.handList.setLayoutOrientation(2);
        }
        return this.handList;
    }

    private CardListRenderer getCardListRenderer() {
        if (this.cardListRenderer == null) {
            this.cardListRenderer = new CardListRenderer();
        }
        return this.cardListRenderer;
    }

    private DefaultListModel getCardListModel() {
        if (this.cardListModel == null) {
            this.cardListModel = new DefaultListModel();
        }
        return this.cardListModel;
    }

    private JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            GridBagConstraints gridBagConstraints17 = new GridBagConstraints();
            gridBagConstraints17.gridx = 0;
            gridBagConstraints17.fill = 2;
            gridBagConstraints17.insets = new Insets(2, 0, 2, 0);
            gridBagConstraints17.gridy = 3;
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridx = 0;
            gridBagConstraints4.fill = 2;
            gridBagConstraints4.insets = new Insets(2, 0, 2, 0);
            gridBagConstraints4.gridy = 2;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.insets = new Insets(2, 0, 2, 0);
            gridBagConstraints3.fill = 2;
            gridBagConstraints3.gridy = 1;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.anchor = 10;
            gridBagConstraints2.insets = new Insets(2, 0, 2, 0);
            gridBagConstraints2.fill = 2;
            this.buttonPanel = new JPanel();
            this.buttonPanel.setLayout(new GridBagLayout());
            this.buttonPanel.add((Component)this.getFeedButton(), gridBagConstraints2);
            this.buttonPanel.add((Component)this.getToPileButton(), gridBagConstraints3);
            this.buttonPanel.add((Component)this.getYamabikiButton(), gridBagConstraints4);
            this.buttonPanel.add((Component)this.getOtherFuncButton(), gridBagConstraints17);
        }
        return this.buttonPanel;
    }

    private JButton getFeedButton() {
        if (this.feedButton == null) {
            this.feedButton = new JButton();
            this.feedButton.setText("\u88dc\u5145");
            this.feedButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    NovaView.this.actionMap.get("feedHand").actionPerformed(e);
                }
            });
        }
        return this.feedButton;
    }

    private JScrollPane getJScrollPane1() {
        if (this.jScrollPane1 == null) {
            this.jScrollPane1 = new JScrollPane();
            this.jScrollPane1.setVerticalScrollBarPolicy(22);
            this.jScrollPane1.setViewportView(this.getPlotTable());
        }
        return this.jScrollPane1;
    }

    public JTable getPlotTable() {
        if (this.plotTable == null) {
            this.plotTable = new JTable();
            this.plotTable.setModel(this.getPlotTableModel());
            this.plotTable.setShowVerticalLines(false);
            this.plotTable.setRowHeight(60);
            this.plotTable.setColumnSelectionAllowed(true);
            this.setTableRenderer();
        }
        return this.plotTable;
    }

    private void setTableRenderer() {
        TableColumnModel tcm = this.plotTable.getColumnModel();
        TableColumn c0 = tcm.getColumn(0);
        c0.setPreferredWidth(25);
        int i = 1;
        while (i < tcm.getColumnCount()) {
            TableColumn column = tcm.getColumn(i);
            column.setPreferredWidth(60);
            column.setCellRenderer(this.getPlotTableCellRenderer());
            ++i;
        }
    }

    public PlotTableModel getPlotTableModel() {
        if (this.plotTableModel == null) {
            this.plotTableModel = new PlotTableModel();
            this.plotTableModel.addTableModelListener(new TableModelListener(){

                public void tableChanged(TableModelEvent e) {
                    if (e.getFirstRow() == -1) {
                        NovaView.this.setTableRenderer();
                    }
                }
            });
        }
        return this.plotTableModel;
    }

    private PlotTableCellRenderer getPlotTableCellRenderer() {
        if (this.plotTableCellRenderer == null) {
            this.plotTableCellRenderer = new PlotTableCellRenderer();
            this.plotTableCellRenderer.setModel(this.getPlotTableModel());
        }
        return this.plotTableCellRenderer;
    }

    private JButton getToPileButton() {
        if (this.toPileButton == null) {
            this.toPileButton = new JButton();
            this.toPileButton.setText("\u5224\u5b9a/\u6368\u3066\u308b");
            this.toPileButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    NovaView.this.actionMap.get("handToPile").actionPerformed(e);
                }
            });
        }
        return this.toPileButton;
    }

    private JButton getYamabikiButton() {
        if (this.yamabikiButton == null) {
            this.yamabikiButton = new JButton();
            this.yamabikiButton.setText("\u5c71\u5f15\u304d");
            this.yamabikiButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    NovaView.this.actionMap.get("yamabiki").actionPerformed(e);
                }
            });
        }
        return this.yamabikiButton;
    }

    private JButton getToPlotButton() {
        if (this.toPlotButton == null) {
            this.toPlotButton = new JButton();
            this.toPlotButton.setText("\u25bd\u30d7\u30ed\u30c3\u30c8\u3078");
            this.toPlotButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    NovaView.this.actionMap.get("handToProt").actionPerformed(e);
                }
            });
        }
        return this.toPlotButton;
    }

    private JPanel getButton2Panel() {
        if (this.button2Panel == null) {
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.weightx = 1.0;
            gridBagConstraints7.insets = new Insets(2, 0, 2, 0);
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.gridx = -1;
            gridBagConstraints5.weightx = 1.0;
            gridBagConstraints5.insets = new Insets(2, 0, 2, 0);
            gridBagConstraints5.gridy = -1;
            this.button2Panel = new JPanel();
            this.button2Panel.setLayout(new GridBagLayout());
            this.button2Panel.add((Component)this.getToPlotButton(), gridBagConstraints5);
            this.button2Panel.add((Component)this.getToHandButton(), gridBagConstraints7);
        }
        return this.button2Panel;
    }

    private JButton getToHandButton() {
        if (this.toHandButton == null) {
            this.toHandButton = new JButton();
            this.toHandButton.setText("\u25b3\u624b\u672d\u3078");
            this.toHandButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    NovaView.this.actionMap.get("plotToHand").actionPerformed(e);
                }
            });
        }
        return this.toHandButton;
    }

    private JPanel getButton3Panel() {
        if (this.button3Panel == null) {
            GridBagConstraints gridBagConstraints16 = new GridBagConstraints();
            gridBagConstraints16.gridx = 0;
            gridBagConstraints16.insets = new Insets(2, 0, 2, 0);
            gridBagConstraints16.fill = 2;
            gridBagConstraints16.gridy = 3;
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.gridx = 0;
            gridBagConstraints6.insets = new Insets(2, 0, 2, 0);
            gridBagConstraints6.fill = 2;
            gridBagConstraints6.gridy = 2;
            GridBagConstraints gridBagConstraints14 = new GridBagConstraints();
            gridBagConstraints14.gridx = 0;
            gridBagConstraints14.fill = 2;
            gridBagConstraints14.insets = new Insets(2, 0, 2, 0);
            gridBagConstraints14.gridy = 1;
            GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
            gridBagConstraints8.gridx = 0;
            gridBagConstraints8.fill = 2;
            gridBagConstraints8.insets = new Insets(2, 0, 2, 0);
            gridBagConstraints8.gridy = 0;
            this.button3Panel = new JPanel();
            this.button3Panel.setLayout(new GridBagLayout());
            this.button3Panel.add((Component)this.getPlotToPileButton(), gridBagConstraints8);
            this.button3Panel.add((Component)this.getAddCharaButton(), gridBagConstraints14);
            this.button3Panel.add((Component)this.getRemoveCharacterButton(), gridBagConstraints6);
            this.button3Panel.add((Component)this.getToReactionButton(), gridBagConstraints16);
        }
        return this.button3Panel;
    }

    private JButton getPlotToPileButton() {
        if (this.plotToPileButton == null) {
            this.plotToPileButton = new JButton();
            this.plotToPileButton.setText("\u5224\u5b9a/\u6368\u3066\u308b");
            this.plotToPileButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    NovaView.this.actionMap.get("plotToPile").actionPerformed(e);
                }
            });
        }
        return this.plotToPileButton;
    }

    private JPanel getScenePanel() {
        if (this.scenePanel == null) {
            GridBagConstraints gridBagConstraints13 = new GridBagConstraints();
            gridBagConstraints13.weightx = 1.0;
            gridBagConstraints13.gridy = 0;
            gridBagConstraints13.gridx = 1;
            GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
            gridBagConstraints10.weightx = 10.0;
            gridBagConstraints10.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints10.fill = 1;
            this.sceneLabel = new JLabel();
            this.sceneLabel.setText("");
            this.sceneLabel.setBorder(BorderFactory.createBevelBorder(1));
            this.scenePanel = new JPanel();
            this.scenePanel.setLayout(new GridBagLayout());
            this.scenePanel.add((Component)this.sceneLabel, gridBagConstraints10);
            this.scenePanel.add((Component)this.getSceneButton(), gridBagConstraints13);
        }
        return this.scenePanel;
    }

    private JButton getSceneButton() {
        if (this.sceneButton == null) {
            this.sceneButton = new JButton();
            this.sceneButton.setText("\u6b21\u306e\u30b7\u30fc\u30f3");
            this.sceneButton.setEnabled(false);
            this.sceneButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    NovaView.this.actionMap.get("nextScene").actionPerformed(e);
                }
            });
        }
        return this.sceneButton;
    }

    private JButton getPrefButton() {
        if (this.prefButton == null) {
            this.prefButton = new JButton();
            this.prefButton.setText("\u8a2d\u5b9a...");
            this.prefButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JFrame window = (JFrame)SwingUtilities.getAncestorOfClass(JFrame.class, NovaView.this);
                    SinglePrefDialog dialog = new SinglePrefDialog((Frame)window);
                    dialog.setLocationRelativeTo((Component)window);
                    dialog.setPrefView((IPrefView)new BasicPrefPanel());
                    dialog.setVisible(true);
                }
            });
        }
        return this.prefButton;
    }

    private JButton getAddCharaButton() {
        if (this.addCharaButton == null) {
            this.addCharaButton = new JButton();
            this.addCharaButton.setText("\u30d7\u30ed\u30c3\u30c8\u3092\u8ffd\u52a0");
            this.addCharaButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    NovaView.this.actionMap.get("addCharacter").actionPerformed(e);
                }
            });
        }
        return this.addCharaButton;
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            GridBagConstraints gridBagConstraints15 = new GridBagConstraints();
            gridBagConstraints15.fill = 2;
            gridBagConstraints15.insets = new Insets(2, 0, 2, 0);
            GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
            gridBagConstraints9.gridy = 1;
            gridBagConstraints9.fill = 2;
            gridBagConstraints9.insets = new Insets(2, 0, 2, 0);
            gridBagConstraints9.gridx = 0;
            this.jPanel = new JPanel();
            this.jPanel.setLayout(new GridBagLayout());
            this.jPanel.add((Component)this.getInitButton(), gridBagConstraints15);
            this.jPanel.add((Component)this.getPrefButton(), gridBagConstraints9);
        }
        return this.jPanel;
    }

    private JButton getInitButton() {
        if (this.initButton == null) {
            this.initButton = new JButton();
            this.initButton.setText("\u521d\u671f\u5316");
            this.initButton.setEnabled(false);
            this.initButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    NovaView.this.actionMap.get("initServer").actionPerformed(e);
                }
            });
        }
        return this.initButton;
    }

    private JButton getRemoveCharacterButton() {
        if (this.removeCharacterButton == null) {
            this.removeCharacterButton = new JButton();
            this.removeCharacterButton.setText("\u30d7\u30ed\u30c3\u30c8\u3092\u524a\u9664");
            this.removeCharacterButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    NovaView.this.actionMap.get("removeCharacter").actionPerformed(e);
                }
            });
        }
        return this.removeCharacterButton;
    }

    private JButton getToReactionButton() {
        if (this.toReactionButton == null) {
            this.toReactionButton = new JButton();
            this.toReactionButton.setText("\u30ea\u30a2\u30af\u30b7\u30e7\u30f3\u5f85\u6a5f");
            this.toReactionButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    NovaView.this.actionMap.get("toReaction").actionPerformed(e);
                }
            });
        }
        return this.toReactionButton;
    }

    private JButton getOtherFuncButton() {
        if (this.otherFuncButton == null) {
            this.otherFuncButton = new JButton();
            this.otherFuncButton.setText("\u305d\u306e\u4ed6");
            this.otherFuncButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Rectangle bounds = NovaView.this.getOtherFuncButton().getBounds();
                    NovaView.this.getOtherFuncPopup().show(NovaView.this.getButtonPanel(), bounds.x, bounds.y + bounds.height);
                }
            });
        }
        return this.otherFuncButton;
    }

    private JPopupMenu getOtherFuncPopup() {
        if (this.otherFuncPopup == null) {
            this.otherFuncPopup = new JPopupMenu();
            this.otherFuncPopup.add(this.getGiveCardItem());
            this.otherFuncPopup.add(this.getShowPlotItem());
            this.otherFuncPopup.addFocusListener(new FocusAdapter(){

                public void focusLost(FocusEvent e) {
                    NovaView.this.otherFuncPopup.setVisible(false);
                }
            });
        }
        return this.otherFuncPopup;
    }

    private JMenuItem getGiveCardItem() {
        if (this.giveCardItem == null) {
            this.giveCardItem = new JMenuItem();
            this.giveCardItem.setText("\u624b\u672d\u3092\u6e21\u3059");
            this.giveCardItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    NovaView.this.actionMap.get("giveCard").actionPerformed(e);
                }
            });
        }
        return this.giveCardItem;
    }

    private JMenuItem getShowPlotItem() {
        if (this.showPlotItem == null) {
            this.showPlotItem = new JMenuItem();
            this.showPlotItem.setText("\u30d7\u30ed\u30c3\u30c8\u3092\u898b\u305b\u308b");
            this.showPlotItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    NovaView.this.actionMap.get("showPlot").actionPerformed(e);
                }
            });
        }
        return this.showPlotItem;
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("card");
        frame.add(new NovaView());
        frame.setSize(400, 400);
        frame.setDefaultCloseOperation(3);
        frame.setVisible(true);
    }

    public String getPluginId() {
        return "jp.sf.chaplet.nova";
    }

    public String getPluginName() {
        return "\uff2e\u25ce\uff36\uff21";
    }

    public JPanel getSwingComponent() {
        return this;
    }

    public void setController(ClientPlugin plugin) {
        ApplicationContext context = ApplicationContext.getInstance();
        this.actionMap = context.getActionMap((Object)plugin);
    }

    public void setGM(boolean gm) {
        this.getSceneButton().setEnabled(gm);
        this.getInitButton().setEnabled(gm);
    }

    public void setLoginOK(boolean ok) {
        this.getToHandButton().setEnabled(ok);
        this.getFeedButton().setEnabled(ok);
        this.getYamabikiButton().setEnabled(ok);
        this.getToPileButton().setEnabled(ok);
        this.getToPlotButton().setEnabled(ok);
        this.getPlotToPileButton().setEnabled(ok);
        this.getAddCharaButton().setEnabled(ok);
        this.getRemoveCharacterButton().setEnabled(ok);
        this.getToReactionButton().setEnabled(ok);
    }

    public void addPlot(int plotNo, String[] plots) {
        final PlotChara chara = new PlotChara();
        chara.setCharaNo(plotNo);
        if (plots != null) {
            String[] stringArray = plots;
            int n = plots.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                Plot plot = new Plot(new Card(s), plotNo, false);
                chara.add(plot);
                ++n2;
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                NovaView.this.getPlotTableModel().add(chara);
                int row = NovaView.this.getPlotTableModel().getRowIndex(chara.getCharaNo());
                NovaView.this.getPlotTable().getSelectionModel().addSelectionInterval(row, row);
            }
        });
    }

    public void exchangePlot(final int charaNo, String cardS, String newCardS) {
        final Card card = new Card(cardS);
        final Card newCard = new Card(newCardS);
        final boolean reaction = newCardS.length() > 2 && newCardS.charAt(2) == '_';
        final PlotChara chara = this.getPlotTableModel().getChara(charaNo);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (card.equals(newCard)) {
                    chara.setReaction(newCard, reaction);
                } else {
                    chara.remove(card);
                    chara.add(new Plot(newCard, charaNo, false));
                }
                int rowIndex = NovaView.this.getPlotTableModel().getRowIndex(charaNo);
                NovaView.this.getPlotTableModel().fireTableRowsUpdated(rowIndex, rowIndex);
            }
        });
    }

    public String[] getHand() {
        return null;
    }

    public void moveToPlot(final int charaNo, String cardStr) {
        final Card card = new Card(cardStr);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                int row = NovaView.this.getPlotTable().getSelectedRow();
                NovaView.this.getPlotTableModel().add(charaNo, card);
                NovaView.this.getCardListModel().removeElement(card);
                NovaView.this.getPlotTable().getSelectionModel().addSelectionInterval(row, row);
                NovaView.this.getPlotTable().getColumnModel().getSelectionModel().addSelectionInterval(0, 0);
            }
        });
    }

    public void removeFromPlot(final int charaNo, final String card) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                NovaView.this.getPlotTableModel().remove(charaNo, new Card(card));
            }
        });
    }

    public void removePlot(final int charaNo) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                NovaView.this.getPlotTableModel().remove(charaNo);
            }
        });
    }

    public void setHand(final String[] hands) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                NovaView.this.getCardListModel().removeAllElements();
                if (hands != null) {
                    String[] stringArray = hands;
                    int n = hands.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String s = stringArray[n2];
                        NovaView.this.getCardListModel().addElement(new Card(s));
                        ++n2;
                    }
                }
            }
        });
    }

    public void setSceneCard(final String scene) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                NovaView.this.sceneLabel.setText(scene);
            }
        });
    }

    public void moveToHand(final int plotNo, final String cardS) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Card card = new Card(cardS);
                NovaView.this.getPlotTableModel().remove(plotNo, card);
                NovaView.this.getCardListModel().addElement(card);
            }
        });
    }
}

