/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.chaplet.dx.client;

import application.Action;
import java.util.ArrayList;
import javax.swing.JPanel;
import jp.sf.chaplet.StorageUtils;
import jp.sf.chaplet.core.client.ClientAction;
import jp.sf.chaplet.core.client.ClientPlugin;
import jp.sf.chaplet.core.client.Handle;
import jp.sf.chaplet.core.ui.IPluginView;
import jp.sf.chaplet.dx.DiceResult;
import jp.sf.chaplet.dx.DiceRoll;
import jp.sf.chaplet.dx.DiceRoller;
import jp.sf.chaplet.dx.DxCharacter;
import jp.sf.chaplet.dx.Lois;
import jp.sf.chaplet.dx.client.RollAction;
import jp.sf.chaplet.dx.ui.DxView;

public class DxClientPlugin
extends ClientPlugin {
    public static final String STRAGE_LOIS = "lois.xml";
    public static final String STRAGE_CHARA = "dxchara.xml";
    private DxView view;

    public String getPluginId() {
        return "jp.sf.chaplet.dx";
    }

    public IPluginView getPluginView() {
        return this.view;
    }

    public JPanel getSwingComponent() {
        return this.view;
    }

    protected void startup() {
        DxCharacter character;
        ClientAction[] actions = new ClientAction[]{new RollAction()};
        ClientAction[] clientActionArray = actions;
        int n = actions.length;
        int n2 = 0;
        while (n2 < n) {
            ClientAction action = clientActionArray[n2];
            action.init(this.getController(), (ClientPlugin)this);
            ++n2;
        }
        this.addAction("dx:roll", actions[0]);
        this.view = new DxView();
        this.view.setController(this);
        ArrayList loisList = (ArrayList)StorageUtils.load((String)STRAGE_LOIS, ArrayList.class);
        if (loisList != null && loisList.size() > 0) {
            this.view.getLoisTableModel().setAll(loisList);
        }
        if ((character = (DxCharacter)StorageUtils.load((String)STRAGE_CHARA, DxCharacter.class)) != null) {
            this.view.getHpSpinner().setValue(character.getHp());
            this.view.getInvasionSpinner().setValue(character.getInvasion());
        }
    }

    protected void shutdown() {
        ArrayList<Lois> loisList = this.view.getLoisTableModel().getAll();
        StorageUtils.save(loisList, (String)STRAGE_LOIS);
        DxCharacter character = new DxCharacter();
        character.setHp((Integer)this.view.getHpSpinner().getValue());
        character.setInvasion((Integer)this.view.getInvasionSpinner().getValue());
        StorageUtils.save((Object)character, (String)STRAGE_CHARA);
    }

    @Action
    public void rollSum() {
        Handle handle = (Handle)StorageUtils.load((String)"handle.xml", Handle.class);
        int numDice = (Integer)this.view.getDiceSpinner().getValue();
        int bonus = (Integer)this.view.getBonusSpinner().getValue();
        int critical = (Integer)this.view.getCriticalSpinner().getValue();
        DiceRoll roll = new DiceRoll(numDice, bonus, critical);
        DiceResult result = DiceRoller.getInstance().rollSum(roll);
        this.view.getHistoryComboModel().add((Object)roll);
        this.view.getHistoryCombo().setSelectedItem(roll);
        String exp = String.valueOf(roll.toString()) + " = " + result.toString();
        this.getController().getView().appendFunctionLog("\u30c0\u30a4\u30b9", handle.getName(), exp);
        if (this.view.getHideButton().isSelected()) {
            exp = "-";
        }
        if (this.isConnected()) {
            this.getConnection().sendMessage(new String[]{"roll", handle.getName(), exp});
        }
    }

    @Action
    public void rollDamage() {
        Handle handle = (Handle)StorageUtils.load((String)"handle.xml", Handle.class);
        int numDice = (Integer)this.view.getDiceSpinner().getValue();
        int bonus = (Integer)this.view.getBonusSpinner().getValue();
        DiceRoll roll = new DiceRoll(numDice, bonus, 0);
        DiceResult result = DiceRoller.getInstance().rollDamage(roll);
        this.view.getHistoryComboModel().add((Object)roll);
        this.view.getHistoryCombo().setSelectedItem(roll);
        String exp = String.valueOf(roll.toString()) + " = " + result.toString();
        this.getController().getView().appendFunctionLog("\u30c0\u30a4\u30b9", handle.getName(), exp);
        if (this.view.getHideButton().isSelected()) {
            exp = "-";
        }
        if (this.isConnected()) {
            this.getConnection().sendMessage(new String[]{"roll", handle.getName(), exp});
        }
    }

    @Action
    public void setStatus() {
        int hp = (Integer)this.view.getHpSpinner().getValue();
        int invasion = (Integer)this.view.getInvasionSpinner().getValue();
        int numLois = this.view.getLoisTableModel().getNumLois();
        String[] message = new String[]{"dx:status", Integer.toString(hp), Integer.toString(invasion), Integer.toString(numLois)};
        if (this.isConnected()) {
            this.getConnection().sendMessage(message);
        }
    }

    @Action
    public void roll1d() {
        Handle handle = (Handle)StorageUtils.load((String)"handle.xml", Handle.class);
        DiceRoll roll = new DiceRoll(1, 0, 0);
        DiceResult result = DiceRoller.getInstance().rollDamage(roll);
        this.view.getHistoryComboModel().add((Object)roll);
        String exp = String.valueOf(roll.toString()) + " = " + result.toString();
        this.getController().getView().appendFunctionLog("\u30c0\u30a4\u30b9", handle.getName(), exp);
        if (this.view.getHideButton().isSelected()) {
            exp = "-";
        }
        if (this.isConnected()) {
            this.getConnection().sendMessage(new String[]{"roll", handle.getName(), exp});
        }
    }

    @Action
    public void roll2d() {
        Handle handle = (Handle)StorageUtils.load((String)"handle.xml", Handle.class);
        DiceRoll roll = new DiceRoll(2, 0, 0);
        DiceResult result = DiceRoller.getInstance().rollDamage(roll);
        this.view.getHistoryComboModel().add((Object)roll);
        String exp = String.valueOf(roll.toString()) + " = " + result.toString();
        this.getController().getView().appendFunctionLog("\u30c0\u30a4\u30b9", handle.getName(), exp);
        if (this.view.getHideButton().isSelected()) {
            exp = "-";
        }
        if (this.isConnected()) {
            this.getConnection().sendMessage(new String[]{"roll", handle.getName(), exp});
        }
    }
}

