/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.chaplet.core.client;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import jp.sf.chaplet.NetUtil;
import jp.sf.chaplet.core.client.IChatListener;

public class ChatConnection {
    private Socket socket;
    private BufferedWriter writer;
    private BufferedReader reader;
    private ArrayList<IChatListener> listenerList = new ArrayList();
    private LinkedList<String[]> runList = new LinkedList();
    private boolean connected = false;
    private Thread mainThread;
    private Logger logger = Logger.getLogger(ChatConnection.class.getName());

    public void connect(String host, int port, String sessionId, String userName) throws IOException {
        this.socket = new Socket(host, port);
        this.writer = NetUtil.getWriter(this.socket);
        this.reader = NetUtil.getReader(this.socket);
        this.writer.write("login");
        this.writer.newLine();
        this.writer.write(sessionId == null ? "" : sessionId);
        this.writer.newLine();
        this.writer.write(userName);
        this.writer.newLine();
        this.writer.write(46);
        this.writer.newLine();
        this.writer.flush();
        this.connected = true;
        this.mainThread = new Thread(new Runnable(){

            public void run() {
                ChatConnection.this.mainLoop();
            }
        }, "client-messageLoop");
        Thread recieveThread = new Thread(new Runnable(){

            public void run() {
                ChatConnection.this.recieveLoop();
            }
        }, "client-recieveLoop");
        this.mainThread.start();
        recieveThread.start();
        this.notifyConnect(host);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mainLoop() {
        while (this.connected) {
            String[] request = null;
            ChatConnection chatConnection = this;
            synchronized (chatConnection) {
                while (this.runList.size() == 0) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                }
                if (!this.connected) {
                    return;
                }
                if (this.runList.size() == 0) {
                    return;
                }
                request = this.runList.removeFirst();
                this.notifyAll();
            }
            if (request == null) {
                return;
            }
            try {
                int i = 0;
                while (i < request.length) {
                    NetUtil.writeLine(this.writer, request[i]);
                    ++i;
                }
                this.writer.write(46);
                this.writer.newLine();
                this.writer.flush();
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, request[0], e);
                this.notifyErrorOccured();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recieveLoop() {
        while (this.connected && this.socket != null && this.socket.isConnected()) {
            try {
                String[] line = NetUtil.getRequest(this.reader);
                if (line == null || line.length == 0) {
                    this.connected = false;
                    ChatConnection chatConnection = this;
                    synchronized (chatConnection) {
                        this.notifyAll();
                    }
                    return;
                }
                if (line[0].startsWith("ok/") || line[0].startsWith("ng/")) {
                    for (IChatListener listener : this.listenerList) {
                        listener.responseRecieved(line);
                    }
                    continue;
                }
                for (IChatListener listener : this.listenerList) {
                    listener.messageRecieved(line);
                }
            }
            catch (SocketException e) {
                this.notifyErrorDisconnect();
                try {
                    this.socket.close();
                }
                catch (IOException e1) {
                    this.logger.log(Level.SEVERE, "recieveLoop", e);
                    this.notifyErrorOccured();
                }
                this.socket = null;
                this.connected = false;
                break;
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "recieveLoop", e);
                this.notifyErrorOccured();
            }
        }
    }

    public void close() {
        if (this.socket != null && this.socket.isConnected()) {
            block12: {
                try {
                    try {
                        this.socket.shutdownInput();
                        this.socket.shutdownOutput();
                        this.reader.read();
                    }
                    catch (IOException e) {
                        this.logger.log(Level.SEVERE, "close", e);
                        this.notifyErrorOccured();
                        try {
                            this.socket.close();
                        }
                        catch (IOException e2) {
                            this.logger.log(Level.SEVERE, "close", e2);
                        }
                        break block12;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        this.socket.close();
                    }
                    catch (IOException e) {
                        this.logger.log(Level.SEVERE, "close", e);
                    }
                    throw throwable;
                }
                try {
                    this.socket.close();
                }
                catch (IOException e) {
                    this.logger.log(Level.SEVERE, "close", e);
                }
            }
            this.mainThread.interrupt();
            this.notifyDisconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessage(String[] message) {
        ChatConnection chatConnection = this;
        synchronized (chatConnection) {
            this.runList.addLast(message);
            this.notifyAll();
        }
    }

    public boolean addChatListener(IChatListener listener) {
        return this.listenerList.add(listener);
    }

    public boolean removeChatListener(IChatListener listener) {
        return this.listenerList.remove(listener);
    }

    private void notifyConnect(String serverName) {
        for (IChatListener listener : this.listenerList) {
            listener.connectionEstablished(serverName);
        }
    }

    private void notifyDisconnect() {
        for (IChatListener listener : this.listenerList) {
            listener.connectionClosed();
        }
    }

    private void notifyErrorDisconnect() {
        for (IChatListener listener : this.listenerList) {
            listener.connectionClosedByError();
        }
    }

    private void notifyErrorOccured() {
        for (IChatListener listener : this.listenerList) {
            listener.errorOccured();
        }
    }

    public boolean isConnected() {
        return this.connected;
    }
}

