/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.chaplet.core.server;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import jp.sf.chaplet.core.server.ChatServer;
import jp.sf.chaplet.core.server.ClientProxy;
import jp.sf.chaplet.core.server.ServerAction;
import jp.sf.chaplet.core.server.User;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ServerPlugin {
    protected ChatServer server;
    private HashMap<String, ServerAction> actionMap = new HashMap();
    private Logger logger = Logger.getLogger(this.getClass().getName());

    public final void init(ChatServer server) throws Exception {
        this.server = server;
        this.init();
    }

    public void init() throws Exception {
    }

    public void destroy() throws Exception {
    }

    public void save(Map<String, Object> map) {
    }

    public void load(Map<String, Object> map) {
    }

    protected void addAction(String name, ServerAction action) {
        action.init(this.server, this);
        this.actionMap.put(name, action);
    }

    protected void removeAction(String name) {
        this.actionMap.remove(name);
    }

    protected ServerAction getAction(String name) {
        return this.actionMap.get(name);
    }

    public String getUserStatus(User user) {
        return "";
    }

    public void sendPluginStatus(ClientProxy proxy) {
    }

    public void sendPluginStatus() {
    }

    public abstract String getPluginId();

    public void reload() throws Exception {
    }

    protected Logger getLogger() {
        return this.logger;
    }
}

