/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.chaplet.core.server;

import java.util.ArrayList;
import java.util.UUID;
import jp.sf.chaplet.core.server.User;

public class UserManager {
    private String masterId;
    private ArrayList<User> userList = new ArrayList();

    public String login(String sessionId, String name) {
        User user = this.getUser(sessionId);
        if (user == null) {
            if (!sessionId.equals(this.masterId)) {
                sessionId = UUID.randomUUID().toString();
            }
            user = new User(name, sessionId);
            user.setAlive(true);
            this.userList.add(user);
            return sessionId;
        }
        user.setAlive(true);
        return user.getSessionId();
    }

    public void logout(String sessionId, boolean isAccident) {
        int i = 0;
        while (i < this.userList.size()) {
            User user = this.userList.get(i);
            if (user.getSessionId().equals(sessionId)) {
                if (isAccident) {
                    user.setAlive(false);
                } else {
                    this.userList.remove(user);
                }
            }
            ++i;
        }
    }

    public User getUser(String sessionId) {
        if (sessionId == null || sessionId.length() == 0) {
            return null;
        }
        for (User user : this.userList) {
            if (!user.getSessionId().equals(sessionId)) continue;
            return user;
        }
        return null;
    }

    public User[] getAllUsers() {
        return this.userList.toArray(new User[this.userList.size()]);
    }

    public String getMasterId() {
        return this.masterId;
    }

    public void setMasterId(String masterName) {
        this.masterId = masterName;
    }

    public boolean isGM(String sessionId) {
        return this.masterId.equals(sessionId);
    }

    void setAllUsers(User[] users) {
        this.userList.clear();
        User[] userArray = users;
        int n = users.length;
        int n2 = 0;
        while (n2 < n) {
            User user = userArray[n2];
            this.userList.add(user);
            ++n2;
        }
    }

    public String getName(String sessionId) {
        User user = this.getUser(sessionId);
        return user != null ? user.getName() : "";
    }
}

