/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.chaplet.core.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.text.Element;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import jp.sf.chaplet.StorageUtils;
import jp.sf.chaplet.core.ui.IPrefView;
import jp.sf.chaplet.core.ui.SelectFontDialog;

public class BasicPrefPanel
extends JPanel
implements IPrefView {
    private static final long serialVersionUID = 1L;
    private JLabel jLabel = null;
    private JTextField fontNameText = null;
    private JButton selectFontButton = null;
    private JLabel jLabel1 = null;
    private JLabel jLabel2 = null;
    private JTextField normalFontColorText = null;
    private JTextField systemFontColorText = null;
    private JButton selectNormalFontColorButton = null;
    private JButton selectSystemFontColorButton = null;
    private JScrollPane jScrollPane = null;
    private JTextPane sampleText = null;
    private HTMLEditorKit editorKit = null;
    private HTMLDocument sampleDoc = null;
    private JPanel jPanel = null;

    public BasicPrefPanel() {
        this.initialize();
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
        gridBagConstraints8.weighty = 10.0;
        gridBagConstraints8.gridy = 4;
        gridBagConstraints8.gridx = 0;
        GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
        gridBagConstraints7.fill = 1;
        gridBagConstraints7.gridy = 3;
        gridBagConstraints7.weightx = 1.0;
        gridBagConstraints7.weighty = 10.0;
        gridBagConstraints7.gridwidth = 3;
        gridBagConstraints7.gridx = 0;
        GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
        gridBagConstraints6.gridx = 2;
        gridBagConstraints6.gridy = 2;
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.gridx = 2;
        gridBagConstraints5.gridy = 1;
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.fill = 2;
        gridBagConstraints4.gridy = 2;
        gridBagConstraints4.weightx = 1.0;
        gridBagConstraints4.gridx = 1;
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.fill = 2;
        gridBagConstraints3.gridy = 1;
        gridBagConstraints3.weightx = 1.0;
        gridBagConstraints3.gridx = 1;
        GridBagConstraints gridBagConstraints21 = new GridBagConstraints();
        gridBagConstraints21.gridx = 0;
        gridBagConstraints21.weighty = 1.0;
        gridBagConstraints21.gridy = 2;
        this.jLabel2 = new JLabel();
        this.jLabel2.setText("\u6587\u5b57\u8272\uff08\u30b7\u30b9\u30c6\u30e0\uff09");
        GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
        gridBagConstraints11.gridx = 0;
        gridBagConstraints11.weighty = 1.0;
        gridBagConstraints11.gridy = 1;
        this.jLabel1 = new JLabel();
        this.jLabel1.setText("\u6587\u5b57\u8272\uff08\u901a\u5e38\uff09");
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 2;
        gridBagConstraints2.gridy = 0;
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.gridy = 0;
        gridBagConstraints1.weightx = 1.0;
        gridBagConstraints1.gridx = 1;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridy = 0;
        this.jLabel = new JLabel();
        this.jLabel.setText("\u30d5\u30a9\u30f3\u30c8");
        this.setSize(300, 200);
        this.setLayout(new GridBagLayout());
        this.add((Component)this.jLabel, gridBagConstraints);
        this.add((Component)this.getFontNameText(), gridBagConstraints1);
        this.add((Component)this.getSelectFontButton(), gridBagConstraints2);
        this.add((Component)this.jLabel1, gridBagConstraints11);
        this.add((Component)this.jLabel2, gridBagConstraints21);
        this.add((Component)this.getNormalFontColorText(), gridBagConstraints3);
        this.add((Component)this.getSystemFontColorText(), gridBagConstraints4);
        this.add((Component)this.getSelectNormalFontColorButton(), gridBagConstraints5);
        this.add((Component)this.getSelectSystemFontColorButton(), gridBagConstraints6);
        this.add((Component)this.getJScrollPane(), gridBagConstraints7);
        this.add((Component)this.getJPanel(), gridBagConstraints8);
        HashMap<String, Object> fontMap = StorageUtils.getFontMap();
        this.getNormalFontColorText().setText(fontMap.get("normalColor").toString());
        this.getSystemFontColorText().setText(fontMap.get("systemColor").toString());
        this.getFontNameText().setText(String.valueOf(fontMap.get("fontName").toString()) + ", " + fontMap.get("fontSize") + "pt");
    }

    private JTextField getFontNameText() {
        if (this.fontNameText == null) {
            this.fontNameText = new JTextField();
            this.fontNameText.setEditable(false);
            this.fontNameText.setBackground(SystemColor.activeCaptionText);
        }
        return this.fontNameText;
    }

    private JButton getSelectFontButton() {
        if (this.selectFontButton == null) {
            this.selectFontButton = new JButton();
            this.selectFontButton.setText("\u9078\u629e...");
            this.selectFontButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    final SelectFontDialog dialog = new SelectFontDialog((JFrame)SwingUtilities.getAncestorOfClass(JFrame.class, BasicPrefPanel.this));
                    dialog.addWindowListener(new WindowAdapter(){

                        public void windowClosed(WindowEvent e) {
                            if (dialog.isSelected()) {
                                BasicPrefPanel.this.getFontNameText().setText(String.valueOf(dialog.getSelectedFontName()) + ", " + dialog.getSelectedFontSize() + "pt");
                                BasicPrefPanel.this.changeCSS();
                            }
                        }
                    });
                    dialog.setVisible(true);
                }
            });
        }
        return this.selectFontButton;
    }

    private JTextField getNormalFontColorText() {
        if (this.normalFontColorText == null) {
            this.normalFontColorText = new JTextField();
            this.normalFontColorText.setText("000000");
        }
        return this.normalFontColorText;
    }

    private JTextField getSystemFontColorText() {
        if (this.systemFontColorText == null) {
            this.systemFontColorText = new JTextField();
            this.systemFontColorText.setText("ff0000");
        }
        return this.systemFontColorText;
    }

    private JButton getSelectNormalFontColorButton() {
        if (this.selectNormalFontColorButton == null) {
            this.selectNormalFontColorButton = new JButton();
            this.selectNormalFontColorButton.setText("\u9078\u629e...");
            this.selectNormalFontColorButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Color color = Color.BLACK;
                    try {
                        color = Color.decode(BasicPrefPanel.this.getNormalFontColorText().getText());
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    color = JColorChooser.showDialog(BasicPrefPanel.this, "\u6587\u5b57\u8272\uff08\u901a\u5e38\uff09", color);
                    if (color != null) {
                        BasicPrefPanel.this.getNormalFontColorText().setText(Integer.toHexString(color.getRGB() | 0xFF000000).substring(2));
                        BasicPrefPanel.this.changeCSS();
                    }
                }
            });
        }
        return this.selectNormalFontColorButton;
    }

    private JButton getSelectSystemFontColorButton() {
        if (this.selectSystemFontColorButton == null) {
            this.selectSystemFontColorButton = new JButton();
            this.selectSystemFontColorButton.setText("\u9078\u629e...");
            this.selectSystemFontColorButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Color color = Color.BLACK;
                    try {
                        color = Color.decode(BasicPrefPanel.this.getSystemFontColorText().getText());
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    color = JColorChooser.showDialog(BasicPrefPanel.this, "\u6587\u5b57\u8272\uff08\u30b7\u30b9\u30c6\u30e0\uff09", color);
                    BasicPrefPanel.this.getSystemFontColorText().setText(Integer.toHexString(color.getRGB() | 0xFF000000).substring(2));
                    BasicPrefPanel.this.changeCSS();
                }
            });
        }
        return this.selectSystemFontColorButton;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setHorizontalScrollBarPolicy(31);
            this.jScrollPane.setBackground(SystemColor.activeCaptionText);
            this.jScrollPane.setViewportView(this.getSampleText());
        }
        return this.jScrollPane;
    }

    private JTextPane getSampleText() {
        if (this.sampleText == null) {
            this.sampleText = new JTextPane();
            this.sampleText.setEditable(false);
            this.sampleText.setEditorKit(this.getEditorKit());
            this.sampleText.setDocument(this.getSampleDoc());
            try {
                Element html = this.getSampleDoc().getDefaultRootElement();
                Element body = html.getElement(0);
                Element paragraph = body.getElement(0);
                this.getSampleDoc().insertBeforeEnd(body, "<div id=\"user1\"><strong>\u30e6\u30fc\u30b61</strong> : \u30e6\u30fc\u30b6\uff11\u3055\u3093\u306e\u767a\u8a00\u3067\u3059\u3002</div>");
                this.getSampleDoc().insertBeforeEnd(body, "<div id=\"user2\"><strong>\u30e6\u30fc\u30b62</strong> : \u30e6\u30fc\u30b6\uff12\u3055\u3093\u306e\u767a\u8a00\u3067\u3059\u3002</div>");
                this.getSampleDoc().insertBeforeEnd(body, "<div id=\"system\">[SystemMessage\uff1a\u30b7\u30b9\u30c6\u30e0\u30e1\u30c3\u30bb\u30fc\u30b8\u3067\u3059]</div>");
                this.getSampleDoc().remove(paragraph.getStartOffset(), paragraph.getEndOffset() - paragraph.getStartOffset());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.sampleText;
    }

    private HTMLEditorKit getEditorKit() {
        if (this.editorKit == null) {
            this.editorKit = new HTMLEditorKit();
        }
        return this.editorKit;
    }

    private HTMLDocument getSampleDoc() {
        if (this.sampleDoc == null) {
            this.sampleDoc = (HTMLDocument)this.getEditorKit().createDefaultDocument();
            StyleSheet css = this.sampleDoc.getStyleSheet();
            HashMap<String, Object> fontMap = StorageUtils.getFontMap();
            css.addRule("body{font-size : " + fontMap.get("fontSize") + "pt ; font-family : \"" + fontMap.get("fontName") + "\",\"\uff2d\uff33 \u30b4\u30b7\u30c3\u30af\",Osaka,sans-serif;}");
            css.addRule("#system{color : #" + fontMap.get("systemColor") + "; font-weight:bold }");
            css.addRule("#user1{color : #" + fontMap.get("normalColor") + ";}");
            css.addRule("#user2{color : #" + fontMap.get("normalColor") + ";}");
        }
        return this.sampleDoc;
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            this.jPanel = new JPanel();
            this.jPanel.setLayout(new GridBagLayout());
        }
        return this.jPanel;
    }

    private void changeCSS() {
        StyleSheet css = this.getSampleDoc().getStyleSheet();
        HashMap<String, Object> fontMap = StorageUtils.getFontMap();
        css.addRule("body{font-size : " + fontMap.get("fontSize") + "pt ; font-family : \"" + fontMap.get("fontName") + "\",\"\uff2d\uff33 \u30b4\u30b7\u30c3\u30af\",Osaka,sans-serif;}");
        css.addRule("#system{color : #" + this.getSystemFontColorText().getText() + "; font-weight:bold }");
        css.addRule("#user1{color : #" + this.getNormalFontColorText().getText() + ";}");
        css.addRule("#user2{color : #" + this.getNormalFontColorText().getText() + ";}");
    }

    public String checkError() {
        if (this.getSystemFontColorText().getText().length() != 6 || this.getNormalFontColorText().getText().length() != 6) {
            return "\u6587\u5b57\u8272\u3092\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044";
        }
        return null;
    }

    public void save() {
        HashMap<String, Object> fontMap = StorageUtils.getFontMap();
        int comma = this.getFontNameText().getText().lastIndexOf(44);
        if (comma < 0) {
            throw new IllegalStateException("\u30d5\u30a9\u30f3\u30c8\u540d\u3068\u30b5\u30a4\u30ba\u3092\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044");
        }
        String fontName = this.getFontNameText().getText().substring(0, comma);
        fontMap.put("fontName", fontName);
        String fontSize = this.getFontNameText().getText().substring(comma + 2, this.getFontNameText().getText().lastIndexOf("pt"));
        try {
            fontMap.put("fontSize", Integer.parseInt(fontSize));
        }
        catch (NumberFormatException e) {
            throw new IllegalStateException("\u30d5\u30a9\u30f3\u30c8\u540d\u3068\u30b5\u30a4\u30ba\u3092\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044");
        }
        if (this.getSystemFontColorText().getText().length() != 6 || this.getNormalFontColorText().getText().length() != 6) {
            throw new IllegalStateException("\u6587\u5b57\u8272\u3092\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044");
        }
        fontMap.put("systemColor", this.getSystemFontColorText().getText());
        fontMap.put("normalColor", this.getNormalFontColorText().getText());
        StorageUtils.save(fontMap, "font.xml");
    }

    public String getTitle() {
        return "\u30d5\u30a9\u30f3\u30c8\u8a2d\u5b9a";
    }
}

