/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.chaplet.core.ui;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.DefaultFormatter;
import javax.swing.text.DefaultFormatterFactory;
import jp.sf.chaplet.StorageUtils;
import jp.sf.chaplet.core.client.ServerAddress;
import jp.sf.chaplet.core.client.Session;

public class ConnectDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JLabel jLabel = null;
    private JLabel jLabel1 = null;
    private JTextField serverText = null;
    private JFormattedTextField portText = null;
    private JPanel buttonPanel = null;
    private JButton okButton = null;
    private JScrollPane scrollPane = null;
    private JList historyList = null;
    private DefaultListModel historyListModel = null;
    private JButton cancelButton = null;
    private Action connectAction;
    private DefaultFormatter portFormatter = null;
    private DefaultFormatterFactory formatterFactory = null;
    private List<ServerAddress> addressList;
    private List<Session> sessionList;
    private JScrollPane scroll2Pane = null;
    private JList sessionIdList = null;
    private JLabel jLabel2 = null;
    private DefaultListModel sessionIdListModel = null;

    public ConnectDialog(Frame owner) {
        super(owner);
        this.initialize();
    }

    public void injectActions(ActionMap actionMap) {
        this.connectAction = actionMap.get("login");
    }

    private void initialize() {
        this.setSize(363, 220);
        this.setTitle("\u63a5\u7d9a\u8a2d\u5b9a");
        this.setContentPane(this.getJContentPane());
        this.addressList = (List)StorageUtils.load("server.xml", ArrayList.class);
        if (this.addressList == null || this.addressList.size() == 0) {
            this.addressList = new ArrayList<ServerAddress>();
            this.addressList.add(new ServerAddress("127.0.0.1", 10001));
        }
        for (ServerAddress address : this.addressList) {
            this.getHistoryListModel().addElement(address);
        }
        if (this.addressList.size() > 0) {
            ServerAddress address;
            address = this.addressList.get(0);
            this.getServerText().setText(address.getHost());
            this.getPortText().setText(String.valueOf(address.getPort()));
            this.getPortText().setValue(address.getPort());
        }
        this.getSessionIdListModel().addElement(new Session());
        this.sessionList = (List)StorageUtils.load("session.xml", ArrayList.class);
        for (Session session : this.sessionList) {
            if (session.isNew()) continue;
            this.getSessionIdListModel().addElement(session);
        }
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            GridBagConstraints gridBagConstraints21 = new GridBagConstraints();
            gridBagConstraints21.gridx = 2;
            gridBagConstraints21.gridy = 0;
            this.jLabel2 = new JLabel();
            this.jLabel2.setText("\u904e\u53bb\u306e\u30bb\u30c3\u30b7\u30e7\u30f3");
            GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
            gridBagConstraints11.fill = 1;
            gridBagConstraints11.gridy = 1;
            gridBagConstraints11.weightx = 60.0;
            gridBagConstraints11.weighty = 1.0;
            gridBagConstraints11.gridheight = 2;
            gridBagConstraints11.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints11.gridx = 2;
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.fill = 1;
            gridBagConstraints5.gridy = 2;
            gridBagConstraints5.weightx = 1.0;
            gridBagConstraints5.weighty = 1.0;
            gridBagConstraints5.gridwidth = 2;
            gridBagConstraints5.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints5.gridx = 0;
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridx = 0;
            gridBagConstraints4.weightx = 0.0;
            gridBagConstraints4.fill = 2;
            gridBagConstraints4.gridheight = 2;
            gridBagConstraints4.anchor = 11;
            gridBagConstraints4.gridwidth = 3;
            gridBagConstraints4.gridy = 3;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.fill = 2;
            gridBagConstraints3.gridy = 1;
            gridBagConstraints3.weightx = 5.0;
            gridBagConstraints3.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints3.gridx = 1;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.gridy = 1;
            gridBagConstraints2.weightx = 40.0;
            gridBagConstraints2.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints2.gridx = 0;
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridx = 1;
            gridBagConstraints1.gridy = 0;
            this.jLabel1 = new JLabel();
            this.jLabel1.setText("\u30dd\u30fc\u30c8\u756a\u53f7");
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            this.jLabel = new JLabel();
            this.jLabel.setText("\u30b5\u30fc\u30d0\u306e\u30a2\u30c9\u30ec\u30b9");
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new GridBagLayout());
            this.jContentPane.add((Component)this.jLabel, gridBagConstraints);
            this.jContentPane.add((Component)this.jLabel1, gridBagConstraints1);
            this.jContentPane.add((Component)this.getServerText(), gridBagConstraints2);
            this.jContentPane.add((Component)this.getPortText(), gridBagConstraints3);
            this.jContentPane.add((Component)this.getButtonPanel(), gridBagConstraints4);
            this.jContentPane.add((Component)this.getScrollPane(), gridBagConstraints5);
            this.jContentPane.add((Component)this.getScroll2Pane(), gridBagConstraints11);
            this.jContentPane.add((Component)this.jLabel2, gridBagConstraints21);
        }
        return this.jContentPane;
    }

    private JTextField getServerText() {
        if (this.serverText == null) {
            this.serverText = new JTextField();
        }
        return this.serverText;
    }

    private JFormattedTextField getPortText() {
        if (this.portText == null) {
            this.portText = new JFormattedTextField();
            this.portText.setFormatterFactory(this.getFormatterFactory());
        }
        return this.portText;
    }

    private JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.fill = 2;
            gridBagConstraints7.insets = new Insets(5, 5, 5, 5);
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.gridx = 1;
            gridBagConstraints6.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints6.gridy = 0;
            this.buttonPanel = new JPanel();
            this.buttonPanel.setLayout(new GridBagLayout());
            this.buttonPanel.setCursor(new Cursor(0));
            this.buttonPanel.add((Component)this.getOkButton(), gridBagConstraints7);
            this.buttonPanel.add((Component)this.getCancelButton(), gridBagConstraints6);
        }
        return this.buttonPanel;
    }

    private JButton getOkButton() {
        if (this.okButton == null) {
            this.okButton = new JButton();
            this.okButton.setText("  \u63a5\u7d9a  ");
            this.okButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ServerAddress address = new ServerAddress();
                    address.setHost(ConnectDialog.this.getServerText().getText());
                    address.setPort((Integer)ConnectDialog.this.getPortText().getValue());
                    Iterator iter = ConnectDialog.this.addressList.iterator();
                    while (iter.hasNext()) {
                        ServerAddress addr = (ServerAddress)iter.next();
                        if (!addr.equals(address)) continue;
                        iter.remove();
                    }
                    ConnectDialog.this.addressList.add(0, address);
                    if (ConnectDialog.this.addressList.size() > 7) {
                        ConnectDialog.this.addressList.remove(7);
                    }
                    StorageUtils.save(ConnectDialog.this.addressList, "server.xml");
                    Session session = (Session)ConnectDialog.this.sessionIdList.getSelectedValue();
                    if (session == null) {
                        session = new Session();
                    }
                    Iterator iterator = ConnectDialog.this.sessionList.iterator();
                    while (iterator.hasNext()) {
                        Session s = (Session)iterator.next();
                        if (!session.equals(s)) continue;
                        iterator.remove();
                        break;
                    }
                    ConnectDialog.this.sessionList.add(0, session);
                    int i = 7;
                    while (i < ConnectDialog.this.sessionList.size()) {
                        ConnectDialog.this.sessionList.remove(7);
                        ++i;
                    }
                    StorageUtils.save(ConnectDialog.this.sessionList, "session.xml");
                    ConnectDialog.this.connectAction.actionPerformed(e);
                    ConnectDialog.this.dispose();
                }
            });
        }
        return this.okButton;
    }

    private JScrollPane getScrollPane() {
        if (this.scrollPane == null) {
            this.scrollPane = new JScrollPane();
            this.scrollPane.setViewportView(this.getHistoryList());
        }
        return this.scrollPane;
    }

    private JList getHistoryList() {
        if (this.historyList == null) {
            this.historyList = new JList();
            this.historyList.setModel(this.getHistoryListModel());
            this.historyList.addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent e) {
                    ServerAddress address = (ServerAddress)ConnectDialog.this.getHistoryList().getSelectedValue();
                    if (address != null) {
                        ConnectDialog.this.getServerText().setText(address.getHost());
                        ConnectDialog.this.getPortText().setValue(address.getPort());
                    }
                }
            });
        }
        return this.historyList;
    }

    private DefaultListModel getHistoryListModel() {
        if (this.historyListModel == null) {
            this.historyListModel = new DefaultListModel();
        }
        return this.historyListModel;
    }

    private JButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton();
            this.cancelButton.setText("\u30ad\u30e3\u30f3\u30bb\u30eb");
            this.cancelButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ConnectDialog.this.dispose();
                }
            });
        }
        return this.cancelButton;
    }

    private DefaultFormatter getPortFormatter() {
        if (this.portFormatter == null) {
            this.portFormatter = new DefaultFormatter();
            this.portFormatter.setValueClass(Integer.class);
            this.portFormatter.setCommitsOnValidEdit(true);
        }
        return this.portFormatter;
    }

    private DefaultFormatterFactory getFormatterFactory() {
        if (this.formatterFactory == null) {
            this.formatterFactory = new DefaultFormatterFactory();
            this.formatterFactory.setNullFormatter(this.getPortFormatter());
            this.formatterFactory.setDisplayFormatter(this.getPortFormatter());
            this.formatterFactory.setDefaultFormatter(this.getPortFormatter());
            this.formatterFactory.setEditFormatter(this.getPortFormatter());
        }
        return this.formatterFactory;
    }

    private JScrollPane getScroll2Pane() {
        if (this.scroll2Pane == null) {
            this.scroll2Pane = new JScrollPane();
            this.scroll2Pane.setHorizontalScrollBarPolicy(31);
            this.scroll2Pane.setViewportView(this.getSessionIdList());
        }
        return this.scroll2Pane;
    }

    private JList getSessionIdList() {
        if (this.sessionIdList == null) {
            this.sessionIdList = new JList();
            this.sessionIdList.setModel(this.getSessionIdListModel());
        }
        return this.sessionIdList;
    }

    public DefaultListModel getSessionIdListModel() {
        if (this.sessionIdListModel == null) {
            this.sessionIdListModel = new DefaultListModel();
        }
        return this.sessionIdListModel;
    }
}

