/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.chaplet.core.ui;

import application.extension.StatusBar;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import javax.swing.ActionMap;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.text.Element;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import jp.sf.chaplet.DisplayMode;
import jp.sf.chaplet.StorageUtils;
import jp.sf.chaplet.UserStatus;
import jp.sf.chaplet.core.client.ClientPlugin;
import jp.sf.chaplet.core.ui.IMainView;
import jp.sf.chaplet.core.ui.PluginDialog;
import jp.sf.chaplet.core.ui.PluginPanel;
import jp.sf.chaplet.core.ui.PreferenceDialog;
import jp.sf.chaplet.core.ui.SelectFontDialog;
import jp.sf.chaplet.core.ui.UserTableCellRenderer;
import jp.sf.chaplet.core.ui.UserTableModel;
import jp.sf.chaplet.swing.UniqueComboBoxModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MainWindow
extends JFrame
implements IMainView {
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JSplitPane jSplitPane = null;
    private StatusBar statusBar = null;
    private JSplitPane leftPane = null;
    private JSplitPane rightPane = null;
    private JToolBar toolBar = null;
    private JButton connectButton = null;
    private JButton disconnectButton = null;
    private JButton serverButton = null;
    private JMenuBar jJMenuBar = null;
    private JMenu fileMenu = null;
    private JMenuItem exitItem = null;
    private JScrollPane textScrollPane = null;
    private JPanel chatPanel = null;
    private JLabel handleLabel = null;
    private JToggleButton slashButton = null;
    private JTextField handleText = null;
    private JComboBox aliasCombo = null;
    private JButton delAliasButton = null;
    private JScrollPane chatScrollPane = null;
    private JTextArea chatText = null;
    private JTextPane logText = null;
    private JButton writeButton = null;
    private JScrollPane userScrollPane = null;
    private JTable userTable = null;
    private JTabbedPane tabbedPane = null;
    private UserTableModel userTableModel = null;
    private HTMLDocument logDoc = null;
    private HTMLEditorKit editorKit = null;
    private boolean pExists = true;
    private boolean writing = false;
    private JMenuItem preferenceItem = null;
    private UserTableCellRenderer userTableCellRenderer = null;
    private UniqueComboBoxModel<String> aliasComboModel = null;
    private JPopupMenu logPopupMenu = null;
    private JMenuItem logPrefItem = null;
    private HashMap<String, ClientPlugin> pluginMap = new HashMap();
    private String selectedPluginId;
    private ActionMap actionMap;
    private JMenu adminMenu = null;
    private JMenuItem initAllItem = null;
    private JMenu setPrimaryMenu = null;
    private JMenuItem loadServerItem = null;
    private JMenuItem saveServerItem = null;
    private JMenu helpMenu = null;
    private JMenuItem aboutItem = null;
    private JRadioButtonMenuItem modeNoneItem = null;
    private ButtonGroup modeGroup = null;
    private PluginPanel pluginPanel = null;
    private JLabel jLabel = null;
    private JComboBox diceCombo = null;
    private JSpinner diceBonusSpinner = null;
    private JButton rollButton = null;
    private JPanel jPanel = null;
    private JLabel jLabel1 = null;
    private JToggleButton hideRollButton = null;
    private UniqueComboBoxModel<String> diceComboModel = null;
    private JMenuItem saveLogItem = null;
    private JPopupMenu userPopupMenu = null;
    private JMenuItem setGmItem = null;
    private HashMap<String, PluginDialog> dialogMap = new HashMap();

    public MainWindow() {
        this.initialize();
    }

    public void injectActions(ActionMap actionMap) {
        this.getConnectButton().setAction(actionMap.get("showConnectDialog"));
        this.getServerButton().setAction(actionMap.get("startServer"));
        this.getDisconnectButton().setAction(actionMap.get("logout"));
        this.getExitItem().setAction(actionMap.get("onExit"));
        this.getWriteButton().setAction(actionMap.get("chat"));
        this.actionMap = actionMap;
    }

    private void initialize() {
        this.setSize(880, 651);
        this.setDefaultCloseOperation(0);
        this.setJMenuBar(this.getJJMenuBar());
        this.setName("mainWindow");
        this.setContentPane(this.getJContentPane());
        this.setTitle("JFrame");
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getJSplitPane(), "Center");
            this.jContentPane.add((Component)this.getStatusBar(), "South");
            this.jContentPane.add((Component)this.getToolBar(), "North");
        }
        return this.jContentPane;
    }

    private JSplitPane getJSplitPane() {
        if (this.jSplitPane == null) {
            this.jSplitPane = new JSplitPane();
            this.jSplitPane.setDividerLocation(450);
            this.jSplitPane.setLeftComponent(this.getLeftPane());
            this.jSplitPane.setRightComponent(this.getRightPane());
        }
        return this.jSplitPane;
    }

    private StatusBar getStatusBar() {
        if (this.statusBar == null) {
            this.statusBar = new StatusBar();
        }
        return this.statusBar;
    }

    private JSplitPane getLeftPane() {
        if (this.leftPane == null) {
            this.leftPane = new JSplitPane();
            this.leftPane.setOrientation(0);
            this.leftPane.setDividerLocation(420);
            this.leftPane.setTopComponent(this.getTextScrollPane());
            this.leftPane.setBottomComponent(this.getChatPanel());
            this.leftPane.setName("leftPane");
        }
        return this.leftPane;
    }

    private JSplitPane getRightPane() {
        if (this.rightPane == null) {
            this.rightPane = new JSplitPane();
            this.rightPane.setName("rightPane");
            this.rightPane.setDividerLocation(120);
            this.rightPane.setTopComponent(this.getUserScrollPane());
            this.rightPane.setBottomComponent(this.getTabbedPane());
            this.rightPane.setOrientation(0);
        }
        return this.rightPane;
    }

    private JToolBar getToolBar() {
        if (this.toolBar == null) {
            this.toolBar = new JToolBar();
            this.toolBar.add(this.getConnectButton());
            this.toolBar.add(this.getDisconnectButton());
            this.toolBar.add(this.getServerButton());
            this.toolBar.addSeparator();
        }
        return this.toolBar;
    }

    private JButton getConnectButton() {
        if (this.connectButton == null) {
            this.connectButton = new JButton();
            this.connectButton.setName("connectButton");
        }
        return this.connectButton;
    }

    private JButton getDisconnectButton() {
        if (this.disconnectButton == null) {
            this.disconnectButton = new JButton();
            this.disconnectButton.setName("disconnectButton");
        }
        return this.disconnectButton;
    }

    private JButton getServerButton() {
        if (this.serverButton == null) {
            this.serverButton = new JButton();
            this.serverButton.setName("serverButton");
        }
        return this.serverButton;
    }

    private JMenuBar getJJMenuBar() {
        if (this.jJMenuBar == null) {
            this.jJMenuBar = new JMenuBar();
            this.jJMenuBar.add(this.getFileMenu());
            this.jJMenuBar.add(this.getAdminMenu());
            this.jJMenuBar.add(this.getHelpMenu());
        }
        return this.jJMenuBar;
    }

    private JMenu getFileMenu() {
        if (this.fileMenu == null) {
            this.fileMenu = new JMenu();
            this.fileMenu.setText("\u30d5\u30a1\u30a4\u30eb(F)");
            this.fileMenu.setMnemonic(70);
            this.fileMenu.add(this.getExitItem());
            this.fileMenu.add(this.getPreferenceItem());
            this.fileMenu.add(this.getSaveLogItem());
        }
        return this.fileMenu;
    }

    private JMenuItem getExitItem() {
        if (this.exitItem == null) {
            this.exitItem = new JMenuItem();
            this.exitItem.setMnemonic(88);
            this.exitItem.setName("exitItem");
            this.exitItem.setText("\u7d42\u4e86(X)");
        }
        return this.exitItem;
    }

    private JScrollPane getTextScrollPane() {
        if (this.textScrollPane == null) {
            this.textScrollPane = new JScrollPane();
            this.textScrollPane.setHorizontalScrollBarPolicy(31);
            this.textScrollPane.setViewportView(this.getLogText());
            this.textScrollPane.setVerticalScrollBarPolicy(22);
        }
        return this.textScrollPane;
    }

    private JPanel getChatPanel() {
        if (this.chatPanel == null) {
            GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
            gridBagConstraints8.gridx = 1;
            gridBagConstraints8.weightx = 10.0;
            gridBagConstraints8.fill = 2;
            gridBagConstraints8.gridwidth = 4;
            gridBagConstraints8.insets = new Insets(5, 0, 0, 0);
            gridBagConstraints8.gridy = 2;
            GridBagConstraints gridBagConstraints31 = new GridBagConstraints();
            gridBagConstraints31.gridx = 0;
            gridBagConstraints31.weightx = 1.0;
            gridBagConstraints31.gridy = 2;
            this.jLabel = new JLabel();
            this.jLabel.setText("\u30c0\u30a4\u30b9");
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.gridx = 4;
            gridBagConstraints6.fill = 1;
            gridBagConstraints6.insets = new Insets(4, 2, 0, 0);
            gridBagConstraints6.gridy = 1;
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.fill = 1;
            gridBagConstraints5.gridy = 1;
            gridBagConstraints5.weightx = 1.0;
            gridBagConstraints5.weighty = 1.0;
            gridBagConstraints5.gridwidth = 4;
            gridBagConstraints5.insets = new Insets(4, 0, 0, 0);
            gridBagConstraints5.gridx = 0;
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridx = 4;
            gridBagConstraints4.insets = new Insets(0, 2, 0, 0);
            gridBagConstraints4.weightx = 10.0;
            gridBagConstraints4.gridy = 0;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.fill = 2;
            gridBagConstraints3.gridy = 0;
            gridBagConstraints3.weightx = 40.0;
            gridBagConstraints3.gridx = 3;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.gridy = 0;
            gridBagConstraints2.weightx = 40.0;
            gridBagConstraints2.gridx = 1;
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridx = 2;
            gridBagConstraints1.insets = new Insets(0, 2, 0, 2);
            gridBagConstraints1.weightx = 0.0;
            gridBagConstraints1.gridy = 0;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.fill = 3;
            gridBagConstraints.insets = new Insets(0, 0, 0, 8);
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridy = 0;
            this.handleLabel = new JLabel();
            this.handleLabel.setText("\u30cf\u30f3\u30c9\u30eb");
            this.handleLabel.setName("handleLabel");
            this.chatPanel = new JPanel();
            this.chatPanel.setLayout(new GridBagLayout());
            this.chatPanel.add((Component)this.handleLabel, gridBagConstraints);
            this.chatPanel.add((Component)this.getSlashButton(), gridBagConstraints1);
            this.chatPanel.add((Component)this.getHandleText(), gridBagConstraints2);
            this.chatPanel.add((Component)this.getAliasCombo(), gridBagConstraints3);
            this.chatPanel.add((Component)this.getDelAliasButton(), gridBagConstraints4);
            this.chatPanel.add((Component)this.getChatScrollPane(), gridBagConstraints5);
            this.chatPanel.add((Component)this.getWriteButton(), gridBagConstraints6);
            this.chatPanel.add((Component)this.jLabel, gridBagConstraints31);
            this.chatPanel.add((Component)this.getJPanel(), gridBagConstraints8);
        }
        return this.chatPanel;
    }

    public JToggleButton getSlashButton() {
        if (this.slashButton == null) {
            this.slashButton = new JToggleButton();
            this.slashButton.setText("/");
        }
        return this.slashButton;
    }

    public JTextField getHandleText() {
        if (this.handleText == null) {
            this.handleText = new JTextField();
            this.handleText.setPreferredSize(new Dimension(100, 19));
        }
        return this.handleText;
    }

    public JComboBox getAliasCombo() {
        if (this.aliasCombo == null) {
            this.aliasCombo = new JComboBox();
            this.aliasCombo.setEditable(true);
            this.aliasCombo.setModel(this.getAliasComboModel());
            this.aliasCombo.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MainWindow.this.getAliasComboModel().add(MainWindow.this.aliasCombo.getSelectedItem().toString());
                }
            });
        }
        return this.aliasCombo;
    }

    private JButton getDelAliasButton() {
        if (this.delAliasButton == null) {
            this.delAliasButton = new JButton();
            this.delAliasButton.setName("delAliasButton");
            this.delAliasButton.setText("\u524a\u9664");
            this.delAliasButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    int index = MainWindow.this.getAliasCombo().getSelectedIndex();
                    if (index >= 0) {
                        MainWindow.this.getAliasComboModel().remove(index);
                        MainWindow.this.getAliasCombo().setSelectedItem("");
                    }
                }
            });
        }
        return this.delAliasButton;
    }

    private JScrollPane getChatScrollPane() {
        if (this.chatScrollPane == null) {
            this.chatScrollPane = new JScrollPane();
            this.chatScrollPane.setHorizontalScrollBarPolicy(31);
            this.chatScrollPane.setVerticalScrollBarPolicy(22);
            this.chatScrollPane.setViewportView(this.getChatText());
        }
        return this.chatScrollPane;
    }

    public JTextArea getChatText() {
        if (this.chatText == null) {
            this.chatText = new JTextArea();
            this.chatText.setLineWrap(true);
            this.chatText.setEnabled(false);
            this.chatText.addKeyListener(new KeyAdapter(){

                public void keyTyped(KeyEvent e) {
                    if (MainWindow.this.chatText.getText().length() == 0 && MainWindow.this.writing || MainWindow.this.chatText.getText().length() > 0 && !MainWindow.this.writing) {
                        MainWindow.this.writing = !MainWindow.this.writing;
                        MainWindow.this.actionMap.get("writing").actionPerformed(new ActionEvent(MainWindow.this.chatText, 0, "writing"));
                    }
                    if (e.getKeyChar() == '\n') {
                        if (e.isControlDown()) {
                            MainWindow.this.chatText.append("\n");
                        } else {
                            MainWindow.this.writeButton.getAction().actionPerformed(new ActionEvent(MainWindow.this.writeButton, 1001, "chat"));
                        }
                    }
                }
            });
        }
        return this.chatText;
    }

    private JTextPane getLogText() {
        if (this.logText == null) {
            this.logText = new JTextPane();
            this.logText.setEditable(false);
            this.logText.setEditorKit(this.getEditorKit());
            this.logText.setContentType("text/html");
            this.logText.setDocument(this.getLogDoc());
            this.logText.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    if (SwingUtilities.isRightMouseButton(e)) {
                        MainWindow.this.getLogPopupMenu().show(MainWindow.this.logText, e.getX(), e.getY());
                    }
                }
            });
        }
        return this.logText;
    }

    private JButton getWriteButton() {
        if (this.writeButton == null) {
            this.writeButton = new JButton();
            this.writeButton.setName("writeButton");
            this.writeButton.setEnabled(false);
            this.writeButton.setText("\u767a\u8a00");
        }
        return this.writeButton;
    }

    private JScrollPane getUserScrollPane() {
        if (this.userScrollPane == null) {
            this.userScrollPane = new JScrollPane();
            this.userScrollPane.setViewportView(this.getUserTable());
        }
        return this.userScrollPane;
    }

    public JTable getUserTable() {
        if (this.userTable == null) {
            this.userTable = new JTable();
            this.userTable.setAutoResizeMode(2);
            this.userTable.setModel(this.getUserTableModel());
            this.userTable.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    int rowIndex = MainWindow.this.getUserTable().getSelectedRow();
                    if (rowIndex >= 0 && SwingUtilities.isRightMouseButton(e)) {
                        MainWindow.this.getUserPopupMenu().show(MainWindow.this.userTable, e.getX(), e.getY());
                    }
                }
            });
            TableColumnModel tcm = this.userTable.getColumnModel();
            TableColumn column0 = tcm.getColumn(0);
            column0.setPreferredWidth(100);
            column0.setCellRenderer(this.getUserTableCellRenderer());
            TableColumn column1 = tcm.getColumn(1);
            column1.setPreferredWidth(20);
            column1.setMaxWidth(20);
            column1.setMinWidth(20);
            column1.setCellRenderer(this.getUserTableCellRenderer());
            TableColumn column2 = tcm.getColumn(2);
            column2.setPreferredWidth(200);
            column2.setCellRenderer(this.getUserTableCellRenderer());
        }
        return this.userTable;
    }

    private JTabbedPane getTabbedPane() {
        if (this.tabbedPane == null) {
            this.tabbedPane = new JTabbedPane();
            this.tabbedPane.addTab("\u30d7\u30e9\u30b0\u30a4\u30f3", null, this.getPluginPanel(), null);
        }
        return this.tabbedPane;
    }

    public UserTableModel getUserTableModel() {
        if (this.userTableModel == null) {
            this.userTableModel = new UserTableModel();
        }
        return this.userTableModel;
    }

    @Override
    public void addPluginView(final ClientPlugin plugin) {
        this.pluginMap.put(plugin.getPluginId(), plugin);
        if (plugin.getDisplayMode() == DisplayMode.TAB) {
            this.showAsTabItem(plugin);
        }
        JRadioButtonMenuItem menuItem = new JRadioButtonMenuItem();
        menuItem.setText(plugin.getName());
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainWindow.this.selectedPluginId = plugin.getPluginId();
                MainWindow.this.actionMap.get("setPrimaryPlugin").actionPerformed(e);
            }
        });
        this.getModeGroup().add(menuItem);
        this.getSetPrimaryMenu().add(menuItem);
        plugin.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("displayMode")) {
                    PluginDialog dialog;
                    ClientPlugin plugin = (ClientPlugin)((Object)evt.getSource());
                    if (evt.getNewValue() == DisplayMode.TAB) {
                        MainWindow.this.showAsTabItem(plugin);
                    } else if (evt.getNewValue() == DisplayMode.WINDOW) {
                        MainWindow.this.showAsWindow(plugin);
                    }
                    if (evt.getOldValue() == DisplayMode.TAB) {
                        MainWindow.this.removeTabItem(plugin);
                    } else if (evt.getOldValue() == DisplayMode.WINDOW && (dialog = (PluginDialog)MainWindow.this.dialogMap.get(plugin.getPluginId())) != null) {
                        dialog.dispose();
                    }
                }
            }
        });
    }

    @Override
    public void appendFunctionLog(String funcName, String name, String text) {
        if (text.equals("-")) {
            text = "\u975e\u516c\u958b\u30c0\u30a4\u30b9\u304c\u632f\u3089\u308c\u307e\u3057\u305f";
        }
        StringBuilder html = new StringBuilder("<div id=\"system\">[");
        html.append(funcName);
        html.append(":");
        html.append(name);
        html.append("]");
        html.append(text);
        html.append("</div>");
        try {
            Element body = this.getLogDoc().getDefaultRootElement().getElement(0);
            this.getLogDoc().insertBeforeEnd(body, html.toString());
            if (this.pExists) {
                Element paragraph = body.getElement(0);
                this.getLogDoc().remove(paragraph.getStartOffset(), paragraph.getEndOffset() - paragraph.getStartOffset());
                this.pExists = false;
            }
            this.getLogText().setCaretPosition(this.getLogDoc().getLength());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void appendLog(String[] text) {
        StringBuilder html = new StringBuilder("<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tr valign=\"top\"><div class=\"user1\" id=\"user1\"><strong>");
        html.append(text[1]);
        html.append("</strong> : </div></td><td valign=\"top\"><div  class=\"user1\" id=\"user1\">");
        int i = 2;
        while (i < text.length) {
            html.append(text[i]);
            html.append("<br>");
            ++i;
        }
        if (text.length > 1) {
            html.delete(html.length() - 4, html.length());
        }
        html.append("</td></div></tr></table>");
        try {
            Element body = this.getLogDoc().getDefaultRootElement().getElement(0);
            this.getLogDoc().insertBeforeEnd(body, html.toString());
            if (this.pExists) {
                Element paragraph = body.getElement(0);
                this.getLogDoc().remove(paragraph.getStartOffset(), paragraph.getEndOffset() - paragraph.getStartOffset());
                this.pExists = false;
            }
            this.getLogText().setCaretPosition(this.getLogDoc().getLength());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void appendSystemLog(String text) {
        StringBuilder html = new StringBuilder("<div id=\"system\">[SystemMessage\uff1a");
        html.append(text);
        html.append("]</div>");
        try {
            Element body = this.getLogDoc().getDefaultRootElement().getElement(0);
            this.getLogDoc().insertBeforeEnd(body, html.toString());
            if (this.pExists) {
                Element paragraph = body.getElement(0);
                this.getLogDoc().remove(paragraph.getStartOffset(), paragraph.getEndOffset() - paragraph.getStartOffset());
                this.pExists = false;
            }
            this.getLogText().setCaretPosition(this.getLogDoc().getLength());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getSelectedUser() {
        UserStatus user = this.getUserTableModel().getRow(this.getUserTable().getSelectedRow());
        if (user != null) {
            return user.getName();
        }
        return null;
    }

    @Override
    public void setLoginOK(boolean ok) {
        this.connectButton.setEnabled(!ok);
        this.disconnectButton.setEnabled(ok);
        this.serverButton.setEnabled(!ok);
        this.writeButton.setEnabled(ok);
        this.chatText.setEnabled(ok);
        for (ClientPlugin plugin : this.pluginMap.values()) {
            plugin.getPluginView().setLoginOK(ok);
        }
    }

    @Override
    public void setMessage(String message) {
        this.getStatusBar().setMessage(message);
    }

    @Override
    public void setStatus(String status) {
        this.getStatusBar().setMessage(status);
    }

    @Override
    public void showAsTabItem(ClientPlugin plugin) {
        JPanel panel = plugin.getSwingComponent();
        this.getTabbedPane().addTab(plugin.getName(), panel);
    }

    @Override
    public void removeTabItem(ClientPlugin plugin) {
        this.getTabbedPane().remove(plugin.getSwingComponent());
    }

    @Override
    public void showAsWindow(final ClientPlugin plugin) {
        final PluginDialog dialog = new PluginDialog(this);
        dialog.add((Component)plugin.getSwingComponent(), "Center");
        dialog.setTitle(plugin.getName());
        dialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                plugin.setDisplayMode(DisplayMode.NONE);
                MainWindow.this.getPluginPanel().getPluginTableModel().fireTableDataChanged();
            }
        });
        this.dialogMap.put(plugin.getPluginId(), dialog);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                dialog.setVisible(true);
            }
        });
    }

    @Override
    public void showStatus(UserStatus[] status) {
        this.getUserTableModel().setAll(status);
    }

    @Override
    public String getPluginId() {
        return "jp.sf.chaplet.core";
    }

    @Override
    public String getPluginName() {
        return "Chaplet";
    }

    @Override
    public JPanel getSwingComponent() {
        return null;
    }

    @Override
    public void setController(ClientPlugin ctl) {
    }

    @Override
    public void setGM(boolean gm) {
        this.getAdminMenu().setEnabled(gm);
        for (ClientPlugin plugin : this.pluginMap.values()) {
            plugin.getPluginView().setGM(gm);
        }
    }

    public HTMLDocument getLogDoc() {
        if (this.logDoc == null) {
            this.logDoc = (HTMLDocument)this.getEditorKit().createDefaultDocument();
            this.changeCSS();
        }
        return this.logDoc;
    }

    public HTMLEditorKit getEditorKit() {
        if (this.editorKit == null) {
            this.editorKit = new HTMLEditorKit();
        }
        return this.editorKit;
    }

    private JMenuItem getPreferenceItem() {
        if (this.preferenceItem == null) {
            this.preferenceItem = new JMenuItem();
            this.preferenceItem.setText("\u8a2d\u5b9a(P)");
            this.preferenceItem.setAccelerator(KeyStroke.getKeyStroke(0, 0, false));
            this.preferenceItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    PreferenceDialog dialog = new PreferenceDialog(MainWindow.this);
                    dialog.setLocationRelativeTo(MainWindow.this);
                    dialog.addWindowListener(new WindowAdapter(){

                        public void windowClosed(WindowEvent e) {
                            MainWindow.this.changeCSS();
                        }
                    });
                    dialog.setVisible(true);
                }
            });
        }
        return this.preferenceItem;
    }

    private UserTableCellRenderer getUserTableCellRenderer() {
        if (this.userTableCellRenderer == null) {
            this.userTableCellRenderer = new UserTableCellRenderer();
        }
        return this.userTableCellRenderer;
    }

    public UniqueComboBoxModel<String> getAliasComboModel() {
        if (this.aliasComboModel == null) {
            this.aliasComboModel = new UniqueComboBoxModel();
        }
        return this.aliasComboModel;
    }

    private JPopupMenu getLogPopupMenu() {
        if (this.logPopupMenu == null) {
            this.logPopupMenu = new JPopupMenu();
            this.logPopupMenu.add(this.getLogPrefItem());
        }
        return this.logPopupMenu;
    }

    private void changeCSS() {
        StyleSheet css = this.logDoc.getStyleSheet();
        HashMap<String, Object> fontMap = StorageUtils.getFontMap();
        css.addRule("body{font-size : " + fontMap.get("fontSize") + "pt ; font-family : \"" + fontMap.get("fontName") + "\",\"\uff2d\uff33 \u30b4\u30b7\u30c3\u30af\",Osaka,sans-serif;}");
        css.addRule("#system{color : #" + fontMap.get("systemColor") + "; font-weight:bold }");
        css.addRule("#user1{color : #" + fontMap.get("normalColor") + "; vertical-align : top;}");
        css.addRule("#user2{color : #" + fontMap.get("normalColor") + "; vertical-align : top;}");
    }

    private JMenuItem getLogPrefItem() {
        if (this.logPrefItem == null) {
            this.logPrefItem = new JMenuItem();
            this.logPrefItem.setText("\u30d5\u30a9\u30f3\u30c8\u8a2d\u5b9a...");
            this.logPrefItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    final SelectFontDialog dialog = new SelectFontDialog(MainWindow.this);
                    dialog.setVisible(true);
                    dialog.addWindowListener(new WindowAdapter(){

                        public void windowClosed(WindowEvent e) {
                            if (dialog.isSelected()) {
                                HashMap<String, Object> fontMap = StorageUtils.getFontMap();
                                fontMap.put("fontName", dialog.getSelectedFontName());
                                fontMap.put("fontSize", dialog.getSelectedFontSize());
                                StorageUtils.save(fontMap, "font.xml");
                                MainWindow.this.changeCSS();
                            }
                        }
                    });
                }
            });
        }
        return this.logPrefItem;
    }

    private JMenu getAdminMenu() {
        if (this.adminMenu == null) {
            this.adminMenu = new JMenu();
            this.adminMenu.setText("\u7ba1\u7406(A)");
            this.adminMenu.setEnabled(false);
            this.adminMenu.setMnemonic(65);
            this.adminMenu.add(this.getInitAllItem());
            this.adminMenu.add(this.getSetPrimaryMenu());
            this.adminMenu.add(this.getLoadServerItem());
            this.adminMenu.add(this.getSaveServerItem());
        }
        return this.adminMenu;
    }

    private JMenuItem getInitAllItem() {
        if (this.initAllItem == null) {
            this.initAllItem = new JMenuItem();
            this.initAllItem.setText("\u3059\u3079\u3066\u521d\u671f\u5316");
            this.initAllItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MainWindow.this.actionMap.get("reload").actionPerformed(e);
                }
            });
        }
        return this.initAllItem;
    }

    private JMenu getSetPrimaryMenu() {
        if (this.setPrimaryMenu == null) {
            this.setPrimaryMenu = new JMenu();
            this.setPrimaryMenu.setText("\u30e2\u30fc\u30c9\u306e\u9078\u629e");
            this.setPrimaryMenu.add(this.getModeNoneItem());
        }
        return this.setPrimaryMenu;
    }

    private JMenuItem getLoadServerItem() {
        if (this.loadServerItem == null) {
            this.loadServerItem = new JMenuItem();
            this.loadServerItem.setText("\u30b5\u30fc\u30d0\u306e\u72b6\u614b\u3092\u8aad\u307f\u8fbc\u307f");
            this.loadServerItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MainWindow.this.actionMap.get("loadServerSetting").actionPerformed(e);
                }
            });
        }
        return this.loadServerItem;
    }

    private JMenuItem getSaveServerItem() {
        if (this.saveServerItem == null) {
            this.saveServerItem = new JMenuItem();
            this.saveServerItem.setText("\u30b5\u30fc\u30d0\u306e\u72b6\u614b\u3092\u4fdd\u5b58");
            this.saveServerItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MainWindow.this.actionMap.get("saveServerSetting").actionPerformed(e);
                }
            });
        }
        return this.saveServerItem;
    }

    private JMenu getHelpMenu() {
        if (this.helpMenu == null) {
            this.helpMenu = new JMenu();
            this.helpMenu.setText("\u30d8\u30eb\u30d7(H)");
            this.helpMenu.setMnemonic(72);
            this.helpMenu.add(this.getAboutItem());
        }
        return this.helpMenu;
    }

    private JMenuItem getAboutItem() {
        if (this.aboutItem == null) {
            this.aboutItem = new JMenuItem();
            this.aboutItem.setText("Chaplet\u306b\u3064\u3044\u3066");
            this.aboutItem.setMnemonic(65);
        }
        return this.aboutItem;
    }

    private JRadioButtonMenuItem getModeNoneItem() {
        if (this.modeNoneItem == null) {
            this.modeNoneItem = new JRadioButtonMenuItem();
            this.modeNoneItem.setText("\u306a\u3057");
            this.modeNoneItem.setSelected(true);
            this.getModeGroup().add(this.modeNoneItem);
        }
        return this.modeNoneItem;
    }

    private ButtonGroup getModeGroup() {
        if (this.modeGroup == null) {
            this.modeGroup = new ButtonGroup();
        }
        return this.modeGroup;
    }

    public String getSelectedPluginId() {
        return this.selectedPluginId;
    }

    private PluginPanel getPluginPanel() {
        if (this.pluginPanel == null) {
            this.pluginPanel = new PluginPanel();
        }
        return this.pluginPanel;
    }

    public JComboBox getDiceCombo() {
        if (this.diceCombo == null) {
            this.diceCombo = new JComboBox();
            this.diceCombo.setEditable(true);
            this.diceCombo.setModel(this.getDiceComboModel());
            this.diceCombo.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MainWindow.this.getDiceComboModel().add(MainWindow.this.diceCombo.getSelectedItem().toString());
                }
            });
        }
        return this.diceCombo;
    }

    public JSpinner getDiceBonusSpinner() {
        if (this.diceBonusSpinner == null) {
            this.diceBonusSpinner = new JSpinner();
        }
        return this.diceBonusSpinner;
    }

    private JButton getRollButton() {
        if (this.rollButton == null) {
            this.rollButton = new JButton();
            this.rollButton.setText("\u632f\u308b");
            this.rollButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MainWindow.this.actionMap.get("rollSum").actionPerformed(e);
                }
            });
        }
        return this.rollButton;
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
            gridBagConstraints11.insets = new Insets(0, 2, 0, 0);
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.gridx = -1;
            gridBagConstraints7.insets = new Insets(0, 2, 0, 2);
            gridBagConstraints7.gridy = -1;
            GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
            gridBagConstraints10.gridx = -1;
            gridBagConstraints10.weightx = 1.0;
            gridBagConstraints10.fill = 1;
            gridBagConstraints10.gridy = -1;
            this.jLabel1 = new JLabel();
            this.jLabel1.setText("\uff0b");
            GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
            gridBagConstraints9.fill = 1;
            gridBagConstraints9.gridy = -1;
            gridBagConstraints9.weightx = 10.0;
            gridBagConstraints9.gridx = -1;
            this.jPanel = new JPanel();
            this.jPanel.setLayout(new GridBagLayout());
            this.jPanel.add((Component)this.getDiceCombo(), gridBagConstraints9);
            this.jPanel.add((Component)this.jLabel1, new GridBagConstraints());
            this.jPanel.add((Component)this.getDiceBonusSpinner(), gridBagConstraints10);
            this.jPanel.add((Component)this.getRollButton(), gridBagConstraints7);
            this.jPanel.add((Component)this.getHideRollButton(), gridBagConstraints11);
        }
        return this.jPanel;
    }

    public JToggleButton getHideRollButton() {
        if (this.hideRollButton == null) {
            this.hideRollButton = new JToggleButton();
            this.hideRollButton.setText("\u96a0\u3059");
        }
        return this.hideRollButton;
    }

    private UniqueComboBoxModel<String> getDiceComboModel() {
        if (this.diceComboModel == null) {
            this.diceComboModel = new UniqueComboBoxModel();
            this.diceComboModel.setMax(10);
        }
        return this.diceComboModel;
    }

    private JMenuItem getSaveLogItem() {
        if (this.saveLogItem == null) {
            this.saveLogItem = new JMenuItem();
            this.saveLogItem.setText("\u4fdd\u5b58(S)");
            this.saveLogItem.setActionCommand("\u4fdd\u5b58(S)...");
            this.saveLogItem.setAccelerator(KeyStroke.getKeyStroke(83, 2, false));
            this.saveLogItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MainWindow.this.actionMap.get("saveLog").actionPerformed(e);
                }
            });
        }
        return this.saveLogItem;
    }

    private JPopupMenu getUserPopupMenu() {
        if (this.userPopupMenu == null) {
            this.userPopupMenu = new JPopupMenu();
            this.userPopupMenu.add(this.getSetGmItem());
        }
        return this.userPopupMenu;
    }

    private JMenuItem getSetGmItem() {
        if (this.setGmItem == null) {
            this.setGmItem = new JMenuItem();
            this.setGmItem.setText("GM\u306b\u9078\u3076");
            this.setGmItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MainWindow.this.actionMap.get("callSetGM").actionPerformed(e);
                }
            });
        }
        return this.setGmItem;
    }
}

