/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.chaplet.core.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.Element;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import jp.sf.chaplet.StorageUtils;

public class SelectFontDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JLabel jLabel = null;
    private JLabel jLabel2 = null;
    private JPanel buttonPanel = null;
    private JButton okButton = null;
    private JButton cancelButton = null;
    private JScrollPane scrollPane = null;
    private JScrollPane scroll3Pane = null;
    private JPanel samplePanel = null;
    private JList fontNameList = null;
    private JList fontSizeList = null;
    private DefaultListModel fontNameModel = null;
    private DefaultListModel fontSizeModel = null;
    private JTextPane sampleText = null;
    private HTMLDocument document = null;
    private HTMLEditorKit editorKit = null;
    private JScrollPane scroll4Pane = null;
    private boolean selected = false;

    public SelectFontDialog(Frame owner) {
        super(owner);
        this.initialize();
    }

    private void initialize() {
        this.setSize(440, 300);
        this.setResizable(false);
        this.setTitle("\u30d5\u30a9\u30f3\u30c8");
        this.setContentPane(this.getJContentPane());
        HashMap<String, Object> fontMap = null;
        fontMap = StorageUtils.getFontMap();
        this.fontNameList.setSelectedValue(fontMap.get("fontName"), true);
        this.fontSizeList.setSelectedValue(fontMap.get("fontSize"), true);
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
            gridBagConstraints9.gridx = 0;
            gridBagConstraints9.fill = 1;
            gridBagConstraints9.gridwidth = 3;
            gridBagConstraints9.weighty = 10.0;
            gridBagConstraints9.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints9.gridy = 3;
            GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
            gridBagConstraints8.fill = 1;
            gridBagConstraints8.gridy = 2;
            gridBagConstraints8.weightx = 15.0;
            gridBagConstraints8.weighty = 1.0;
            gridBagConstraints8.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints8.gridx = 1;
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.fill = 1;
            gridBagConstraints6.gridy = 2;
            gridBagConstraints6.weightx = 40.0;
            gridBagConstraints6.weighty = 50.0;
            gridBagConstraints6.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints6.gridx = 0;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 2;
            gridBagConstraints3.weightx = 5.0;
            gridBagConstraints3.gridheight = 2;
            gridBagConstraints3.anchor = 11;
            gridBagConstraints3.gridy = 1;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 1;
            gridBagConstraints2.weightx = 10.0;
            gridBagConstraints2.gridy = 0;
            this.jLabel2 = new JLabel();
            this.jLabel2.setText("\u30b5\u30a4\u30ba");
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.weightx = 70.0;
            gridBagConstraints.gridy = 0;
            this.jLabel = new JLabel();
            this.jLabel.setText("\u30d5\u30a9\u30f3\u30c8\u540d");
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new GridBagLayout());
            this.jContentPane.add((Component)this.jLabel, gridBagConstraints);
            this.jContentPane.add((Component)this.jLabel2, gridBagConstraints2);
            this.jContentPane.add((Component)this.getButtonPanel(), gridBagConstraints3);
            this.jContentPane.add((Component)this.getScrollPane(), gridBagConstraints6);
            this.jContentPane.add((Component)this.getScroll3Pane(), gridBagConstraints8);
            this.jContentPane.add((Component)this.getSamplePanel(), gridBagConstraints9);
        }
        return this.jContentPane;
    }

    private JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.insets = new Insets(5, 3, 5, 5);
            gridBagConstraints5.gridy = 1;
            gridBagConstraints5.fill = 2;
            gridBagConstraints5.gridx = 0;
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.insets = new Insets(5, 5, 5, 2);
            gridBagConstraints4.gridy = 0;
            gridBagConstraints4.fill = 2;
            gridBagConstraints4.gridx = 0;
            this.buttonPanel = new JPanel();
            this.buttonPanel.setLayout(new GridBagLayout());
            this.buttonPanel.add((Component)this.getOkButton(), gridBagConstraints4);
            this.buttonPanel.add((Component)this.getCancelButton(), gridBagConstraints5);
        }
        return this.buttonPanel;
    }

    private JButton getOkButton() {
        if (this.okButton == null) {
            this.okButton = new JButton();
            this.okButton.setText("OK");
            this.okButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    SelectFontDialog.this.selected = true;
                    SelectFontDialog.this.dispose();
                }
            });
        }
        return this.okButton;
    }

    private JButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton();
            this.cancelButton.setText("\u30ad\u30e3\u30f3\u30bb\u30eb");
            this.cancelButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    SelectFontDialog.this.dispose();
                }
            });
        }
        return this.cancelButton;
    }

    private JScrollPane getScrollPane() {
        if (this.scrollPane == null) {
            this.scrollPane = new JScrollPane();
            this.scrollPane.setHorizontalScrollBarPolicy(31);
            this.scrollPane.setViewportView(this.getFontNameList());
        }
        return this.scrollPane;
    }

    private JScrollPane getScroll3Pane() {
        if (this.scroll3Pane == null) {
            this.scroll3Pane = new JScrollPane();
            this.scroll3Pane.setHorizontalScrollBarPolicy(31);
            this.scroll3Pane.setViewportView(this.getFontSizeList());
        }
        return this.scroll3Pane;
    }

    private JPanel getSamplePanel() {
        if (this.samplePanel == null) {
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.fill = 1;
            gridBagConstraints7.weighty = 1.0;
            gridBagConstraints7.weightx = 1.0;
            this.samplePanel = new JPanel();
            this.samplePanel.setLayout(new GridBagLayout());
            this.samplePanel.setBorder(BorderFactory.createTitledBorder(null, "\u30b5\u30f3\u30d7\u30eb", 0, 0, new Font("MS UI Gothic", 0, 12), Color.black));
            this.samplePanel.add((Component)this.getScroll4Pane(), gridBagConstraints7);
        }
        return this.samplePanel;
    }

    private void changeCSS() {
        StyleSheet css = this.document.getStyleSheet();
        Object fontSize = this.fontSizeList.getSelectedValue();
        Object fontName = this.fontNameList.getSelectedValue();
        if (fontName != null && fontSize != null) {
            css.addRule("body{font-family : \"" + fontName.toString() + "\",\"\uff2d\uff33 \u30b4\u30b7\u30c3\u30af\",Osaka,sans-serif; font-size : " + fontSize.toString() + "pt }");
        }
    }

    public JList getFontNameList() {
        if (this.fontNameList == null) {
            this.fontNameList = new JList();
            this.fontNameList.setModel(this.getFontNameModel());
            this.fontNameList.addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent e) {
                    SelectFontDialog.this.changeCSS();
                }
            });
        }
        return this.fontNameList;
    }

    public JList getFontSizeList() {
        if (this.fontSizeList == null) {
            this.fontSizeList = new JList();
            this.fontSizeList.setModel(this.getFontSizeModel());
            this.fontSizeList.addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent e) {
                    SelectFontDialog.this.changeCSS();
                }
            });
        }
        return this.fontSizeList;
    }

    private DefaultListModel getFontNameModel() {
        if (this.fontNameModel == null) {
            String[] fonts;
            this.fontNameModel = new DefaultListModel();
            GraphicsEnvironment gc = GraphicsEnvironment.getLocalGraphicsEnvironment();
            String[] stringArray = fonts = gc.getAvailableFontFamilyNames();
            int n = fonts.length;
            int n2 = 0;
            while (n2 < n) {
                String font = stringArray[n2];
                this.fontNameModel.addElement(font);
                ++n2;
            }
        }
        return this.fontNameModel;
    }

    private DefaultListModel getFontSizeModel() {
        if (this.fontSizeModel == null) {
            this.fontSizeModel = new DefaultListModel();
            int i = 8;
            while (i <= 30) {
                this.fontSizeModel.addElement(i);
                ++i;
            }
        }
        return this.fontSizeModel;
    }

    private JTextPane getSampleText() {
        if (this.sampleText == null) {
            this.sampleText = new JTextPane();
            this.sampleText.setEditorKit(this.getEditorKit());
            this.sampleText.setDocument(this.getDocument());
            this.sampleText.setBackground(SystemColor.control);
            StyleSheet css = this.document.getStyleSheet();
            css.addRule("body{font-size : 12pt ; font-family : \"\uff2d\uff33 \u30b4\u30b7\u30c3\u30af\",\"\uff2d\uff33 \u30b4\u30b7\u30c3\u30af\",Osaka,sans-serif;}");
            Element body = this.document.getDefaultRootElement().getElement(0);
            try {
                this.document.insertBeforeEnd(body, "<div>ABC abc 123 \u3042\u3044\u3046\u3048\u304a \u30a2\u30a4\u30a6\u30a8\u30aa</div>");
                Element p = body.getElement(0);
                this.document.remove(p.getStartOffset(), p.getEndOffset() - p.getStartOffset());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.sampleText;
    }

    private HTMLDocument getDocument() {
        if (this.document == null) {
            this.document = (HTMLDocument)this.getEditorKit().createDefaultDocument();
        }
        return this.document;
    }

    private HTMLEditorKit getEditorKit() {
        if (this.editorKit == null) {
            this.editorKit = new HTMLEditorKit();
        }
        return this.editorKit;
    }

    private JScrollPane getScroll4Pane() {
        if (this.scroll4Pane == null) {
            this.scroll4Pane = new JScrollPane();
            this.scroll4Pane.setViewportView(this.getSampleText());
        }
        return this.scroll4Pane;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public String getSelectedFontName() {
        return this.getFontNameList().getSelectedValue() != null ? this.getFontNameList().getSelectedValue().toString() : null;
    }

    public int getSelectedFontSize() {
        return this.getFontSizeList().getSelectedValue() != null ? (Integer)this.getFontSizeList().getSelectedValue() : null;
    }
}

