/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.chaplet.core.ui;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jp.sf.chaplet.core.ui.IPrefView;

public class SinglePrefDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JLabel titleLabel = null;
    private JPanel editPanel = null;
    private JPanel buttonPanel = null;
    private JButton okButton = null;
    private JButton cancelButton = null;
    private JLabel errorLabel = null;
    private IPrefView prefView = null;

    public SinglePrefDialog(Frame owner) {
        super(owner);
        this.initialize();
    }

    private void initialize() {
        this.setSize(519, 423);
        this.setTitle("\u8a2d\u5b9a");
        this.setContentPane(this.getJContentPane());
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.titleLabel = new JLabel();
            this.titleLabel.setText(" ");
            this.titleLabel.setBorder(BorderFactory.createLineBorder(Color.gray, 5));
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.titleLabel, "North");
            this.jContentPane.add((Component)this.getEditPanel(), "Center");
            this.jContentPane.add((Component)this.getButtonPanel(), "South");
        }
        return this.jContentPane;
    }

    private JPanel getEditPanel() {
        if (this.editPanel == null) {
            this.editPanel = new JPanel();
            this.editPanel.setLayout(new CardLayout());
        }
        return this.editPanel;
    }

    private JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 2;
            gridBagConstraints2.insets = new Insets(5, 3, 5, 5);
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.weightx = 0.0;
            gridBagConstraints2.gridy = 0;
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridx = 1;
            gridBagConstraints1.insets = new Insets(5, 3, 5, 2);
            gridBagConstraints1.weightx = 0.0;
            gridBagConstraints1.fill = 2;
            gridBagConstraints1.gridy = 0;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 10.0;
            gridBagConstraints.insets = new Insets(10, 5, 10, 2);
            gridBagConstraints.gridy = 0;
            this.errorLabel = new JLabel();
            this.errorLabel.setText("");
            this.buttonPanel = new JPanel();
            this.buttonPanel.setLayout(new GridBagLayout());
            this.buttonPanel.add((Component)this.getOkButton(), gridBagConstraints1);
            this.buttonPanel.add((Component)this.getCancelButton(), gridBagConstraints2);
            this.buttonPanel.add((Component)this.errorLabel, gridBagConstraints);
        }
        return this.buttonPanel;
    }

    private JButton getOkButton() {
        if (this.okButton == null) {
            this.okButton = new JButton();
            this.okButton.setText("   OK   ");
            this.okButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    String error = SinglePrefDialog.this.prefView.checkError();
                    if (error != null) {
                        SinglePrefDialog.this.errorLabel.setText(error);
                        return;
                    }
                    SinglePrefDialog.this.prefView.save();
                    SinglePrefDialog.this.dispose();
                }
            });
        }
        return this.okButton;
    }

    private JButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton();
            this.cancelButton.setText("\u30ad\u30e3\u30f3\u30bb\u30eb");
            this.cancelButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    SinglePrefDialog.this.dispose();
                }
            });
        }
        return this.cancelButton;
    }

    public void setPrefView(IPrefView prefView) {
        this.prefView = prefView;
        this.titleLabel.setText(prefView.getTitle());
        this.getEditPanel().add((Component)((Object)prefView), prefView.getTitle());
    }
}

