/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj;

import charactermanaj.model.AppConfig;
import charactermanaj.ui.MainFrame;
import charactermanaj.ui.ProfileSelectorDialog;
import charactermanaj.util.ErrorMessageHelper;
import java.lang.reflect.Method;
import javax.swing.UIManager;

public class Main {
    private static Boolean isMacOSX;

    public static void main(String[] stringArray) {
        try {
            if (Main.isMacOSX()) {
                System.setProperty("apple.laf.useScreenMenuBar", "true");
                System.setProperty("com.apple.mrj.application.apple.menu.about.name", "CharacterManaJ");
            }
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            AppConfig appConfig = AppConfig.getInstance();
            appConfig.loadConfig();
            MainFrame mainFrame = ProfileSelectorDialog.openDefaultProfile();
            if (Main.isMacOSX()) {
                Class<?> clazz = Class.forName("charactermanaj.ui.MainFramePartialForMacOSX");
                Method method = clazz.getMethod("setupScreenMenu", MainFrame.class);
                method.invoke(null, mainFrame);
            }
            mainFrame.setVisible(true);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            ErrorMessageHelper.showErrorDialog(null, throwable);
            System.exit(1);
        }
    }

    public static boolean isMacOSX() {
        if (isMacOSX == null) {
            String string = System.getProperty("os.name").toLowerCase();
            isMacOSX = string.startsWith("mac os x");
        }
        return isMacOSX;
    }
}

