/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.clipboardSupport;

import charactermanaj.clipboardSupport.ImageSelection;
import java.awt.Color;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.image.BufferedImage;
import java.io.IOException;

public final class ClipboardUtil {
    private ClipboardUtil() {
    }

    public static void setImage(BufferedImage bufferedImage, Color color) {
        if (bufferedImage == null || color == null) {
            throw new IllegalArgumentException();
        }
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Clipboard clipboard = toolkit.getSystemClipboard();
        ImageSelection imageSelection = new ImageSelection(bufferedImage, color);
        clipboard.setContents(imageSelection, null);
    }

    public static boolean hasImage() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Clipboard clipboard = toolkit.getSystemClipboard();
        return clipboard.isDataFlavorAvailable(DataFlavor.imageFlavor) || clipboard.isDataFlavorAvailable(ImageSelection.bufferedImageDataFlavor);
    }

    public static BufferedImage getImage() throws IOException {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Clipboard clipboard = toolkit.getSystemClipboard();
        try {
            if (clipboard.isDataFlavorAvailable(ImageSelection.bufferedImageDataFlavor)) {
                return (BufferedImage)clipboard.getData(ImageSelection.bufferedImageDataFlavor);
            }
            if (clipboard.isDataFlavorAvailable(DataFlavor.imageFlavor)) {
                return (BufferedImage)clipboard.getData(DataFlavor.imageFlavor);
            }
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            throw new IOException(unsupportedFlavorException.getMessage());
        }
        return null;
    }
}

