/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.clipboardSupport;

import charactermanaj.graphics.io.ImageSaveHelper;
import java.awt.Color;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.image.BufferedImage;
import java.io.IOException;

public class ImageSelection
implements Transferable {
    private BufferedImage img;
    private Color bgColor;
    public static final DataFlavor bufferedImageDataFlavor = new DataFlavor(BufferedImage.class, null);

    public ImageSelection(BufferedImage bufferedImage, Color color) {
        if (bufferedImage == null) {
            throw new IllegalArgumentException();
        }
        this.img = bufferedImage;
        this.bgColor = color == null ? Color.white : color;
    }

    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
        if (dataFlavor != null && dataFlavor.equals(DataFlavor.imageFlavor)) {
            ImageSaveHelper imageSaveHelper = new ImageSaveHelper();
            return imageSaveHelper.createJpegFormatPicture(this.img, this.bgColor);
        }
        if (dataFlavor != null && dataFlavor.equals(bufferedImageDataFlavor)) {
            return this.img;
        }
        throw new UnsupportedFlavorException(dataFlavor);
    }

    public DataFlavor[] getTransferDataFlavors() {
        return new DataFlavor[]{DataFlavor.imageFlavor, bufferedImageDataFlavor};
    }

    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        return dataFlavor != null && (dataFlavor.equals(DataFlavor.imageFlavor) || dataFlavor.equals(bufferedImageDataFlavor));
    }
}

