/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.graphics.io;

import charactermanaj.graphics.io.ImageResource;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;

public class FileImageResource
implements ImageResource {
    private File file;

    public FileImageResource(File file) {
        if (file == null) {
            throw new IllegalArgumentException();
        }
        this.file = file;
    }

    public long lastModified() {
        return this.file.lastModified();
    }

    public InputStream openStream() throws IOException {
        return new BufferedInputStream(new FileInputStream(this.file));
    }

    public int hashCode() {
        return this.file.hashCode();
    }

    public int compareTo(ImageResource imageResource) {
        return this.getFullName().compareTo(imageResource.getFullName());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object != null && object instanceof FileImageResource) {
            FileImageResource fileImageResource = (FileImageResource)object;
            return this.file.equals(fileImageResource.file);
        }
        return false;
    }

    public String getFullName() {
        return this.file.getPath();
    }

    public URL getURL() {
        try {
            return this.file.toURL();
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }
}

