/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.graphics.io;

import charactermanaj.graphics.io.PNGFileImageHeader;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;

public class PNGFileImageHeaderReader {
    public static final byte[] FILE_HEADER = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PNGFileImageHeader readHeader(URL uRL) throws IOException {
        if (uRL == null) {
            throw new IllegalArgumentException();
        }
        InputStream inputStream = uRL.openStream();
        try {
            PNGFileImageHeader pNGFileImageHeader = this.readHeader(inputStream);
            return pNGFileImageHeader;
        }
        finally {
            inputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PNGFileImageHeader readHeader(File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException();
        }
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        try {
            PNGFileImageHeader pNGFileImageHeader = this.readHeader(bufferedInputStream);
            return pNGFileImageHeader;
        }
        finally {
            ((InputStream)bufferedInputStream).close();
        }
    }

    public PNGFileImageHeader readHeader(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            throw new IllegalArgumentException();
        }
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        try {
            byte[] byArray = new byte[FILE_HEADER.length];
            dataInputStream.readFully(byArray);
            if (!Arrays.equals(byArray, FILE_HEADER)) {
                return null;
            }
            PNGFileImageHeader pNGFileImageHeader = null;
            boolean bl = false;
            while (true) {
                int n = dataInputStream.readInt();
                byte[] byArray2 = new byte[4];
                dataInputStream.readFully(byArray2);
                if (Arrays.equals(byArray2, "IHDR".getBytes())) {
                    pNGFileImageHeader = new PNGFileImageHeader();
                    pNGFileImageHeader.setWidth(dataInputStream.readInt());
                    pNGFileImageHeader.setHeight(dataInputStream.readInt());
                    pNGFileImageHeader.setBitDepth(dataInputStream.readByte() & 0xFF);
                    pNGFileImageHeader.setColorType(dataInputStream.readByte() & 0xFF);
                    pNGFileImageHeader.setCompressionMethod(dataInputStream.readByte() & 0xFF);
                    pNGFileImageHeader.setFilterMethod(dataInputStream.readByte() & 0xFF);
                    pNGFileImageHeader.setInterlaceMethod(dataInputStream.readByte() & 0xFF);
                    int n2 = n - 13;
                    if (n2 < 0) {
                        throw new EOFException("IHDR too short");
                    }
                    dataInputStream.skipBytes(n2);
                } else if (Arrays.equals(byArray2, "tRNS".getBytes())) {
                    bl = n > 0;
                    dataInputStream.skipBytes(n);
                } else {
                    if (Arrays.equals(byArray2, "IEND".getBytes())) break;
                    dataInputStream.skipBytes(n);
                }
                dataInputStream.readInt();
            }
            if (pNGFileImageHeader != null) {
                pNGFileImageHeader.setTransparencyInformation(bl);
            }
            return pNGFileImageHeader;
        }
        catch (EOFException eOFException) {
            return null;
        }
    }
}

