/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.model;

import charactermanaj.model.AppConfig;
import charactermanaj.model.ColorGroup;
import charactermanaj.model.Layer;
import charactermanaj.model.OrderedMap;
import charactermanaj.model.PartsCategory;
import charactermanaj.model.PartsColorManager;
import charactermanaj.model.PartsIdentifier;
import charactermanaj.model.PartsSet;
import charactermanaj.model.PartsSpec;
import charactermanaj.model.PartsSpecResolver;
import charactermanaj.model.io.PartsDataLoader;
import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CharacterData
implements Serializable,
PartsSpecResolver {
    private static final long serialVersionUID = 7297945916407190540L;
    public static final Comparator<CharacterData> SORT_DISPLAYNAME = new Comparator<CharacterData>(){

        @Override
        public int compare(CharacterData characterData, CharacterData characterData2) {
            if (!characterData.isValid() || !characterData2.isValid()) {
                return characterData.isValid() == characterData2.isValid() ? 0 : (characterData.isValid() ? 1 : -1);
            }
            int n = characterData.getName().compareTo(characterData2.getName());
            if (n == 0) {
                n = characterData.getId().compareTo(characterData2.getId());
            }
            if (n == 0) {
                n = characterData.getDocBase().toString().compareTo(characterData2.getDocBase().toString());
            }
            return n;
        }
    };
    private URL docBase;
    private String id;
    private String rev;
    private String localizedName;
    private Dimension imageSize;
    private OrderedMap<String, PartsCategory> partsCategories = OrderedMap.emptyMap();
    private String author;
    private String description;
    private HashMap<String, PartsSet> presets = new HashMap();
    private String defaultPresetId;
    private OrderedMap<String, ColorGroup> colorGroups = OrderedMap.emptyMap();
    private transient PartsColorManager partsColorMrg = new PartsColorManager(this);
    private transient PartsDataLoader partsDataLoader;
    private Map<PartsCategory, Map<PartsIdentifier, PartsSpec>> images = new HashMap<PartsCategory, Map<PartsIdentifier, PartsSpec>>();

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    public CharacterData duplicateBasicInfo(boolean bl) {
        Object object;
        CharacterData characterData = new CharacterData();
        if (!bl) {
            characterData.setId(this.id);
            characterData.setRev(this.rev);
            characterData.setDocBase(this.docBase);
        } else {
            object = UUID.randomUUID().toString();
            characterData.setId("cd" + (String)object);
            characterData.setRev("rev" + (String)object);
            characterData.setDocBase(null);
        }
        characterData.setName(this.localizedName);
        characterData.setAuthor(this.author);
        characterData.setDescription(this.description);
        characterData.setImageSize(this.getImageSize());
        object = new ArrayList();
        ((ArrayList)object).addAll(this.getPartsCategories());
        characterData.setPartsCategories(((ArrayList)object).toArray(new PartsCategory[((ArrayList)object).size()]));
        ArrayList<ColorGroup> arrayList = new ArrayList<ColorGroup>();
        arrayList.addAll(this.getColorGroups());
        characterData.setColorGroups(arrayList);
        for (PartsSet partsSet : this.getPartsSets().values()) {
            characterData.addPartsSet(partsSet.clone());
        }
        characterData.setDefaultPresetId(this.defaultPresetId);
        return characterData;
    }

    public boolean isSameStructure(CharacterData characterData) {
        if (characterData == null) {
            throw new IllegalArgumentException();
        }
        if (this.id == null ? characterData.id != null : !this.id.equals(characterData.id)) {
            return false;
        }
        ArrayList<ColorGroup> arrayList = new ArrayList<ColorGroup>(this.getColorGroups());
        ArrayList<ColorGroup> arrayList2 = new ArrayList<ColorGroup>(characterData.getColorGroups());
        if (arrayList.size() != arrayList2.size()) {
            return false;
        }
        if (!arrayList.containsAll(arrayList2)) {
            return false;
        }
        ArrayList<PartsCategory> arrayList3 = new ArrayList<PartsCategory>(this.getPartsCategories());
        ArrayList<PartsCategory> arrayList4 = new ArrayList<PartsCategory>(characterData.getPartsCategories());
        Comparator<PartsCategory> comparator = new Comparator<PartsCategory>(){

            @Override
            public int compare(PartsCategory partsCategory, PartsCategory partsCategory2) {
                int n = partsCategory.getCategoryId().compareTo(partsCategory2.getCategoryId());
                if (n == 0) {
                    n = partsCategory.getOrder() - partsCategory2.getOrder();
                }
                return n;
            }
        };
        Collections.sort(arrayList3, comparator);
        Collections.sort(arrayList4, comparator);
        if (!arrayList3.equals(arrayList4)) {
            return false;
        }
        int n = arrayList3.size();
        for (int i = 0; i < n; ++i) {
            PartsCategory partsCategory = arrayList3.get(i);
            PartsCategory partsCategory2 = arrayList4.get(i);
            ArrayList<Layer> arrayList5 = new ArrayList<Layer>(partsCategory.getLayers());
            ArrayList<Layer> arrayList6 = new ArrayList<Layer>(partsCategory2.getLayers());
            Comparator<Layer> comparator2 = new Comparator<Layer>(){

                @Override
                public int compare(Layer layer, Layer layer2) {
                    int n = layer.getId().compareTo(layer2.getId());
                    if (n == 0) {
                        n = layer.getOrder() - layer2.getOrder();
                    }
                    return n;
                }
            };
            Collections.sort(arrayList5, comparator2);
            Collections.sort(arrayList6, comparator2);
            if (arrayList5.equals(arrayList6)) continue;
            return false;
        }
        return true;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.partsColorMrg = new PartsColorManager(this);
    }

    public void setAuthor(String string) {
        this.author = string;
    }

    public void setDescription(String string) {
        if (string != null) {
            string = string.replace("\r\n", "\n");
            string = string.replace("\r", "\n");
            string = string.replace("\n", System.getProperty("line.separator"));
        }
        this.description = string;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getDescription() {
        return this.description;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String string) {
        this.id = string;
    }

    public String getRev() {
        return this.rev;
    }

    public void setRev(String string) {
        this.rev = string;
    }

    public void setDocBase(URL uRL) {
        this.docBase = uRL;
    }

    public URL getDocBase() {
        return this.docBase;
    }

    public boolean isValid() {
        return this.id != null && this.id.length() > 0 && this.localizedName != null && this.localizedName.length() > 0 && this.docBase != null;
    }

    public boolean canWrite() {
        File file;
        File file2;
        if (this.docBase == null) {
            return true;
        }
        return this.docBase.getProtocol().equals("file") && (!(file2 = new File(this.docBase.getPath())).exists() ? (file = file2.getParentFile()).exists() && file.canWrite() && file.canRead() : file2.canWrite() && file2.canRead());
    }

    public boolean isDefaultProfile() {
        if (!this.isValid()) {
            return false;
        }
        AppConfig appConfig = AppConfig.getInstance();
        String string = appConfig.getDefaultProfileId();
        return string != null && string.equals(this.id);
    }

    public void setName(String string) {
        this.localizedName = string;
    }

    public String getName() {
        return this.localizedName;
    }

    public void setImageSize(Dimension dimension) {
        if (dimension != null) {
            dimension = (Dimension)dimension.clone();
        }
        this.imageSize = dimension;
    }

    @Override
    public Dimension getImageSize() {
        return this.imageSize != null ? (Dimension)this.imageSize.clone() : null;
    }

    public void setColorGroups(Collection<ColorGroup> collection) {
        if (collection == null) {
            throw new IllegalArgumentException();
        }
        ArrayList<ColorGroup> arrayList = new ArrayList<ColorGroup>();
        arrayList.add(ColorGroup.NA);
        Object object = collection.iterator();
        while (object.hasNext()) {
            ColorGroup colorGroup = object.next();
            if (!colorGroup.isEnabled()) continue;
            arrayList.add(colorGroup);
        }
        this.colorGroups = object = new OrderedMap<String, ColorGroup>(arrayList, new OrderedMap.KeyDetector<String, ColorGroup>(){

            @Override
            public String getKey(ColorGroup colorGroup) {
                return colorGroup.getId();
            }
        });
    }

    public ColorGroup getColorGroup(String string) {
        ColorGroup colorGroup = this.colorGroups.get(string);
        if (colorGroup != null) {
            return colorGroup;
        }
        return ColorGroup.NA;
    }

    public Collection<ColorGroup> getColorGroups() {
        return this.colorGroups.values();
    }

    @Override
    public PartsCategory getPartsCategory(String string) {
        if (this.partsCategories == null) {
            return null;
        }
        return this.partsCategories.get(string);
    }

    public void setPartsCategories(PartsCategory[] partsCategoryArray) {
        if (partsCategoryArray == null) {
            partsCategoryArray = new PartsCategory[]{};
        }
        this.partsCategories = new OrderedMap<String, PartsCategory>(Arrays.asList(partsCategoryArray), new OrderedMap.KeyDetector<String, PartsCategory>(){

            @Override
            public String getKey(PartsCategory partsCategory) {
                return partsCategory.getCategoryId();
            }
        });
    }

    @Override
    public List<PartsCategory> getPartsCategories() {
        return this.partsCategories.asList();
    }

    public void loadPartsData(PartsDataLoader partsDataLoader) {
        if (partsDataLoader == null) {
            throw new IllegalArgumentException();
        }
        this.partsDataLoader = partsDataLoader;
        this.reloadPartsData();
    }

    public boolean reloadPartsData() {
        if (this.partsDataLoader == null) {
            throw new IllegalStateException("partsDataLoader is not set.");
        }
        this.images.clear();
        for (PartsCategory partsCategory : this.partsCategories.asList()) {
            this.images.put(partsCategory, this.partsDataLoader.load(partsCategory));
        }
        return true;
    }

    @Override
    public PartsSpec getPartsSpec(PartsIdentifier partsIdentifier) {
        PartsSpec partsSpec;
        if (partsIdentifier == null) {
            throw new IllegalArgumentException();
        }
        PartsCategory partsCategory = partsIdentifier.getPartsCategory();
        Map<PartsIdentifier, PartsSpec> map = this.images.get(partsCategory);
        if (map != null && (partsSpec = map.get(partsIdentifier)) != null) {
            return partsSpec;
        }
        return null;
    }

    @Override
    public Map<PartsIdentifier, PartsSpec> getPartsSpecMap(PartsCategory partsCategory) {
        Map<PartsIdentifier, PartsSpec> map = this.images.get(partsCategory);
        if (map == null) {
            return Collections.emptyMap();
        }
        return map;
    }

    public PartsColorManager getPartsColorManager() {
        return this.partsColorMrg;
    }

    public boolean addPartsSet(PartsSet partsSet) {
        if (partsSet == null) {
            throw new IllegalArgumentException();
        }
        if (partsSet.getPartsSetId() == null || partsSet.getPartsSetId().length() == 0 || partsSet.getLocalizedName() == null || partsSet.getLocalizedName().length() == 0) {
            return false;
        }
        PartsSet partsSet2 = partsSet.createCompatible(this);
        if (partsSet2.isEmpty()) {
            return false;
        }
        this.presets.put(partsSet2.getPartsSetId(), partsSet2);
        return true;
    }

    public Map<String, PartsSet> getPartsSets() {
        return this.presets;
    }

    public void clearPresetParts(boolean bl) {
        if (!bl) {
            this.presets.clear();
            this.defaultPresetId = null;
        } else {
            Iterator<Map.Entry<String, PartsSet>> iterator = this.presets.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, PartsSet> entry = iterator.next();
                if (entry.getValue().isPresetParts()) continue;
                if (entry.getKey().equals(this.defaultPresetId)) {
                    this.defaultPresetId = null;
                }
                iterator.remove();
            }
        }
    }

    public String getDefaultPresetId() {
        return this.defaultPresetId;
    }

    public void setDefaultPresetId(String string) {
        this.defaultPresetId = string;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("character-id: " + this.id);
        stringBuilder.append("/rev:" + this.rev);
        stringBuilder.append("/name:" + this.localizedName);
        stringBuilder.append("/image-size:" + this.imageSize.width + "x" + this.imageSize.height);
        stringBuilder.append("/docBase:" + this.docBase);
        return stringBuilder.toString();
    }
}

