/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.model.io;

import charactermanaj.graphics.io.PNGFileImageHeader;
import charactermanaj.graphics.io.PNGFileImageHeaderReader;
import charactermanaj.model.CharacterData;
import charactermanaj.model.Layer;
import charactermanaj.model.PartsCategory;
import charactermanaj.model.PartsIdentifier;
import charactermanaj.model.PartsSet;
import charactermanaj.model.io.CharacterDataArchiveFile;
import charactermanaj.model.io.CharacterDataPersistent;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.imageio.ImageIO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCharacterDataArchiveFile
implements CharacterDataArchiveFile {
    protected File archiveFile;
    protected String rootPrefix = "";
    protected HashMap<String, FileContent> entries = new HashMap();

    protected AbstractCharacterDataArchiveFile(File file) {
        if (file == null) {
            throw new IllegalArgumentException();
        }
        this.archiveFile = file;
    }

    public File getArchiveFile() {
        return this.archiveFile;
    }

    protected void addEntry(FileContent fileContent) {
        if (fileContent == null) {
            throw new IllegalArgumentException();
        }
        this.entries.put(fileContent.getEntryName(), fileContent);
    }

    protected URL getContentURL(String string) throws IOException {
        return new URL("jar:file:" + this.archiveFile.toURL().getPath() + "!/" + string);
    }

    @Override
    public boolean hasContent(String string) {
        return this.entries.containsKey(string);
    }

    public FileContent getContent(String string) {
        return this.entries.get(string);
    }

    @Override
    public String getRootPrefix() {
        return this.rootPrefix;
    }

    protected void searchRootPrefix() {
        HashSet<String> hashSet = new HashSet<String>();
        for (String string : this.entries.keySet()) {
            int n = string.indexOf(47);
            if (n < 0) {
                this.rootPrefix = "";
                return;
            }
            if (n < 0) continue;
            String string2 = string.substring(0, n + 1);
            hashSet.add(string2);
        }
        if (hashSet.size() == 1) {
            this.rootPrefix = (String)hashSet.iterator().next();
            return;
        }
        this.rootPrefix = "";
    }

    public Map<String, FileContent> getFiles(String string) {
        if (string == null) {
            string = "";
        }
        if (string.length() > 0 && !string.endsWith("/")) {
            string = string + "/";
        }
        if (string.equals("/")) {
            string = "";
        }
        HashMap<String, FileContent> hashMap = new HashMap<String, FileContent>();
        int n = string.length();
        for (Map.Entry<String, FileContent> entry : this.entries.entrySet()) {
            String string2;
            int n2;
            String string3 = entry.getKey();
            FileContent fileContent = entry.getValue();
            if (!string3.startsWith(string) || (n2 = (string2 = string3.substring(n)).indexOf(47)) >= 0) continue;
            hashMap.put(string3, fileContent);
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CharacterData readCharacterData() throws IOException {
        CharacterData characterData;
        FileContent fileContent = this.entries.get(this.rootPrefix + "character.xml");
        if (fileContent == null) {
            return null;
        }
        URL uRL = this.getContentURL(this.rootPrefix + "character.xml");
        CharacterDataPersistent characterDataPersistent = CharacterDataPersistent.getInstance();
        InputStream inputStream = fileContent.openStream();
        try {
            characterData = characterDataPersistent.loadCharacterDataFromXML(inputStream, uRL, false);
        }
        finally {
            inputStream.close();
        }
        if (!characterData.isValid() || characterData.getPartsCategories().isEmpty()) {
            return null;
        }
        return characterData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CharacterData readCharacterINI() throws IOException {
        Object object;
        String string;
        Object object2;
        FileContent fileContent = this.entries.get(this.rootPrefix + "character.ini");
        if (fileContent == null) {
            return null;
        }
        URL uRL = this.getContentURL(this.rootPrefix + "character.ini");
        CharacterDataPersistent characterDataPersistent = CharacterDataPersistent.getInstance();
        CharacterData characterData = characterDataPersistent.createDefaultCharacterData();
        characterData.setDocBase(uRL);
        int n = 0;
        int n2 = 0;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        try {
            object2 = new BufferedReader(new InputStreamReader(fileContent.openStream(), "MS932"));
            try {
                Object object3;
                boolean n3 = false;
                while ((object3 = ((BufferedReader)object2).readLine()) != null) {
                    int entry;
                    if (((String)(object3 = ((String)object3).trim())).length() == 0) continue;
                    if (((String)object3).startsWith("[")) {
                        if (((String)object3).toLowerCase().equals("[size]")) {
                            entry = 1;
                            continue;
                        }
                        if (((String)object3).toLowerCase().equals("[parts]")) {
                            entry = 2;
                            continue;
                        }
                        entry = 0;
                        continue;
                    }
                    int string2 = ((String)object3).indexOf(61);
                    if (string2 >= 0) {
                        string = ((String)object3).substring(0, string2).toLowerCase().trim();
                        object = ((String)object3).substring(string2 + 1);
                    } else {
                        string = ((String)object3).toLowerCase().trim();
                        object = "";
                    }
                    if (entry == 1) {
                        try {
                            if (string.equals("size_x")) {
                                n = Integer.parseInt((String)object);
                                continue;
                            }
                            if (!string.equals("size_y")) continue;
                            n2 = Integer.parseInt((String)object);
                        }
                        catch (RuntimeException partsIdentifier) {
                            System.err.println(partsIdentifier);
                        }
                        continue;
                    }
                    if (entry != 2 || string.length() <= 0) continue;
                    hashMap.put(string, (String)object);
                }
            }
            finally {
                ((BufferedReader)object2).close();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        if (n > 0 && n2 > 0) {
            characterData.setImageSize(new Dimension(n, n2));
        }
        if (!hashMap.isEmpty()) {
            object2 = new PartsSet("default", "default", true);
            for (Map.Entry entry : hashMap.entrySet()) {
                String string2 = (String)entry.getKey();
                string = (String)entry.getValue();
                object = characterData.getPartsCategory(string2);
                if (object == null) continue;
                PartsIdentifier partsIdentifier = string == null || string.length() == 0 ? null : new PartsIdentifier((PartsCategory)object, string, string);
                ((PartsSet)object2).appendParts((PartsCategory)object, partsIdentifier, null);
            }
            if (!((AbstractMap)object2).isEmpty()) {
                characterData.addPartsSet((PartsSet)object2);
                characterData.setDefaultPresetId("default");
            }
        }
        return characterData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BufferedImage readSamplePicture() throws IOException {
        Map<String, FileContent> map;
        FileContent fileContent = this.entries.get(this.rootPrefix + "preview.png");
        if (fileContent == null) {
            map = this.getFiles(this.rootPrefix);
            fileContent = map.get("preview.jpg");
            if (fileContent == null) {
                fileContent = (FileContent)map.get("preview.jpeg");
            }
            if (fileContent == null) {
                for (Map.Entry entry : map.entrySet()) {
                    String string = (String)entry.getKey();
                    if (!string.endsWith(".jpg") && !string.endsWith(".jpeg") && !string.endsWith(".png")) continue;
                    fileContent = (FileContent)entry.getValue();
                    break;
                }
            }
        }
        if (fileContent == null) {
            return null;
        }
        InputStream inputStream = fileContent.openStream();
        try {
            map = ImageIO.read(inputStream);
        }
        finally {
            inputStream.close();
        }
        return map;
    }

    @Override
    public String readReadMe() throws IOException {
        Locale locale = Locale.getDefault();
        String string = locale.getLanguage();
        ArrayList<FileContent> arrayList = new ArrayList<FileContent>();
        Map<String, FileContent> map = this.getFiles(this.rootPrefix);
        block2: for (String string2 : new String[]{"readme_" + string + ".txt", "readme_" + string, "readme.txt", "readme", null}) {
            for (Map.Entry<String, FileContent> entry : map.entrySet()) {
                String string3 = entry.getKey().toLowerCase();
                if (string2 == null && string3.endsWith(".txt")) {
                    arrayList.add(entry.getValue());
                    continue block2;
                }
                if (!string3.equals(string2)) continue;
                arrayList.add(entry.getValue());
            }
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        for (FileContent fileContent : arrayList) {
            try {
                return this.readTextUTF16(fileContent);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return null;
    }

    @Override
    public String readTextFile(String string) throws IOException {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        FileContent fileContent = this.entries.get(string);
        if (fileContent == null) {
            return null;
        }
        return this.readTextUTF16(fileContent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readTextUTF16(FileContent fileContent) throws IOException {
        if (fileContent == null) {
            throw new IllegalArgumentException();
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        InputStream inputStream = fileContent.openStream();
        try {
            int n;
            while ((n = inputStream.read()) != -1) {
                byteArrayOutputStream.write((byte)n);
            }
        }
        finally {
            inputStream.close();
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        String string = null;
        if (byArray.length >= 2) {
            if ((byArray[0] & 0xFF) == 255 && (byArray[1] & 0xFF) == 254) {
                string = "UTF-16LE";
            } else if ((byArray[0] & 0xFF) == 254 && (byArray[1] & 0xFF) == 255) {
                string = "UTF-16BE";
            }
        }
        if (string == null && byArray.length >= 3 && (byArray[0] & 0xFF) == 239 && (byArray[1] & 0xFF) == 187 && (byArray[1] & 0xFF) == 191) {
            string = "UTF-8";
        }
        if (string == null) {
            string = "JISAutoDetect";
        }
        StringBuilder stringBuilder = new StringBuilder();
        InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new ByteArrayInputStream(byArray), string);
        try {
            int n;
            while ((n = inputStreamReader.read()) != -1) {
                stringBuilder.append((char)n);
            }
        }
        finally {
            inputStreamReader.close();
        }
        String string2 = stringBuilder.toString();
        string2 = string2.replace("\r\n", "\n");
        string2 = string2.replace("\r", "\n");
        string2 = string2.replace("\n", System.getProperty("line.separator"));
        return string2;
    }

    protected Map<String, Collection<CategoryLayerPair>> getLayerDirs(CharacterData characterData) {
        if (characterData == null) {
            throw new IllegalArgumentException();
        }
        String string = this.getRootPrefix();
        HashMap<String, Collection<CategoryLayerPair>> hashMap = new HashMap<String, Collection<CategoryLayerPair>>();
        for (PartsCategory partsCategory : characterData.getPartsCategories()) {
            for (Layer layer : partsCategory.getLayers()) {
                Collection<CategoryLayerPair> collection;
                String string2 = layer.getDir();
                if (!string2.endsWith("/")) {
                    string2 = string2 + "/";
                }
                if ((collection = hashMap.get(string2 = string + string2)) == null) {
                    collection = new ArrayList<CategoryLayerPair>();
                    hashMap.put(string2, collection);
                }
                collection.add(new CategoryLayerPair(partsCategory, layer));
            }
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<PartsImageContent> getPartsImageContents(CharacterData characterData) {
        if (characterData == null) {
            return Collections.emptyList();
        }
        Map<String, Collection<CategoryLayerPair>> map = this.getLayerDirs(characterData);
        PNGFileImageHeaderReader pNGFileImageHeaderReader = new PNGFileImageHeaderReader();
        ArrayList<PartsImageContent> arrayList = new ArrayList<PartsImageContent>();
        for (Map.Entry<String, FileContent> entry : this.entries.entrySet()) {
            Object object;
            String string;
            Collection<CategoryLayerPair> collection;
            String string2;
            String string3 = entry.getKey();
            FileContent fileContent = entry.getValue();
            String[] stringArray = string3.split("/");
            if (stringArray.length < 2 || !(string2 = stringArray[stringArray.length - 1]).toLowerCase().endsWith(".png") || (collection = map.get(string = string3.substring(0, string3.length() - string2.length()))) == null || collection.isEmpty()) continue;
            PNGFileImageHeader pNGFileImageHeader = null;
            try {
                object = fileContent.openStream();
                try {
                    pNGFileImageHeader = pNGFileImageHeaderReader.readHeader((InputStream)object);
                }
                finally {
                    ((InputStream)object).close();
                }
            }
            catch (IOException iOException) {
                System.err.println(iOException);
                pNGFileImageHeader = null;
            }
            if (pNGFileImageHeader == null) {
                System.err.println("invalid png: " + string3);
                continue;
            }
            int n = string2.lastIndexOf(46);
            object = string2.substring(0, n);
            PartsImageContent partsImageContent = new PartsImageContent(fileContent, collection, string2, (String)object, pNGFileImageHeader);
            arrayList.add(partsImageContent);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Properties readExportProp() throws IOException {
        FileContent fileContent = this.entries.get(this.rootPrefix + "export-info.xml");
        if (fileContent == null) {
            return null;
        }
        Properties properties = new Properties();
        InputStream inputStream = fileContent.openStream();
        try {
            properties.loadFromXML(inputStream);
        }
        finally {
            inputStream.close();
        }
        return properties;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class PartsImageContent
    implements FileContent {
        private final FileContent fileContent;
        private final Collection<CategoryLayerPair> categoryLayerPairs;
        private final String dirName;
        private final String partsName;
        private final String fileName;
        private final PNGFileImageHeader pngFileImageHeader;

        protected PartsImageContent(FileContent fileContent, Collection<CategoryLayerPair> collection, String string, String string2, PNGFileImageHeader pNGFileImageHeader) {
            if (fileContent == null || collection == null || collection.isEmpty() || string == null || string2 == null || pNGFileImageHeader == null) {
                throw new IllegalArgumentException();
            }
            this.fileContent = fileContent;
            this.categoryLayerPairs = Collections.unmodifiableCollection(collection);
            this.fileName = string;
            this.partsName = string2;
            this.pngFileImageHeader = pNGFileImageHeader;
            CategoryLayerPair categoryLayerPair = collection.iterator().next();
            this.dirName = categoryLayerPair.getLayer().getDir();
        }

        public int hashCode() {
            return this.getEntryName().hashCode();
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object != null && object instanceof PartsImageContent) {
                return this.getEntryName().equals(((PartsImageContent)object).getEntryName());
            }
            return false;
        }

        public Collection<CategoryLayerPair> getCategoryLayerPairs() {
            return this.categoryLayerPairs;
        }

        public String getDirName() {
            return this.dirName;
        }

        @Override
        public String getEntryName() {
            return this.fileContent.getEntryName();
        }

        public String getFileName() {
            return this.fileName;
        }

        public String getPartsName() {
            return this.partsName;
        }

        public PNGFileImageHeader getPngFileImageHeader() {
            return this.pngFileImageHeader;
        }

        @Override
        public long lastModified() {
            return this.fileContent.lastModified();
        }

        @Override
        public InputStream openStream() throws IOException {
            return this.fileContent.openStream();
        }

        public String toString() {
            return this.fileContent.getEntryName();
        }
    }

    public static final class CategoryLayerPair {
        private PartsCategory partsCategory;
        private Layer layer;

        public CategoryLayerPair(PartsCategory partsCategory, Layer layer) {
            if (partsCategory == null || layer == null) {
                throw new IllegalArgumentException();
            }
            this.partsCategory = partsCategory;
            this.layer = layer;
        }

        public int hashCode() {
            return this.partsCategory.hashCode() ^ this.layer.hashCode();
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object != null && object instanceof CategoryLayerPair) {
                CategoryLayerPair categoryLayerPair = (CategoryLayerPair)object;
                return this.partsCategory.equals(categoryLayerPair.partsCategory) && this.layer.equals(categoryLayerPair.layer);
            }
            return false;
        }

        public Layer getLayer() {
            return this.layer;
        }

        public PartsCategory getPartsCategory() {
            return this.partsCategory;
        }

        public String toString() {
            return "(" + this.partsCategory + ":" + this.layer + ")";
        }
    }

    public static interface FileContent {
        public String getEntryName();

        public long lastModified();

        public InputStream openStream() throws IOException;
    }
}

