/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.model.io;

import charactermanaj.model.io.AbstractCharacterDataArchiveFile;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class CharacterDataJarArchiveFile
extends AbstractCharacterDataArchiveFile {
    protected JarFile jarFile;

    public void close() throws IOException {
        this.jarFile.close();
    }

    public CharacterDataJarArchiveFile(File file) throws IOException {
        super(file);
        this.jarFile = new JarFile(file);
        this.load();
    }

    private void load() {
        Enumeration<JarEntry> enumeration = this.jarFile.entries();
        while (enumeration.hasMoreElements()) {
            JarEntry jarEntry = enumeration.nextElement();
            this.addEntry(new JarFileContent(jarEntry));
        }
        this.searchRootPrefix();
    }

    protected class JarFileContent
    implements AbstractCharacterDataArchiveFile.FileContent {
        private JarEntry entry;

        protected JarFileContent(JarEntry jarEntry) {
            this.entry = jarEntry;
        }

        public String getEntryName() {
            return this.entry.getName();
        }

        public long lastModified() {
            return this.entry.getTime();
        }

        public InputStream openStream() throws IOException {
            return CharacterDataJarArchiveFile.this.jarFile.getInputStream(this.entry);
        }
    }
}

