/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.model.io;

import charactermanaj.model.CharacterData;
import charactermanaj.model.RecentData;
import charactermanaj.model.io.CharacterDataPersistent;
import charactermanaj.util.UserData;
import charactermanaj.util.UserDataFactory;
import java.io.IOException;

public final class RecentDataPersistent {
    private static final RecentDataPersistent inst = new RecentDataPersistent();
    private static final String RECENT_CHARACTER_SER = "recent-character.ser";

    private RecentDataPersistent() {
    }

    public static RecentDataPersistent getInstance() {
        return inst;
    }

    public void saveRecent(CharacterData characterData) throws IOException {
        if (characterData == null) {
            throw new IllegalArgumentException();
        }
        if (!characterData.isValid()) {
            return;
        }
        RecentData recentData = new RecentData();
        recentData.setAppVersion("1.0");
        recentData.setDocBase(characterData.getDocBase());
        UserData userData = this.getRecentCharacterStore();
        userData.save(recentData);
    }

    public CharacterData loadRecent() throws IOException {
        RecentData recentData;
        UserData userData = this.getRecentCharacterStore();
        if (!userData.exists()) {
            return null;
        }
        try {
            recentData = (RecentData)userData.load();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        CharacterDataPersistent characterDataPersistent = CharacterDataPersistent.getInstance();
        return characterDataPersistent.loadProfile(recentData.getDocBase());
    }

    protected UserData getRecentCharacterStore() {
        UserDataFactory userDataFactory = UserDataFactory.getInstance();
        UserData userData = userDataFactory.getUserData(RECENT_CHARACTER_SER);
        return userData;
    }
}

