/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.ui;

import charactermanaj.ui.CategoriesTableRow;
import charactermanaj.ui.LayersTableRow;
import charactermanaj.ui.model.AbstractTableModelWithComboBoxModel;
import charactermanaj.util.LocalizedResourcePropertyLoader;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import javax.swing.table.TableColumnModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CategoriesTableModel
extends AbstractTableModelWithComboBoxModel<CategoriesTableRow> {
    private static final long serialVersionUID = 1L;
    private static final String[] categoriesColumnName;
    private static final int[] categoriesColumnWidths;
    private int serialCounter = 1;
    private UsedCategoryDetector usedCategoryDetector;

    public void adjustColumnModel(TableColumnModel tableColumnModel) {
        for (int i = 0; i < categoriesColumnWidths.length; ++i) {
            tableColumnModel.getColumn(i).setPreferredWidth(categoriesColumnWidths[i]);
        }
    }

    public void setUsedCategoryDetector(UsedCategoryDetector usedCategoryDetector) {
        this.usedCategoryDetector = usedCategoryDetector;
    }

    public UsedCategoryDetector getUsedCategoryDetector() {
        return this.usedCategoryDetector;
    }

    public void addCategory() {
        String string = "cat" + UUID.randomUUID().toString();
        String string2 = "Category" + this.serialCounter++;
        CategoriesTableRow categoriesTableRow = new CategoriesTableRow(this.serialCounter, string, string2, false, 10, null);
        this.addRow(categoriesTableRow);
    }

    public void reorder() {
        int n = this.elements.size();
        for (int i = 0; i < n; ++i) {
            CategoriesTableRow categoriesTableRow = (CategoriesTableRow)this.elements.get(i);
            categoriesTableRow.setOrder(i + 1);
        }
        this.fireTableDataChanged();
    }

    @Override
    public int moveDown(int n) {
        int n2 = super.moveDown(n);
        this.reorder();
        return n2;
    }

    @Override
    public int moveUp(int n) {
        int n2 = super.moveUp(n);
        this.reorder();
        return n2;
    }

    @Override
    public String getColumnName(int n) {
        return categoriesColumnName[n];
    }

    @Override
    public int getColumnCount() {
        return categoriesColumnName.length;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        CategoriesTableRow categoriesTableRow = (CategoriesTableRow)this.elements.get(n);
        switch (n2) {
            case 0: {
                return categoriesTableRow.getLocalizedCategoryName();
            }
            case 1: {
                return categoriesTableRow.isMultipleSelectable();
            }
            case 2: {
                return categoriesTableRow.getVisibleRows();
            }
            case 3: {
                StringBuilder stringBuilder = new StringBuilder();
                List<LayersTableRow> list = null;
                if (this.usedCategoryDetector != null) {
                    list = this.usedCategoryDetector.getLayers(categoriesTableRow);
                }
                if (list != null) {
                    for (LayersTableRow layersTableRow : list) {
                        if (stringBuilder.length() > 0) {
                            stringBuilder.append(", ");
                        }
                        stringBuilder.append(layersTableRow.getLayerName());
                    }
                }
                return stringBuilder.toString();
            }
        }
        return "***";
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        CategoriesTableRow categoriesTableRow = (CategoriesTableRow)this.elements.get(n);
        try {
            switch (n2) {
                case 0: {
                    categoriesTableRow.setLocalizedCategoryName((String)object);
                    break;
                }
                case 1: {
                    categoriesTableRow.setMultipleSelectable((Boolean)object);
                    break;
                }
                case 2: {
                    categoriesTableRow.setVisibleRows(((Number)object).intValue());
                    break;
                }
                default: {
                    return;
                }
            }
            this.fireTableCellUpdated(n, n2);
        }
        catch (RuntimeException runtimeException) {
            System.err.println(runtimeException);
        }
    }

    @Override
    public Class<?> getColumnClass(int n) {
        if (n == 1) {
            return Boolean.class;
        }
        if (n == 2) {
            return Integer.class;
        }
        return String.class;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        if (n2 >= categoriesColumnName.length - 1) {
            return false;
        }
        return this.isEditable();
    }

    static {
        Properties properties = LocalizedResourcePropertyLoader.getInstance().getLocalizedProperties("strings/profileditdialog");
        categoriesColumnName = new String[]{properties.getProperty("categories.column.categoryname"), properties.getProperty("categories.column.multipleselectable"), properties.getProperty("categories.column.displayrowcount"), properties.getProperty("categories.column.usedlayers")};
        categoriesColumnWidths = new int[]{Integer.parseInt(properties.getProperty("categories.column.categoryname.width")), Integer.parseInt(properties.getProperty("categories.column.multipleselectable.width")), Integer.parseInt(properties.getProperty("categories.column.displayrowcount.width")), Integer.parseInt(properties.getProperty("categories.column.usedlayers.width"))};
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface UsedCategoryDetector {
        public List<LayersTableRow> getLayers(CategoriesTableRow var1);
    }
}

