/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.ui;

import charactermanaj.model.AppConfig;
import charactermanaj.model.PartsCategory;
import charactermanaj.model.PartsIdentifier;
import charactermanaj.model.PartsSet;
import charactermanaj.model.PartsSpec;
import charactermanaj.model.PartsSpecResolver;
import charactermanaj.ui.AbstractImportPanel;
import charactermanaj.ui.ExportPartsResolver;
import charactermanaj.ui.ExportPartsSelectModel;
import charactermanaj.ui.ExportPartsTableModel;
import charactermanaj.util.LocalizedResourcePropertyLoader;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ExportPartsSelectPanel
extends AbstractImportPanel
implements ExportPartsResolver {
    private static final long serialVersionUID = 1L;
    private ExportPartsTableModel partsTableModel;
    private JTable partsTable;
    private Action actSelectAll;
    private Action actDeselectAll;
    private Action actSort;
    private Action actSortByTimestamp;

    protected ExportPartsSelectPanel(PartsSpecResolver partsSpecResolver) {
        if (partsSpecResolver == null) {
            throw new IllegalArgumentException();
        }
        Properties properties = LocalizedResourcePropertyLoader.getInstance().getLocalizedProperties("strings/exportwizdialog");
        this.setName("choosePartsPanel");
        this.setBorder(BorderFactory.createTitledBorder(properties.getProperty("parts.title")));
        this.setLayout(new BorderLayout());
        this.partsTableModel = new ExportPartsTableModel();
        this.partsTableModel.addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent tableModelEvent) {
                ExportPartsSelectPanel.this.fireChangeEvent();
            }
        });
        this.loadPartsInfo(partsSpecResolver);
        AppConfig appConfig = AppConfig.getInstance();
        final Color color = appConfig.getDisabledCellForgroundColor();
        this.partsTable = new JTable(this.partsTableModel){
            private static final long serialVersionUID = 1L;

            public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n, int n2) {
                Component component = super.prepareRenderer(tableCellRenderer, n, n2);
                if (component instanceof JCheckBox) {
                    component.setEnabled(this.isCellEditable(n, n2) && this.isEnabled());
                }
                component.setForeground(this.isEnabled() ? this.getForeground() : color);
                return component;
            }
        };
        this.partsTable.setAutoResizeMode(0);
        this.partsTableModel.adjustColumnModel(this.partsTable.getColumnModel());
        this.add((Component)new JScrollPane(this.partsTable), "Center");
        this.actSelectAll = new AbstractAction(properties.getProperty("parts.btn.selectAll")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                ExportPartsSelectPanel.this.onSelectAll();
            }
        };
        this.actDeselectAll = new AbstractAction(properties.getProperty("parts.btn.deselectAll")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                ExportPartsSelectPanel.this.onDeselectAll();
            }
        };
        this.actSort = new AbstractAction(properties.getProperty("parts.btn.sort")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                ExportPartsSelectPanel.this.onSort();
            }
        };
        this.actSortByTimestamp = new AbstractAction(properties.getProperty("parts.btn.sortByTimestamp")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                ExportPartsSelectPanel.this.onSortByTimestamp();
            }
        };
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        JButton jButton = new JButton(this.actSelectAll);
        jPanel.add((Component)jButton, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        JButton jButton2 = new JButton(this.actDeselectAll);
        jPanel.add((Component)jButton2, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        JButton jButton3 = new JButton(this.actSort);
        jPanel.add((Component)jButton3, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        JButton jButton4 = new JButton(this.actSortByTimestamp);
        jPanel.add((Component)jButton4, gridBagConstraints);
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        jPanel.add(Box.createHorizontalGlue(), gridBagConstraints);
        this.add((Component)jPanel, "South");
    }

    protected void loadPartsInfo(PartsSpecResolver partsSpecResolver) {
        this.partsTableModel.clear();
        for (PartsCategory partsCategory : partsSpecResolver.getPartsCategories()) {
            Map<PartsIdentifier, PartsSpec> map = partsSpecResolver.getPartsSpecMap(partsCategory);
            for (Map.Entry<PartsIdentifier, PartsSpec> entry : map.entrySet()) {
                PartsIdentifier partsIdentifier = entry.getKey();
                PartsSpec partsSpec = entry.getValue();
                ExportPartsSelectModel exportPartsSelectModel = new ExportPartsSelectModel(partsIdentifier, partsSpec, false);
                this.partsTableModel.addRow(exportPartsSelectModel);
            }
        }
        this.partsTableModel.sort();
    }

    protected void onSelectAll() {
        this.partsTableModel.selectAll();
    }

    protected void onDeselectAll() {
        this.partsTableModel.deselectAll();
    }

    protected void onSort() {
        this.partsTableModel.sort();
        if (this.partsTableModel.getRowCount() > 0) {
            Rectangle rectangle = this.partsTable.getCellRect(0, 0, true);
            this.partsTable.scrollRectToVisible(rectangle);
        }
    }

    protected void onSortByTimestamp() {
        this.partsTableModel.sortByTimestamp();
        if (this.partsTableModel.getRowCount() > 0) {
            Rectangle rectangle = this.partsTable.getCellRect(0, 0, true);
            this.partsTable.scrollRectToVisible(rectangle);
        }
    }

    @Override
    public Map<PartsIdentifier, PartsSpec> getSelectedParts() {
        return this.partsTableModel.getSelectedParts();
    }

    @Override
    public Map<PartsSet, List<PartsIdentifier>> checkMissingPartsList(Collection<PartsSet> collection) {
        return this.partsTableModel.checkMissingPartsList(collection);
    }

    @Override
    public void selectByPartsSet(Collection<PartsSet> collection) {
        this.partsTableModel.selectByPartsSet(collection);
    }

    @Override
    public int getSelectedCount() {
        return this.partsTableModel.getSelectedCount();
    }

    @Override
    public void setEnabled(boolean bl) {
        this.partsTable.setEnabled(bl);
        this.partsTableModel.setEnabled(bl);
        this.actSelectAll.setEnabled(bl);
        this.actDeselectAll.setEnabled(bl);
        super.setEnabled(bl);
    }
}

