/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.ui;

import charactermanaj.model.PartsIdentifier;
import charactermanaj.model.PartsSet;
import charactermanaj.ui.ExportPresetModel;
import charactermanaj.ui.model.AbstractTableModelWithComboBoxModel;
import charactermanaj.util.LocalizedResourcePropertyLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import javax.swing.table.TableColumnModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ExportPresetTableModel
extends AbstractTableModelWithComboBoxModel<ExportPresetModel> {
    private static final long serialVersionUID = 1L;
    private static final String[] columnNames;
    private static final int[] columnWidths;
    private boolean enabled = true;
    private String defaultPresetId;

    ExportPresetTableModel() {
    }

    public void adjustColumnModel(TableColumnModel tableColumnModel) {
        for (int i = 0; i < columnWidths.length; ++i) {
            tableColumnModel.getColumn(i).setPreferredWidth(columnWidths[i]);
        }
    }

    @Override
    public int getColumnCount() {
        return columnNames.length;
    }

    @Override
    public String getColumnName(int n) {
        return columnNames[n];
    }

    @Override
    public Object getValueAt(int n, int n2) {
        ExportPresetModel exportPresetModel = (ExportPresetModel)this.getRow(n);
        switch (n2) {
            case 0: {
                return exportPresetModel.isSelected() && this.isEnabled();
            }
            case 1: {
                return exportPresetModel.getPartsSet().getPartsSetId().equals(this.defaultPresetId) && this.isEnabled();
            }
            case 2: {
                return exportPresetModel.getPartsSetName();
            }
            case 3: {
                StringBuilder stringBuilder = new StringBuilder();
                for (PartsIdentifier partsIdentifier : exportPresetModel.getMissingPartsIdentifiers()) {
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append(partsIdentifier.getLocalizedPartsName());
                }
                return stringBuilder.toString();
            }
        }
        return "";
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        ExportPresetModel exportPresetModel = (ExportPresetModel)this.getRow(n);
        switch (n2) {
            case 0: {
                if (((Boolean)object).booleanValue()) {
                    exportPresetModel.setSelected(true);
                    break;
                }
                exportPresetModel.setSelected(false);
                if (!exportPresetModel.getPartsSet().getPartsSetId().equals(this.defaultPresetId)) break;
                this.defaultPresetId = null;
                this.fireTableRowsUpdated(n, n);
                return;
            }
            case 1: {
                if (((Boolean)object).booleanValue()) {
                    this.defaultPresetId = exportPresetModel.getPartsSet().getPartsSetId();
                    exportPresetModel.setSelected(true);
                    this.fireTableDataChanged();
                    return;
                }
            }
            default: {
                return;
            }
        }
        this.fireTableRowsUpdated(n, n);
    }

    @Override
    public Class<?> getColumnClass(int n) {
        switch (n) {
            case 0: {
                return Boolean.class;
            }
            case 1: {
                return Boolean.class;
            }
            case 2: {
                return String.class;
            }
            case 3: {
                return String.class;
            }
        }
        return String.class;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        if (n2 == 0 || n2 == 1) {
            return this.isEnabled();
        }
        return false;
    }

    public void sort() {
        Collections.sort(this.elements);
        this.fireTableDataChanged();
    }

    public void selectAll() {
        for (ExportPresetModel exportPresetModel : this.elements) {
            exportPresetModel.setSelected(true);
        }
        this.fireTableDataChanged();
    }

    public void deselectAll() {
        for (ExportPresetModel exportPresetModel : this.elements) {
            exportPresetModel.setSelected(false);
        }
        this.fireTableDataChanged();
    }

    public List<PartsSet> getSelectedPresets() {
        ArrayList<PartsSet> arrayList = new ArrayList<PartsSet>();
        for (ExportPresetModel exportPresetModel : this.elements) {
            if (!exportPresetModel.isSelected() || !this.isEnabled()) continue;
            PartsSet partsSet = exportPresetModel.getPartsSet().clone();
            partsSet.setPresetParts(true);
            arrayList.add(partsSet);
        }
        return arrayList;
    }

    public int getSelectedCount() {
        int n = 0;
        for (ExportPresetModel exportPresetModel : this.elements) {
            if (!exportPresetModel.isSelected() || !this.isEnabled()) continue;
            ++n;
        }
        return n;
    }

    public String getDefaultPresetId() {
        return this.defaultPresetId;
    }

    public void setDefaultPresetId(String string) {
        this.defaultPresetId = string;
    }

    public void setEnabled(boolean bl) {
        if (this.enabled != bl) {
            this.enabled = bl;
            this.fireTableDataChanged();
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    static {
        Properties properties = LocalizedResourcePropertyLoader.getInstance().getLocalizedProperties("strings/exportwizdialog");
        columnNames = new String[]{properties.getProperty("preset.column.selected"), properties.getProperty("preset.column.default"), properties.getProperty("preset.column.name"), properties.getProperty("preset.column.missingparts")};
        columnWidths = new int[]{Integer.parseInt(properties.getProperty("preset.column.selected.width")), Integer.parseInt(properties.getProperty("preset.column.default.width")), Integer.parseInt(properties.getProperty("preset.column.name.width")), Integer.parseInt(properties.getProperty("preset.column.missingparts.width"))};
    }
}

