/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.ui;

import charactermanaj.model.AppConfig;
import charactermanaj.model.PartsCategory;
import charactermanaj.model.PartsIdentifier;
import charactermanaj.model.PartsSpecResolver;
import charactermanaj.ui.PartsSelectListModel;
import charactermanaj.ui.PartsSelectRow;
import charactermanaj.util.LocalizedResourcePropertyLoader;
import charactermanaj.util.UIUtility;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.EventObject;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.DefaultListSelectionModel;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageSelectPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    protected static final String STRINGS_RESOURCE = "strings/imageselectpanel";
    private final int rowStep = 2;
    private final LinkedList<ImageSelectPanelListener> listeners = new LinkedList();
    private final int rowHeight;
    private final int minHeight;
    private PartsSpecResolver partsSpecResolver;
    private final JTable partsSelectTable;
    private final PartsSelectListModel partsSelectTableModel;
    private PartsIdentifier selectedPartsIdentifier;
    private List<PartsIdentifier> selectedPartsIdentifiers = Collections.emptyList();
    private final PartsCategory partsCategory;

    public ImageSelectPanel(PartsCategory partsCategory, PartsSpecResolver partsSpecResolver) {
        Serializable serializable;
        Serializable serializable2;
        JComponent jComponent;
        Object object;
        if (partsCategory == null || partsSpecResolver == null) {
            throw new IllegalArgumentException();
        }
        this.partsCategory = partsCategory;
        this.partsSpecResolver = partsSpecResolver;
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3), BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(3, 3, 3, 3))));
        this.partsSelectTableModel = new PartsSelectListModel(partsCategory);
        DefaultTableColumnModel defaultTableColumnModel = new DefaultTableColumnModel();
        defaultTableColumnModel.addColumn(new TableColumn(0, 32));
        defaultTableColumnModel.addColumn(new TableColumn(1, 100));
        DefaultListSelectionModel defaultListSelectionModel = new DefaultListSelectionModel();
        defaultListSelectionModel.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    ImageSelectPanel.this.onSelectChange(new ImageSelectPanelEvent(ImageSelectPanel.this));
                }
            }
        });
        AppConfig appConfig = AppConfig.getInstance();
        Properties properties = LocalizedResourcePropertyLoader.getInstance().getLocalizedProperties(STRINGS_RESOURCE);
        final Color color = appConfig.getCheckedItemBgColor();
        this.partsSelectTable = new JTable(this.partsSelectTableModel, defaultTableColumnModel, defaultListSelectionModel){
            private static final long serialVersionUID = 1L;

            public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n, int n2) {
                Component component = super.prepareRenderer(tableCellRenderer, n, n2);
                if (this.isCellSelected(n, n2) && this.hasFocus()) {
                    component.setBackground(this.getSelectionBackground());
                } else {
                    Boolean bl = (Boolean)this.getModel().getValueAt(n, 0);
                    component.setForeground(this.getForeground());
                    if (bl.booleanValue()) {
                        component.setBackground(color);
                    } else {
                        component.setBackground(this.getBackground());
                    }
                }
                return component;
            }

            public String getToolTipText(MouseEvent mouseEvent) {
                int n = this.rowAtPoint(mouseEvent.getPoint());
                int n2 = ImageSelectPanel.this.partsSelectTableModel.getRowCount();
                if (n >= 0 && n < n2) {
                    PartsSelectRow partsSelectRow = ImageSelectPanel.this.partsSelectTableModel.getRow(n);
                    return partsSelectRow.getPartsName();
                }
                return null;
            }
        };
        this.partsSelectTable.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                ImageSelectPanel.this.partsSelectTable.repaint();
            }

            public void focusLost(FocusEvent focusEvent) {
                ImageSelectPanel.this.partsSelectTable.repaint();
            }
        });
        this.partsSelectTableModel.addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent tableModelEvent) {
                if (tableModelEvent.getType() == 0) {
                    ImageSelectPanel.this.onChange(new ImageSelectPanelEvent(ImageSelectPanel.this));
                }
            }
        });
        this.partsSelectTable.setSelectionBackground(appConfig.getSelectedItemBgColor());
        if (partsCategory.isMultipleSelectable()) {
            this.partsSelectTable.setSelectionMode(2);
        } else {
            this.partsSelectTable.setSelectionMode(0);
        }
        this.partsSelectTable.setRowSelectionAllowed(true);
        this.partsSelectTable.setTableHeader(null);
        this.partsSelectTable.setShowVerticalLines(false);
        this.partsSelectTable.setShowHorizontalLines(false);
        InputMap inputMap = this.partsSelectTable.getInputMap();
        inputMap.put(KeyStroke.getKeyStroke(32, 0), "toggleCheck");
        inputMap.put(KeyStroke.getKeyStroke(127, 0), "resetCheck");
        ActionMap actionMap = this.partsSelectTable.getActionMap();
        actionMap.put("toggleCheck", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                int[] nArray = ImageSelectPanel.this.partsSelectTable.getSelectedRows();
                boolean[] blArray = ImageSelectPanel.this.partsSelectTableModel.getChecks(nArray);
                int n = 0;
                for (boolean bl : blArray) {
                    if (!bl) continue;
                    ++n;
                }
                if (blArray.length == n) {
                    ImageSelectPanel.this.partsSelectTableModel.setChecks(false, nArray);
                } else {
                    ImageSelectPanel.this.partsSelectTableModel.setChecks(true, nArray);
                }
            }
        });
        actionMap.put("resetCheck", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                ImageSelectPanel.this.partsSelectTableModel.setChecks(false, ImageSelectPanel.this.partsSelectTable.getSelectedRows());
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.partsSelectTable);
        jScrollPane.setVerticalScrollBarPolicy(22);
        UIUtility uIUtility = UIUtility.getInstance();
        JButton jButton = uIUtility.createTransparentButton("icons/left.png", "icons/left2.png");
        JButton jButton2 = uIUtility.createTransparentButton("icons/right.png", "icons/right2.png");
        JButton jButton3 = uIUtility.createTransparentButton("icons/color.png", "icons/color2.png");
        JButton jButton4 = uIUtility.createTransparentButton("icons/config.png", "icons/config2.png");
        jButton.setToolTipText(properties.getProperty("tooltip.shrink"));
        jButton2.setToolTipText(properties.getProperty("tooltip.expand"));
        jButton3.setToolTipText(properties.getProperty("tooltip.color"));
        jButton4.setToolTipText(properties.getProperty("tooltip.config"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ImageSelectPanel.this.shrink();
            }
        });
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ImageSelectPanel.this.expand();
            }
        });
        jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ImageSelectPanel.this.onChangeColor(new ImageSelectPanelEvent(ImageSelectPanel.this));
            }
        });
        jButton4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ImageSelectPanel.this.onPreferences(new ImageSelectPanelEvent(ImageSelectPanel.this));
            }
        });
        JPanel jPanel = new JPanel(new BorderLayout());
        JToolBar jToolBar = new JToolBar();
        jToolBar.setFloatable(false);
        jToolBar.add(jButton);
        jToolBar.add(jButton2);
        jToolBar.add(jButton3);
        jPanel.add((Component)jToolBar, "North");
        if (partsCategory.isMultipleSelectable()) {
            object = UIUtility.getInstance();
            jComponent = ((UIUtility)object).createTransparentButton("icons/arrow_up.png", "icons/arrow_up2.png");
            serializable2 = ((UIUtility)object).createTransparentButton("icons/arrow_down.png", "icons/arrow_down2.png");
            serializable = ((UIUtility)object).createTransparentButton("icons/sort.png", "icons/sort2.png");
            jComponent.setToolTipText(properties.getProperty("tooltip.up"));
            ((JComponent)serializable2).setToolTipText(properties.getProperty("tooltip.down"));
            serializable.setToolTipText(properties.getProperty("tooltip.sort"));
            ((AbstractButton)jComponent).addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ImageSelectPanel.this.onUp();
                }
            });
            ((AbstractButton)serializable2).addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ImageSelectPanel.this.onDown();
                }
            });
            serializable.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ImageSelectPanel.this.onSort();
                }
            });
            JToolBar jToolBar2 = new JToolBar();
            jToolBar2.setFloatable(false);
            jToolBar2.add(jComponent);
            jToolBar2.add((Component)serializable2);
            jToolBar2.add((Component)serializable);
            jPanel.add((Component)jToolBar2, "South");
        }
        object = new JPanel(new BorderLayout());
        ((Container)object).add((Component)jPanel, "East");
        jComponent = new JLabel(" " + partsCategory.getLocalizedCategoryName() + " ");
        serializable2 = jComponent.getFont();
        jComponent.setFont(((Font)serializable2).deriveFont(1));
        ((Container)object).add((Component)jComponent, "Center");
        this.add((Component)object, "North");
        this.add((Component)jScrollPane, "Center");
        this.rowHeight = this.partsSelectTable.getRowHeight();
        serializable = this.getInsets();
        this.minHeight = ((JComponent)object).getPreferredSize().height + ((Insets)serializable).top + ((Insets)serializable).bottom;
        this.setPreferredSize(new Dimension(200, this.minHeight + this.rowHeight * partsCategory.getVisibleRows()));
    }

    public void loadParts() {
        this.partsSelectTableModel.load(this.partsSpecResolver.getPartsSpecMap(this.partsCategory).keySet());
        this.scrollToSelectedRow();
    }

    public PartsCategory getPartsCategory() {
        return this.partsCategory;
    }

    public void selectParts(Collection<PartsIdentifier> collection) {
        if (collection == null) {
            collection = Collections.emptyList();
        }
        PartsSelectListModel partsSelectListModel = (PartsSelectListModel)this.partsSelectTable.getModel();
        ArrayList<PartsSelectRow> arrayList = partsSelectListModel.getRowModelList();
        for (PartsSelectRow object2 : arrayList) {
            object2.setChecked(false);
        }
        ArrayList<PartsIdentifier> arrayList2 = new ArrayList<PartsIdentifier>(collection);
        Collections.reverse(arrayList2);
        Iterator iterator = arrayList2.iterator();
        block1: while (iterator.hasNext()) {
            PartsIdentifier partsIdentifier = (PartsIdentifier)iterator.next();
            Iterator<PartsSelectRow> iterator2 = arrayList.iterator();
            while (iterator2.hasNext()) {
                PartsSelectRow partsSelectRow = iterator2.next();
                if (!partsSelectRow.getPartsIdentifier().equals(partsIdentifier)) continue;
                partsSelectRow.setChecked(true);
                if (arrayList2.size() < 2 || !this.partsCategory.isMultipleSelectable()) continue block1;
                iterator2.remove();
                arrayList.add(0, partsSelectRow);
                continue block1;
            }
        }
        this.selectedPartsIdentifier = this.getSelectedPartsIdentifier();
        this.selectedPartsIdentifiers = this.getSelectedPartsIdentifiers();
        this.partsSelectTable.repaint();
        this.scrollToSelectedRow();
    }

    public void scrollToSelectedRow() {
        PartsSelectListModel partsSelectListModel = (PartsSelectListModel)this.partsSelectTable.getModel();
        ArrayList<PartsSelectRow> arrayList = partsSelectListModel.getRowModelList();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            if (!arrayList.get(i).isChecked()) continue;
            Rectangle rectangle = this.partsSelectTable.getCellRect(i, 0, true);
            this.partsSelectTable.scrollRectToVisible(rectangle);
            break;
        }
    }

    public void shrink() {
        Dimension dimension = this.getPreferredSize();
        dimension.height -= this.rowHeight * 2;
        if (dimension.height < this.minHeight) {
            dimension.height = this.minHeight;
        }
        this.setPreferredSize(dimension);
        this.revalidate();
    }

    public void expand() {
        Dimension dimension = this.getPreferredSize();
        dimension.height += this.rowHeight * 2;
        this.setPreferredSize(dimension);
        this.revalidate();
    }

    public void addImageSelectListener(ImageSelectPanelListener imageSelectPanelListener) {
        if (imageSelectPanelListener == null) {
            throw new IllegalArgumentException();
        }
        this.listeners.add(imageSelectPanelListener);
    }

    public void removeImageSelectListener(ImageSelectPanelListener imageSelectPanelListener) {
        this.listeners.remove(imageSelectPanelListener);
    }

    public void requestListFocus() {
        this.partsSelectTable.requestFocus();
    }

    protected void onUp() {
        int n = this.partsSelectTable.getSelectedRow();
        if (n < 0) {
            return;
        }
        if (n > 0) {
            ArrayList<PartsSelectRow> arrayList = ((PartsSelectListModel)this.partsSelectTable.getModel()).getRowModelList();
            PartsSelectRow partsSelectRow = arrayList.get(n);
            arrayList.remove(n);
            arrayList.add(n - 1, partsSelectRow);
            this.partsSelectTable.setRowSelectionInterval(n - 1, n - 1);
            Rectangle rectangle = this.partsSelectTable.getCellRect(n - 1, 0, true);
            this.partsSelectTable.scrollRectToVisible(rectangle);
            this.onChange(new ImageSelectPanelEvent(this));
        }
        this.partsSelectTable.repaint();
        this.partsSelectTable.requestFocus();
    }

    protected void onDown() {
        int n = this.partsSelectTable.getSelectedRow();
        if (n < 0) {
            return;
        }
        int n2 = this.partsSelectTable.getRowCount();
        if (n < n2 - 1) {
            ArrayList<PartsSelectRow> arrayList = ((PartsSelectListModel)this.partsSelectTable.getModel()).getRowModelList();
            PartsSelectRow partsSelectRow = arrayList.get(n);
            arrayList.remove(n);
            arrayList.add(n + 1, partsSelectRow);
            this.partsSelectTable.setRowSelectionInterval(n + 1, n + 1);
            Rectangle rectangle = this.partsSelectTable.getCellRect(n + 1, 0, true);
            this.partsSelectTable.scrollRectToVisible(rectangle);
            this.onChange(new ImageSelectPanelEvent(this));
        }
        this.partsSelectTable.repaint();
        this.partsSelectTable.requestFocus();
    }

    protected void onSort() {
        if (this.partsSelectTable.getRowCount() > 0) {
            this.partsSelectTableModel.sort();
            this.partsSelectTable.setRowSelectionInterval(0, 0);
            Rectangle rectangle = this.partsSelectTable.getCellRect(0, 0, true);
            this.partsSelectTable.scrollRectToVisible(rectangle);
            this.partsSelectTable.repaint();
        }
        this.partsSelectTable.requestFocus();
    }

    protected void onChangeColor(ImageSelectPanelEvent imageSelectPanelEvent) {
        for (ImageSelectPanelListener imageSelectPanelListener : this.listeners) {
            imageSelectPanelListener.onChangeColor(imageSelectPanelEvent);
        }
    }

    protected void onPreferences(ImageSelectPanelEvent imageSelectPanelEvent) {
        for (ImageSelectPanelListener imageSelectPanelListener : this.listeners) {
            imageSelectPanelListener.onPreferences(imageSelectPanelEvent);
        }
    }

    protected void onChange(ImageSelectPanelEvent imageSelectPanelEvent) {
        List<PartsIdentifier> list = this.getSelectedPartsIdentifiers();
        if (!((Object)list).equals(this.selectedPartsIdentifiers)) {
            this.selectedPartsIdentifiers = list;
            for (ImageSelectPanelListener imageSelectPanelListener : this.listeners) {
                imageSelectPanelListener.onChange(imageSelectPanelEvent);
            }
            this.onSelectChange(imageSelectPanelEvent);
        }
    }

    protected void onSelectChange(ImageSelectPanelEvent imageSelectPanelEvent) {
        PartsIdentifier partsIdentifier = this.getSelectedPartsIdentifier();
        if (!PartsIdentifier.equals(partsIdentifier, this.selectedPartsIdentifier)) {
            this.selectedPartsIdentifier = partsIdentifier;
            for (ImageSelectPanelListener imageSelectPanelListener : this.listeners) {
                imageSelectPanelListener.onSelectChange(imageSelectPanelEvent);
            }
        }
    }

    public List<PartsIdentifier> getSelectedPartsIdentifiers() {
        return this.partsSelectTableModel.getSelectedPartsIdentifiers();
    }

    public PartsIdentifier getSelectedPartsIdentifier() {
        int[] nArray = this.partsSelectTable.getSelectedRows();
        Arrays.sort(nArray);
        for (int n : nArray) {
            PartsSelectRow partsSelectRow = this.partsSelectTableModel.getRow(n);
            if (!partsSelectRow.isChecked()) continue;
            return partsSelectRow.getPartsIdentifier();
        }
        Object object = this.getSelectedPartsIdentifiers();
        if (object.size() > 0) {
            return (PartsIdentifier)object.get(0);
        }
        return null;
    }

    public static class ImageSelectPanelEvent
    extends EventObject {
        private static final long serialVersionUID = 1L;

        public ImageSelectPanelEvent(ImageSelectPanel imageSelectPanel) {
            super(imageSelectPanel);
        }

        public ImageSelectPanel getImageSelectPanel() {
            return (ImageSelectPanel)this.getSource();
        }
    }

    public static interface ImageSelectPanelListener
    extends EventListener {
        public void onSelectChange(ImageSelectPanelEvent var1);

        public void onChange(ImageSelectPanelEvent var1);

        public void onChangeColor(ImageSelectPanelEvent var1);

        public void onPreferences(ImageSelectPanelEvent var1);
    }
}

