/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.ui;

import charactermanaj.model.AppConfig;
import charactermanaj.model.CharacterData;
import charactermanaj.model.PartsIdentifier;
import charactermanaj.model.PartsSet;
import charactermanaj.model.io.AbstractCharacterDataArchiveFile;
import charactermanaj.ui.ImportPartsModel;
import charactermanaj.ui.ImportPartsTableModel;
import charactermanaj.ui.ImportWizardCardPanel;
import charactermanaj.ui.ImportWizardDialog;
import charactermanaj.util.LocalizedResourcePropertyLoader;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.HashSet;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ImportPartsSelectPanel
extends ImportWizardCardPanel {
    private static final long serialVersionUID = 1L;
    public static final String PANEL_NAME = "importPartsSelectPanel";
    private ImportWizardDialog parent;
    private ImportPartsTableModel partsTableModel;
    private JPanel profileSizePanel;
    private JTextField txtProfileHeight;
    private int profileWidth;
    private int profileHeight;
    private JTextField txtProfileWidth;
    private JTable partsTable;
    private Action actSelectAll;
    private Action actDeselectAll;
    private Action actSort;
    private Action actSortByTimestamp;

    public ImportPartsSelectPanel() {
        Properties properties = LocalizedResourcePropertyLoader.getInstance().getLocalizedProperties("strings/importwizdialog");
        this.setLayout(new BorderLayout());
        this.profileSizePanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.profileSizePanel.setLayout(gridBagLayout);
        this.profileSizePanel.setBorder(BorderFactory.createTitledBorder("\u30d7\u30ed\u30d5\u30a1\u30a4\u30eb\u306e\u30b5\u30a4\u30ba"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        this.profileSizePanel.add((Component)new JLabel("\u5e45:", 4), gridBagConstraints);
        this.txtProfileWidth = new JTextField();
        this.txtProfileWidth.setEditable(false);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        this.profileSizePanel.add((Component)this.txtProfileWidth, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        this.profileSizePanel.add((Component)new JLabel("\u9ad8\u3055:", 4), gridBagConstraints);
        this.txtProfileHeight = new JTextField();
        this.txtProfileHeight.setEditable(false);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        this.profileSizePanel.add((Component)this.txtProfileHeight, gridBagConstraints);
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        this.profileSizePanel.add(Box.createHorizontalGlue(), gridBagConstraints);
        this.add((Component)this.profileSizePanel, "North");
        this.partsTableModel = new ImportPartsTableModel();
        this.partsTableModel.addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent tableModelEvent) {
                ImportPartsSelectPanel.this.fireChangeEvent();
            }
        });
        AppConfig appConfig = AppConfig.getInstance();
        final Color color = appConfig.getDisabledCellForgroundColor();
        this.partsTable = new JTable(this.partsTableModel){
            private static final long serialVersionUID = 1L;

            public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n, int n2) {
                ImportPartsTableModel importPartsTableModel;
                ImportPartsModel importPartsModel;
                Long l;
                Component component = super.prepareRenderer(tableCellRenderer, n, n2);
                if (component instanceof JCheckBox) {
                    component.setEnabled(this.isCellEditable(n, n2) && this.isEnabled());
                }
                if ((l = (importPartsModel = (ImportPartsModel)(importPartsTableModel = (ImportPartsTableModel)this.getModel()).getRow(n)).getLastModifiedAtCurrentProfile()) != null) {
                    component.setFont(this.getFont().deriveFont(1));
                } else {
                    component.setFont(this.getFont());
                }
                boolean bl = false;
                if (n2 == 5) {
                    if (l != null && importPartsModel.getLastModified() < l) {
                        bl = true;
                    }
                } else if (n2 == 4) {
                    if (!importPartsModel.isAlphaColor()) {
                        bl = true;
                    }
                } else if (n2 == 3 && (importPartsModel.isUnmatchedSize() || ImportPartsSelectPanel.this.profileWidth != importPartsModel.getWidth() || ImportPartsSelectPanel.this.profileHeight != importPartsModel.getHeight())) {
                    bl = true;
                }
                Color color3 = this.getForeground();
                component.setForeground(this.isEnabled() ? color3 : color);
                if (bl) {
                    AppConfig appConfig = AppConfig.getInstance();
                    Color color2 = appConfig.getInvalidBgColor();
                    component.setBackground(color2);
                } else {
                    component.setBackground(this.getBackground());
                }
                return component;
            }
        };
        this.partsTable.setAutoResizeMode(0);
        this.partsTableModel.adjustColumnModel(this.partsTable.getColumnModel());
        JScrollPane jScrollPane = new JScrollPane(this.partsTable);
        jScrollPane.setBorder(BorderFactory.createTitledBorder(properties.getProperty("parts.title")));
        this.add((Component)jScrollPane, "Center");
        this.actSelectAll = new AbstractAction(properties.getProperty("parts.btn.selectAll")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                ImportPartsSelectPanel.this.onSelectAll();
            }
        };
        this.actDeselectAll = new AbstractAction(properties.getProperty("parts.btn.deselectAll")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                ImportPartsSelectPanel.this.onDeselectAll();
            }
        };
        this.actSort = new AbstractAction(properties.getProperty("parts.btn.sort")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                ImportPartsSelectPanel.this.onSort();
            }
        };
        this.actSortByTimestamp = new AbstractAction(properties.getProperty("parts.btn.sortByTimestamp")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                ImportPartsSelectPanel.this.onSortByTimestamp();
            }
        };
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout2 = new GridBagLayout();
        jPanel.setLayout(gridBagLayout2);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        JButton jButton = new JButton(this.actSelectAll);
        jPanel.add((Component)jButton, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        JButton jButton2 = new JButton(this.actDeselectAll);
        jPanel.add((Component)jButton2, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        JButton jButton3 = new JButton(this.actSort);
        jPanel.add((Component)jButton3, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        JButton jButton4 = new JButton(this.actSortByTimestamp);
        jPanel.add((Component)jButton4, gridBagConstraints);
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        jPanel.add(Box.createHorizontalGlue(), gridBagConstraints);
        this.add((Component)jPanel, "South");
    }

    @Override
    public void onActive(ImportWizardDialog importWizardDialog, ImportWizardCardPanel importWizardCardPanel) {
        CharacterData characterData;
        Collection<AbstractCharacterDataArchiveFile.PartsImageContent> collection;
        CharacterData characterData2;
        Dimension dimension;
        this.parent = importWizardDialog;
        if (importWizardCardPanel == importWizardDialog.importPresetSelectPanel) {
            return;
        }
        CharacterData characterData3 = importWizardDialog.importTypeSelectPanel.isNewProfile() ? importWizardDialog.fileSelectPanel.getCharacterData() : importWizardDialog.current;
        int n = 0;
        int n2 = 0;
        if (characterData3 != null && (dimension = characterData3.getImageSize()) != null) {
            n = dimension.width;
            n2 = dimension.height;
        }
        this.txtProfileWidth.setText(Integer.toString(n));
        this.txtProfileHeight.setText(Integer.toString(n2));
        this.profileSizePanel.revalidate();
        this.profileHeight = n2;
        this.profileWidth = n;
        boolean bl = importWizardDialog.importTypeSelectPanel.isImportPartsImages();
        this.partsTable.setEnabled(bl);
        this.actDeselectAll.setEnabled(bl);
        this.actSelectAll.setEnabled(bl);
        this.actSort.setEnabled(bl);
        this.actSortByTimestamp.setEnabled(bl);
        if (importWizardDialog.importTypeSelectPanel.isNewProfile()) {
            characterData2 = null;
            collection = importWizardDialog.fileSelectPanel.getPartsImageContentsForNewProfile();
        } else {
            characterData2 = importWizardDialog.current;
            collection = importWizardDialog.fileSelectPanel.getPartsImageContentsForCurrentProfile();
        }
        this.partsTableModel.initModel(collection, characterData2);
        Collection<PartsSet> collection2 = null;
        if (importWizardDialog.importTypeSelectPanel.isImportPreset() && (characterData = importWizardDialog.fileSelectPanel.getCharacterData()) != null && characterData.isValid()) {
            collection2 = characterData.getPartsSets().values();
        }
        characterData = importWizardDialog.importTypeSelectPanel.isNewProfile() ? null : importWizardDialog.current;
        importWizardDialog.importPresetSelectPanel.initModel(collection2, characterData);
    }

    @Override
    public boolean isReadyPrevious() {
        return true;
    }

    @Override
    public String doPrevious() {
        this.partsTableModel.clear();
        return "importTypeSelectPanel";
    }

    @Override
    public boolean isReadyNext() {
        return this.parent != null && this.parent.importTypeSelectPanel.isImportPreset();
    }

    @Override
    public boolean isReadyFinish() {
        return this.parent != null && this.parent.importTypeSelectPanel.isImportPartsImages() && !this.parent.importTypeSelectPanel.isImportPreset();
    }

    @Override
    public String doNext() {
        return "importPresetSelectPanel";
    }

    protected void onSelectAll() {
        this.partsTableModel.selectAll();
    }

    protected void onDeselectAll() {
        this.partsTableModel.deselectAll();
    }

    protected void onSort() {
        this.partsTableModel.sort();
        if (this.partsTableModel.getRowCount() > 0) {
            Rectangle rectangle = this.partsTable.getCellRect(0, 0, true);
            this.partsTable.scrollRectToVisible(rectangle);
        }
    }

    protected void onSortByTimestamp() {
        this.partsTableModel.sortByTimestamp();
        if (this.partsTableModel.getRowCount() > 0) {
            Rectangle rectangle = this.partsTable.getCellRect(0, 0, true);
            this.partsTable.scrollRectToVisible(rectangle);
        }
    }

    public Collection<AbstractCharacterDataArchiveFile.PartsImageContent> getSelectedPartsImageContents() {
        return this.partsTableModel.getSelectedPartsImageContents();
    }

    public Collection<PartsIdentifier> getImportedPartsIdentifiers() {
        HashSet<PartsIdentifier> hashSet = new HashSet<PartsIdentifier>();
        hashSet.addAll(this.partsTableModel.getCurrentProfilePartsIdentifers());
        hashSet.addAll(this.partsTableModel.getSelectedPartsIdentifiers());
        return hashSet;
    }

    public void selectByPartsIdentifiers(Collection<PartsIdentifier> collection) {
        this.partsTableModel.selectByPartsIdentifiers(collection);
    }
}

