/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.ui;

import charactermanaj.model.CharacterData;
import charactermanaj.model.PartsCategory;
import charactermanaj.model.PartsIdentifier;
import charactermanaj.model.io.AbstractCharacterDataArchiveFile;
import charactermanaj.ui.ImportPartsImageSet;
import charactermanaj.ui.ImportPartsModel;
import charactermanaj.ui.model.AbstractTableModelWithComboBoxModel;
import charactermanaj.util.LocalizedResourcePropertyLoader;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Properties;
import java.util.Set;
import javax.swing.table.TableColumnModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ImportPartsTableModel
extends AbstractTableModelWithComboBoxModel<ImportPartsModel> {
    private static final long serialVersionUID = 1L;
    private static final String[] COLUMN_NAMES;
    private static final int[] COLUMN_WIDTHS;
    public static final int COLUMN_LASTMODIFIED = 5;
    public static final int COLUMN_ALPHA = 4;
    public static final int COLUMN_SIZE = 3;
    private Set<PartsIdentifier> currentProfilePartsIdentifiers;

    ImportPartsTableModel() {
    }

    public void initModel(Collection<AbstractCharacterDataArchiveFile.PartsImageContent> collection, CharacterData characterData) {
        Serializable serializable;
        Object object;
        this.clear();
        if (collection == null) {
            return;
        }
        HashSet<PartsIdentifier> hashSet = new HashSet<PartsIdentifier>();
        if (characterData != null) {
            for (PartsCategory arrayList2 : characterData.getPartsCategories()) {
                hashSet.addAll(characterData.getPartsSpecMap(arrayList2).keySet());
            }
        }
        this.currentProfilePartsIdentifiers = Collections.unmodifiableSet(hashSet);
        HashMap hashMap = new HashMap();
        for (AbstractCharacterDataArchiveFile.PartsImageContent partsImageContent : collection) {
            Object object2 = partsImageContent.getPartsName();
            object = (ImportPartsImageSet)hashMap.get(object2);
            if (object == null) {
                object = new ImportPartsImageSet((String)object2);
                hashMap.put(object2, object);
            }
            ((ImportPartsImageSet)object).add(partsImageContent);
        }
        ArrayList arrayList = new ArrayList(hashMap.keySet());
        Collections.sort(arrayList);
        for (Object object2 : arrayList) {
            object = (ImportPartsImageSet)hashMap.get(object2);
            int n = ((ImportPartsImageSet)object).getPartsCategories().size();
            for (PartsCategory partsCategory : ((ImportPartsImageSet)object).getPartsCategories()) {
                serializable = new PartsIdentifier(partsCategory, (String)object2, (String)object2);
                ImportPartsModel importPartsModel = new ImportPartsModel((PartsIdentifier)serializable, (ImportPartsImageSet)object, n);
                this.addRow(importPartsModel);
            }
        }
        for (Object object2 : this.elements) {
            object = ((ImportPartsModel)object2).getPartsIdentifier();
            ImportPartsImageSet importPartsImageSet = ((ImportPartsModel)object2).getImageSet();
            long l = 0L;
            if (characterData != null && (serializable = characterData.getPartsSpec((PartsIdentifier)object)) != null) {
                l = serializable.getPartsFiles().lastModified();
                importPartsImageSet.setLastModifiedAtCurrentProfile(l);
            }
            if (l >= importPartsImageSet.lastModified()) continue;
            importPartsImageSet.setChecked(true);
        }
        this.sort();
    }

    public Collection<AbstractCharacterDataArchiveFile.PartsImageContent> getSelectedPartsImageContents() {
        IdentityHashMap<ImportPartsImageSet, ImportPartsImageSet> identityHashMap = new IdentityHashMap<ImportPartsImageSet, ImportPartsImageSet>();
        for (Object object : this.elements) {
            ImportPartsImageSet importPartsImageSet = ((ImportPartsModel)object).getImageSet();
            if (!importPartsImageSet.isChecked()) continue;
            identityHashMap.put(importPartsImageSet, importPartsImageSet);
        }
        ArrayList arrayList = new ArrayList();
        for (ImportPartsImageSet importPartsImageSet : identityHashMap.values()) {
            arrayList.addAll(importPartsImageSet);
        }
        return arrayList;
    }

    public Collection<PartsIdentifier> getSelectedPartsIdentifiers() {
        HashSet<PartsIdentifier> hashSet = new HashSet<PartsIdentifier>();
        for (ImportPartsModel importPartsModel : this.elements) {
            if (!importPartsModel.isChecked()) continue;
            hashSet.add(importPartsModel.getPartsIdentifier());
        }
        return hashSet;
    }

    public Collection<PartsIdentifier> getCurrentProfilePartsIdentifers() {
        return this.currentProfilePartsIdentifiers;
    }

    @Override
    public int getColumnCount() {
        return COLUMN_NAMES.length;
    }

    @Override
    public String getColumnName(int n) {
        return COLUMN_NAMES[n];
    }

    @Override
    public Object getValueAt(int n, int n2) {
        ImportPartsModel importPartsModel = (ImportPartsModel)this.getRow(n);
        switch (n2) {
            case 0: {
                return importPartsModel.isChecked();
            }
            case 1: {
                return importPartsModel.getPartsName();
            }
            case 2: {
                return importPartsModel.getPartsCategiry().getLocalizedCategoryName();
            }
            case 3: {
                return importPartsModel.getWidth() + "x" + importPartsModel.getHeight() + (importPartsModel.isUnmatchedSize() ? "*" : "");
            }
            case 4: {
                return importPartsModel.isAlphaColor();
            }
            case 5: {
                long l = importPartsModel.getLastModified();
                if (l > 0L) {
                    return new Timestamp(l).toString();
                }
                return "";
            }
            case 6: {
                Long l = importPartsModel.getLastModifiedAtCurrentProfile();
                if (l != null && l > 0L) {
                    return new Timestamp(l).toString();
                }
                return "";
            }
        }
        return "";
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        ImportPartsModel importPartsModel = (ImportPartsModel)this.getRow(n);
        switch (n2) {
            case 0: {
                importPartsModel.setChecked((Boolean)object);
                break;
            }
            default: {
                return;
            }
        }
        if (importPartsModel.getNumOfLink() > 1) {
            this.fireTableDataChanged();
        } else {
            this.fireListUpdated(n, n);
        }
    }

    @Override
    public Class<?> getColumnClass(int n) {
        switch (n) {
            case 0: {
                return Boolean.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return String.class;
            }
            case 3: {
                return String.class;
            }
            case 4: {
                return Boolean.class;
            }
            case 5: {
                return String.class;
            }
            case 6: {
                return String.class;
            }
        }
        return String.class;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return n2 == 0;
    }

    public void adjustColumnModel(TableColumnModel tableColumnModel) {
        int n = tableColumnModel.getColumnCount();
        for (int i = 0; i < n; ++i) {
            tableColumnModel.getColumn(i).setWidth(COLUMN_WIDTHS[i]);
        }
    }

    public void selectAll() {
        boolean bl = false;
        for (ImportPartsModel importPartsModel : this.elements) {
            if (importPartsModel.isChecked()) continue;
            importPartsModel.setChecked(true);
            bl = true;
        }
        if (bl) {
            this.fireTableDataChanged();
        }
    }

    public void deselectAll() {
        boolean bl = false;
        for (ImportPartsModel importPartsModel : this.elements) {
            if (!importPartsModel.isChecked()) continue;
            importPartsModel.setChecked(false);
            bl = true;
        }
        if (bl) {
            this.fireTableDataChanged();
        }
    }

    public void sort() {
        Collections.sort(this.elements, new Comparator<ImportPartsModel>(){

            @Override
            public int compare(ImportPartsModel importPartsModel, ImportPartsModel importPartsModel2) {
                int n = (importPartsModel.isChecked() ? 0 : 1) - (importPartsModel2.isChecked() ? 0 : 1);
                if (n == 0) {
                    n = importPartsModel.getPartsIdentifier().compareTo(importPartsModel2.getPartsIdentifier());
                }
                return n;
            }
        });
        this.fireTableDataChanged();
    }

    public void sortByTimestamp() {
        Collections.sort(this.elements, new Comparator<ImportPartsModel>(){

            @Override
            public int compare(ImportPartsModel importPartsModel, ImportPartsModel importPartsModel2) {
                long l = (importPartsModel.isChecked() ? 0 : 1) - (importPartsModel2.isChecked() ? 0 : 1);
                if (l == 0L) {
                    Long l2 = importPartsModel.getLastModifiedAtCurrentProfile();
                    Long l3 = importPartsModel2.getLastModifiedAtCurrentProfile();
                    long l4 = Math.max(importPartsModel.getLastModified(), l2 == null ? 0L : l2);
                    long l5 = Math.max(importPartsModel2.getLastModified(), l3 == null ? 0L : l3);
                    l = l4 - l5;
                }
                if (l == 0L) {
                    l = importPartsModel.getPartsIdentifier().compareTo(importPartsModel2.getPartsIdentifier());
                }
                return l == 0L ? 0 : (l > 0L ? 1 : -1);
            }
        });
        this.fireTableDataChanged();
    }

    public void selectByPartsIdentifiers(Collection<PartsIdentifier> collection) {
        boolean bl = false;
        if (collection != null) {
            for (PartsIdentifier partsIdentifier : collection) {
                for (ImportPartsModel importPartsModel : this.elements) {
                    if (!importPartsModel.getPartsIdentifier().equals(partsIdentifier) || importPartsModel.isChecked()) continue;
                    importPartsModel.setChecked(true);
                    bl = true;
                }
            }
        }
        if (bl) {
            this.fireTableDataChanged();
        }
    }

    static {
        Properties properties = LocalizedResourcePropertyLoader.getInstance().getLocalizedProperties("strings/importwizdialog");
        COLUMN_NAMES = new String[]{properties.getProperty("parts.column.check"), properties.getProperty("parts.column.partsname"), properties.getProperty("parts.column.category"), properties.getProperty("parts.column.imagesize"), properties.getProperty("parts.column.alpha"), properties.getProperty("parts.column.lastmodified"), properties.getProperty("parts.column.org-lastmodified")};
        COLUMN_WIDTHS = new int[]{Integer.parseInt(properties.getProperty("parts.column.check.size")), Integer.parseInt(properties.getProperty("parts.column.partsname.size")), Integer.parseInt(properties.getProperty("parts.column.category.size")), Integer.parseInt(properties.getProperty("parts.column.imagesize.size")), Integer.parseInt(properties.getProperty("parts.column.alpha.size")), Integer.parseInt(properties.getProperty("parts.column.lastmodified.size")), Integer.parseInt(properties.getProperty("parts.column.org-lastmodified.size"))};
    }
}

