/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.ui;

import charactermanaj.model.AppConfig;
import charactermanaj.model.CharacterData;
import charactermanaj.model.io.AbstractCharacterDataArchiveFile;
import charactermanaj.ui.ImportWizardCardPanel;
import charactermanaj.ui.ImportWizardDialog;
import charactermanaj.ui.SamplePicturePanel;
import charactermanaj.util.LocalizedResourcePropertyLoader;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Transparency;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.util.Collection;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

class ImportTypeSelectPanel
extends ImportWizardCardPanel {
    private static final long serialVersionUID = 1L;
    public static final String PANEL_NAME = "importTypeSelectPanel";
    private SamplePicturePanel samplePicturePanel;
    private JTextField txtCharacterId;
    private JTextField txtCharacterRev;
    private JTextField txtCharacterName;
    private JTextField txtAuthor;
    private JTextArea txtDescription;
    private JCheckBox chkCharacterDef;
    private JCheckBox chkPartsImages;
    private JCheckBox chkPresets;
    private JCheckBox chkSampleImage;
    private JCheckBox chkExportSubset;
    private JCheckBox chkAddDescription;
    private String additionalDescription;
    private boolean noContents;

    public ImportTypeSelectPanel() {
        Properties properties = LocalizedResourcePropertyLoader.getInstance().getLocalizedProperties("strings/importwizdialog");
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), BorderFactory.createTitledBorder(properties.getProperty("basic.contentsSpec"))));
        BoxLayout boxLayout = new BoxLayout(jPanel, 3);
        jPanel.setLayout(boxLayout);
        this.chkCharacterDef = new JCheckBox(properties.getProperty("characterdef"));
        this.chkPartsImages = new JCheckBox(properties.getProperty("basic.chk.partsImages"));
        this.chkPresets = new JCheckBox(properties.getProperty("basic.chk.presets"));
        this.chkSampleImage = new JCheckBox(properties.getProperty("basic.chk.samplePicture"));
        jPanel.add(this.chkCharacterDef);
        jPanel.add(this.chkPartsImages);
        jPanel.add(this.chkPresets);
        jPanel.add(this.chkSampleImage);
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), BorderFactory.createTitledBorder(properties.getProperty("basic.archiveInfo"))));
        Dimension dimension = new Dimension(300, 200);
        jPanel2.setMinimumSize(dimension);
        jPanel2.setPreferredSize(dimension);
        GridBagLayout gridBagLayout2 = new GridBagLayout();
        jPanel2.setLayout(gridBagLayout2);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        this.chkExportSubset = new JCheckBox(properties.getProperty("exportSubset"));
        this.chkExportSubset.setEnabled(false);
        jPanel2.add((Component)this.chkExportSubset, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        jPanel2.add((Component)new JLabel(properties.getProperty("basic.profileId"), 4), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.txtCharacterId = new JTextField();
        this.txtCharacterId.setEditable(false);
        jPanel2.add((Component)this.txtCharacterId, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        jPanel2.add((Component)new JLabel(properties.getProperty("basic.profileRev"), 4), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.txtCharacterRev = new JTextField();
        this.txtCharacterRev.setEditable(false);
        jPanel2.add((Component)this.txtCharacterRev, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        jPanel2.add((Component)new JLabel(properties.getProperty("basic.profileName"), 4), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.txtCharacterName = new JTextField();
        this.txtCharacterName.setEditable(false);
        jPanel2.add((Component)this.txtCharacterName, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        jPanel2.add((Component)new JLabel(properties.getProperty("author"), 4), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        this.txtAuthor = new JTextField();
        this.txtAuthor.setEditable(false);
        jPanel2.add((Component)this.txtAuthor, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        jPanel2.add((Component)new JLabel(properties.getProperty("description"), 4), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 5;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        this.txtDescription = new JTextArea();
        this.txtDescription.setFont(this.getFont());
        this.txtDescription.setEditable(false);
        jPanel2.add((Component)new JScrollPane(this.txtDescription), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        this.chkAddDescription = new JCheckBox(properties.getProperty("appendDescription"));
        jPanel2.add((Component)this.chkAddDescription, gridBagConstraints);
        this.samplePicturePanel = new SamplePicturePanel();
        JScrollPane jScrollPane = new JScrollPane(this.samplePicturePanel);
        jScrollPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), BorderFactory.createTitledBorder(properties.getProperty("basic.sampleImage"))));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        this.add((Component)jPanel, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        this.add((Component)jPanel2, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        this.add((Component)jScrollPane, gridBagConstraints);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ImportTypeSelectPanel.this.fireChangeEvent();
            }
        };
        this.chkCharacterDef.addActionListener(actionListener);
        this.chkPartsImages.addActionListener(actionListener);
        this.chkPresets.addActionListener(actionListener);
        this.chkSampleImage.addActionListener(actionListener);
        this.chkAddDescription.addActionListener(actionListener);
    }

    public void onActive(ImportWizardDialog importWizardDialog, ImportWizardCardPanel importWizardCardPanel) {
        Transparency transparency;
        Object object;
        boolean bl;
        if (importWizardCardPanel == importWizardDialog.importPartsSelectPanel) {
            return;
        }
        Properties properties = LocalizedResourcePropertyLoader.getInstance().getLocalizedProperties("strings/importwizdialog");
        Collection<CharacterData> collection = importWizardDialog.profiles;
        CharacterData characterData = importWizardDialog.current;
        CharacterData characterData2 = importWizardDialog.fileSelectPanel.getCharacterData();
        Properties properties2 = importWizardDialog.fileSelectPanel.getExportInfoProp();
        boolean bl2 = true;
        String string = null;
        boolean bl3 = characterData != null && characterData.isValid();
        boolean bl4 = collection != null && characterData2 != null && characterData2.isValid();
        boolean bl5 = false;
        boolean bl6 = false;
        if (characterData2 != null && characterData2.isValid()) {
            bl = true;
            boolean bl7 = false;
            bl2 = false;
            if (properties2 != null) {
                bl = Boolean.parseBoolean(properties2.getProperty("EXPORT_SUBSET"));
                bl7 = Boolean.parseBoolean(properties2.getProperty("EXPORT_PRESETS"));
                bl2 = Boolean.parseBoolean(properties2.getProperty("EXPORT_PARTS_IMAGES"));
            }
            if (!bl3) {
                this.chkCharacterDef.setEnabled(false);
                this.chkCharacterDef.setSelected(!bl && bl4);
            } else {
                this.chkCharacterDef.setEnabled(!bl && bl4);
                this.chkCharacterDef.setSelected(false);
            }
            this.chkPresets.setEnabled(bl7 && (bl3 || bl4));
            this.chkPresets.setSelected(bl7);
            this.txtCharacterId.setText(characterData2.getId());
            this.txtCharacterRev.setText(characterData2.getRev());
            this.txtCharacterName.setText(characterData2.getName());
            if (characterData != null) {
                boolean bl8 = characterData.getId() == null ? characterData2.getId() == null : (bl5 = characterData.getId().equals(characterData2.getId()));
                bl6 = characterData.getRev() == null ? characterData2.getRev() == null : characterData.getRev().equals(characterData2.getRev());
            } else {
                bl5 = true;
                bl6 = true;
            }
            object = AppConfig.getInstance();
            transparency = ((AppConfig)object).getInvalidBgColor();
            this.txtCharacterId.setBackground(bl5 ? this.getBackground() : transparency);
            this.txtCharacterRev.setBackground(bl6 ? this.getBackground() : transparency);
            this.txtAuthor.setText(characterData2.getAuthor());
            string = characterData2.getDescription();
            this.chkExportSubset.setSelected(bl);
        } else {
            this.chkCharacterDef.setEnabled(false);
            this.chkCharacterDef.setSelected(false);
            this.chkPresets.setEnabled(false);
            this.chkPresets.setSelected(false);
            this.txtCharacterId.setText("");
            this.txtCharacterRev.setText("");
            this.txtCharacterName.setText("");
            this.txtAuthor.setText("");
            string = importWizardDialog.fileSelectPanel.getReadme();
            this.chkExportSubset.setSelected(true);
        }
        bl = string != null && string.trim().length() > 0;
        this.additionalDescription = bl ? string : "";
        this.txtDescription.setText(this.additionalDescription);
        this.chkAddDescription.setEnabled((bl3 || bl4) && bl);
        this.chkAddDescription.setSelected((bl3 || bl4) && bl);
        Collection<AbstractCharacterDataArchiveFile.PartsImageContent> collection2 = importWizardDialog.fileSelectPanel.getPartsImageContentsForCurrentProfile();
        object = importWizardDialog.fileSelectPanel.getPartsImageContentsForNewProfile();
        if (!(bl2 && (bl3 && !collection2.isEmpty() || bl4 && !object.isEmpty()) && (bl3 || bl4))) {
            this.chkPartsImages.setEnabled(false);
            this.chkPartsImages.setSelected(false);
        } else {
            this.chkPartsImages.setEnabled(true);
            this.chkPartsImages.setSelected(true);
        }
        transparency = importWizardDialog.fileSelectPanel.getSamplePicture();
        if (transparency != null && (bl3 || bl4)) {
            this.samplePicturePanel.setSamplePicture((BufferedImage)transparency);
            this.chkSampleImage.setEnabled(true);
            this.chkSampleImage.setSelected(false);
        } else {
            this.samplePicturePanel.setSamplePicture((BufferedImage)transparency);
            this.chkSampleImage.setEnabled(false);
            this.chkSampleImage.setSelected(false);
        }
        boolean bl9 = this.noContents = !this.chkCharacterDef.isEnabled() && !this.chkPartsImages.isEnabled() && !this.chkPresets.isEnabled() && !this.chkSampleImage.isEnabled();
        if (this.noContents) {
            JOptionPane.showMessageDialog(this, properties.getProperty("noContents"));
        } else if (characterData2 == null) {
            JOptionPane.showMessageDialog(this, properties.getProperty("notFormalArchive"));
        } else if (!bl5) {
            JOptionPane.showMessageDialog(this, properties.getProperty("unmatchedProfileId"));
        } else if (!bl6) {
            JOptionPane.showMessageDialog(this, properties.getProperty("unmatchedProfileRev"));
        }
    }

    public boolean isNewProfile() {
        return this.chkCharacterDef.isSelected();
    }

    public boolean isImportPreset() {
        return this.chkPresets.isSelected();
    }

    public boolean isImportPartsImages() {
        return this.chkPartsImages.isSelected();
    }

    public boolean isImportSampleImage() {
        return this.chkSampleImage.isSelected();
    }

    public boolean isAddDescription() {
        return this.chkAddDescription.isSelected();
    }

    public String getAdditionalDescription() {
        return this.additionalDescription;
    }

    public boolean isReadyPrevious() {
        return true;
    }

    public String doPrevious() {
        return "fileSelectPanel";
    }

    public boolean isReadyNext() {
        return this.isImportPartsImages() || this.isImportPreset();
    }

    public boolean isReadyFinish() {
        return !this.isImportPartsImages() && !this.isImportPreset() && (this.isNewProfile() || this.isImportSampleImage());
    }

    public String doNext() {
        return "importPartsSelectPanel";
    }
}

