/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.ui;

import charactermanaj.clipboardSupport.ClipboardUtil;
import charactermanaj.graphics.AsyncImageBuilder;
import charactermanaj.graphics.ColorConvertedImageCachedLoader;
import charactermanaj.graphics.ImageBuildJobAbstractAdaptor;
import charactermanaj.graphics.ImageBuilder;
import charactermanaj.graphics.io.ImageSaveHelper;
import charactermanaj.model.AppConfig;
import charactermanaj.model.CharacterData;
import charactermanaj.model.ColorGroup;
import charactermanaj.model.PartsCategory;
import charactermanaj.model.PartsColorInfo;
import charactermanaj.model.PartsColorManager;
import charactermanaj.model.PartsIdentifier;
import charactermanaj.model.PartsSet;
import charactermanaj.model.WorkingSet;
import charactermanaj.model.io.CharacterDataPersistent;
import charactermanaj.model.io.PartsImageDirectoryWatchAgent;
import charactermanaj.model.io.PartsImageDirectoryWatchEvent;
import charactermanaj.model.io.PartsImageDirectoryWatchListener;
import charactermanaj.model.io.RecentDataPersistent;
import charactermanaj.ui.AboutBox;
import charactermanaj.ui.ColorDialog;
import charactermanaj.ui.ExportWizardDialog;
import charactermanaj.ui.ImageSelectPanel;
import charactermanaj.ui.ImageSelectPanelList;
import charactermanaj.ui.ImportWizardDialog;
import charactermanaj.ui.InformationDialog;
import charactermanaj.ui.ManageFavoriteDialog;
import charactermanaj.ui.MenuData;
import charactermanaj.ui.MenuDataFactory;
import charactermanaj.ui.PreviewPanel;
import charactermanaj.ui.ProfileSelectorDialog;
import charactermanaj.ui.model.ColorChangeEvent;
import charactermanaj.ui.model.ColorChangeListener;
import charactermanaj.ui.model.ColorGroupCoordinator;
import charactermanaj.ui.model.PartsColorCoordinator;
import charactermanaj.ui.model.PartsSelectionManager;
import charactermanaj.util.ErrorMessageHelper;
import charactermanaj.util.LocalizedResourcePropertyLoader;
import charactermanaj.util.UIUtility;
import charactermanaj.util.UserData;
import charactermanaj.util.UserDataFactory;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

public class MainFrame
extends JFrame {
    private static final long serialVersionUID = 1L;
    protected static final String STRINGS_RESOURCE = "strings/mainframe";
    protected static final String MENU_STRINGS_RESOURCE = "menu/menu";
    private PreviewPanel previewPane;
    protected final BufferedImage icon;
    protected final CharacterData characterData;
    protected final PartsSelectionManager partsSelectionManager;
    protected final ImageSelectPanelList imageSelectPanels;
    protected final ColorGroupCoordinator colorGroupCoordinator;
    protected final PartsColorCoordinator partsColorCoordinator;
    protected static MainFrame activedMainFrame;
    private ColorConvertedImageCachedLoader imageLoader;
    private AsyncImageBuilder imageBuilder;
    private ImageSaveHelper imageSaveHelper = new ImageSaveHelper();
    private PartsImageDirectoryWatchAgent watchAgent;
    private String characterDataName;
    private static final HashMap<URL, Integer> activeCharacterDatas;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isUsingCharacterData(CharacterData characterData) {
        if (characterData == null) {
            return false;
        }
        URL uRL = characterData.getDocBase();
        if (uRL == null) {
            return false;
        }
        HashMap<URL, Integer> hashMap = activeCharacterDatas;
        synchronized (hashMap) {
            Integer n = activeCharacterDatas.get(uRL);
            if (n != null && n > 0) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MainFrame(CharacterData characterData) {
        Serializable serializable;
        Serializable serializable2;
        Serializable serializable32;
        Serializable serializable4;
        Object object;
        if (characterData == null) {
            throw new IllegalArgumentException();
        }
        this.characterData = characterData;
        Object object2 = activeCharacterDatas;
        synchronized (object2) {
            object = characterData.getDocBase();
            if (object != null) {
                serializable4 = activeCharacterDatas.get(object);
                if (serializable4 == null) {
                    serializable4 = 0;
                }
                serializable4 = serializable4 + 1;
                activeCharacterDatas.put((URL)object, (Integer)serializable4);
            }
        }
        object2 = AppConfig.getInstance();
        object = characterData.getPartsColorManager();
        this.imageLoader = new ColorConvertedImageCachedLoader();
        this.imageBuilder = new AsyncImageBuilder(this.imageLoader);
        this.partsSelectionManager = new PartsSelectionManager((PartsColorManager)object);
        this.colorGroupCoordinator = new ColorGroupCoordinator(this.partsSelectionManager, (PartsColorManager)object);
        this.partsColorCoordinator = new PartsColorCoordinator((PartsColorManager)object, this.colorGroupCoordinator);
        this.watchAgent = new PartsImageDirectoryWatchAgent(characterData);
        this.characterDataName = characterData.getName();
        this.setTitle("ChracterManaJ - " + this.characterDataName);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                MainFrame.this.onCloseProfile();
            }

            public void windowClosed(WindowEvent windowEvent) {
                MainFrame.this.imageBuilder.stop();
                MainFrame.this.watchAgent.stop();
            }

            public void windowActivated(WindowEvent windowEvent) {
                activedMainFrame = MainFrame.this;
            }

            public void windowOpened(WindowEvent windowEvent) {
                if (!MainFrame.this.imageBuilder.isAlive()) {
                    MainFrame.this.imageBuilder.start();
                }
                MainFrame.this.scrollToSelectedParts();
            }
        });
        this.icon = UIUtility.getInstance().getImage("icons/icon.png");
        this.setIconImage(this.icon);
        serializable4 = this.createMenuBar();
        this.setJMenuBar((JMenuBar)serializable4);
        Container container = this.getContentPane();
        this.previewPane = new PreviewPanel();
        this.previewPane.setTitle(this.characterDataName);
        this.previewPane.addPreviewPanelListener(new PreviewPanel.PreviewPanelListener(){

            public void addFavorite(PreviewPanel.PreviewPanelEvent previewPanelEvent) {
                MainFrame.this.onRegisterFavorite();
            }

            public void changeBackgroundColor(PreviewPanel.PreviewPanelEvent previewPanelEvent) {
                MainFrame.this.onChangeBgColor();
            }

            public void copyPicture(PreviewPanel.PreviewPanelEvent previewPanelEvent) {
                MainFrame.this.onCopy();
            }

            public void savePicture(PreviewPanel.PreviewPanelEvent previewPanelEvent) {
                MainFrame.this.onSavePicture();
            }

            public void showInformation(PreviewPanel.PreviewPanelEvent previewPanelEvent) {
                MainFrame.this.onInformation();
            }

            public void flipHorizontal(PreviewPanel.PreviewPanelEvent previewPanelEvent) {
                MainFrame.this.onFlipHolizontal();
            }
        });
        this.imageSelectPanels = new ImageSelectPanelList();
        JPanel jPanel = new JPanel();
        BoxLayout boxLayout = new BoxLayout(jPanel, 3);
        jPanel.setLayout(boxLayout);
        for (Serializable serializable32 : characterData.getPartsCategories()) {
            serializable2 = new ImageSelectPanel((PartsCategory)serializable32, characterData);
            jPanel.add((Component)serializable2);
            this.imageSelectPanels.add((ImageSelectPanel)serializable2);
            this.partsSelectionManager.register((ImageSelectPanel)serializable2);
        }
        JScrollPane jScrollPane = new JScrollPane(jPanel){
            private static final long serialVersionUID = 1L;

            public JScrollBar createVerticalScrollBar() {
                JScrollBar jScrollBar = super.createVerticalScrollBar();
                jScrollBar.setUnitIncrement(12);
                return jScrollBar;
            }
        };
        jScrollPane.setVerticalScrollBarPolicy(22);
        serializable32 = new JSplitPane(1, true, jScrollPane, this.previewPane);
        container.add((Component)serializable32, "Center");
        serializable2 = characterData.getImageSize();
        int n = Math.max(300, serializable2 != null ? ((Dimension)serializable2).width : 0);
        int n2 = Math.max(400, serializable2 != null ? ((Dimension)serializable2).height : 0);
        this.setSize(n - 300 + 600, n2 - 400 + 550);
        this.setLocationByPlatform(true);
        jScrollPane.requestFocus();
        ArrayList<ColorGroup> arrayList = new ArrayList<ColorGroup>();
        arrayList.addAll(characterData.getColorGroups());
        ColorChangeListener colorChangeListener = new ColorChangeListener(){

            public void onColorGroupChange(ColorChangeEvent colorChangeEvent) {
            }

            public void onColorChange(ColorChangeEvent colorChangeEvent) {
                MainFrame.this.requestPreview();
            }
        };
        this.colorGroupCoordinator.addColorChangeListener(colorChangeListener);
        int n3 = 0;
        while (n3 < this.imageSelectPanels.size()) {
            serializable = this.imageSelectPanels.get(n3);
            PartsCategory partsCategory = ((ImageSelectPanel)serializable).getPartsCategory();
            final ColorDialog colorDialog = new ColorDialog(this, partsCategory, arrayList);
            this.colorGroupCoordinator.registerColorDialog(colorDialog);
            this.partsColorCoordinator.register((ImageSelectPanel)serializable, colorDialog);
            final int n4 = n3++;
            ((ImageSelectPanel)serializable).addImageSelectListener(new ImageSelectPanel.ImageSelectPanelListener(){

                public void onChangeColor(ImageSelectPanel.ImageSelectPanelEvent imageSelectPanelEvent) {
                    colorDialog.adjustLocation(n4);
                    colorDialog.setVisible(!colorDialog.isVisible());
                }

                public void onPreferences(ImageSelectPanel.ImageSelectPanelEvent imageSelectPanelEvent) {
                }

                public void onChange(ImageSelectPanel.ImageSelectPanelEvent imageSelectPanelEvent) {
                    MainFrame.this.requestPreview();
                }

                public void onSelectChange(ImageSelectPanel.ImageSelectPanelEvent imageSelectPanelEvent) {
                }
            });
        }
        this.partsSelectionManager.loadParts();
        if (!this.loadWorkingSet()) {
            String string = characterData.getDefaultPresetId();
            serializable = null;
            if (string != null) {
                serializable = characterData.getPartsSets().get(string);
            }
            if (serializable == null) {
                this.partsColorCoordinator.initColorDialog();
                this.requestPreview();
            } else {
                this.selectPresetParts((PartsSet)serializable);
            }
        }
        this.watchAgent.addPartsImageDirectoryWatchListener(new PartsImageDirectoryWatchListener(){

            public void detectPartsImageChange(PartsImageDirectoryWatchEvent partsImageDirectoryWatchEvent) {
                Runnable runnable = new Runnable(){

                    public void run() {
                        MainFrame.this.onDetectPartsImageChange();
                    }
                };
                if (SwingUtilities.isEventDispatchThread()) {
                    runnable.run();
                } else {
                    SwingUtilities.invokeLater(runnable);
                }
            }
        });
        if (((AppConfig)object2).isEnableDirWatch()) {
            this.watchAgent.start();
        }
    }

    protected void onDetectPartsImageChange() {
        if (this.characterData.reloadPartsData()) {
            this.partsSelectionManager.loadParts();
            this.requestPreview();
        }
    }

    protected void scrollToSelectedParts() {
        this.partsSelectionManager.scrollToSelectedParts();
    }

    protected void selectPresetParts(PartsSet partsSet) {
        this.partsSelectionManager.selectPartsSet(partsSet);
        this.partsColorCoordinator.initColorDialog();
        this.requestPreview();
    }

    protected void onSelectedFavoriteMenu(JMenu jMenu) {
        int n = jMenu.getMenuComponentCount();
        int n2 = -1;
        for (int i = 0; i < n; ++i) {
            Component component = jMenu.getMenuComponent(i);
            if (!(component instanceof JSeparator)) continue;
            n2 = i;
            break;
        }
        if (n2 > 0) {
            while (jMenu.getMenuComponentCount() > n2 + 1) {
                jMenu.remove(n2 + 1);
            }
        }
        ArrayList<PartsSet> arrayList = new ArrayList<PartsSet>();
        arrayList.addAll(this.characterData.getPartsSets().values());
        Collections.sort(arrayList, new Comparator<PartsSet>(){

            @Override
            public int compare(PartsSet partsSet, PartsSet partsSet2) {
                int n = partsSet.getLocalizedName().compareTo(partsSet2.getLocalizedName());
                if (n == 0) {
                    n = partsSet.getPartsSetId().compareTo(partsSet2.getPartsSetId());
                }
                if (n == 0) {
                    n = partsSet.hashCode() - partsSet2.hashCode();
                }
                return n;
            }
        });
        for (final PartsSet partsSet : arrayList) {
            JMenuItem jMenuItem = new JMenuItem();
            jMenuItem.setName(partsSet.getPartsSetId());
            jMenuItem.setText(partsSet.getLocalizedName());
            if (partsSet.isPresetParts()) {
                Font font = jMenuItem.getFont();
                jMenuItem.setFont(font.deriveFont(1));
            }
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    MainFrame.this.selectPresetParts(partsSet);
                }
            });
            jMenu.add(jMenuItem);
        }
    }

    protected void requestPreview() {
        if (!this.characterData.isValid()) {
            return;
        }
        this.imageBuilder.requestJob(new ImageBuildJobAbstractAdaptor(this.characterData){
            private long ticket;

            public void onQueueing(long l) {
                this.ticket = l;
                MainFrame.this.previewPane.setLoadingRequest(l);
            }

            public void buildImage(ImageBuilder.ImageOutput imageOutput) {
                final BufferedImage bufferedImage = imageOutput.getImageOutput();
                final Color color = imageOutput.getImageBgColor();
                Runnable runnable = new Runnable(){

                    public void run() {
                        MainFrame.this.previewPane.setImageBgColor(color);
                        MainFrame.this.previewPane.setPreviewImage(bufferedImage);
                        MainFrame.this.previewPane.setLoadingComplete(ticket);
                    }
                };
                if (SwingUtilities.isEventDispatchThread()) {
                    runnable.run();
                } else {
                    SwingUtilities.invokeLater(runnable);
                }
            }

            public void handleException(final Exception exception) {
                Runnable runnable = new Runnable(){

                    public void run() {
                        ErrorMessageHelper.showErrorDialog(MainFrame.this, exception);
                    }
                };
                if (SwingUtilities.isEventDispatchThread()) {
                    runnable.run();
                } else {
                    SwingUtilities.invokeLater(runnable);
                }
            }

            protected PartsSet getPartsSet() {
                final PartsSet[] partsSetArray = new PartsSet[1];
                Runnable runnable = new Runnable(){

                    public void run() {
                        PartsSet partsSet;
                        partsSetArray[0] = partsSet = MainFrame.this.partsSelectionManager.createPartsSet();
                    }
                };
                if (SwingUtilities.isEventDispatchThread()) {
                    runnable.run();
                } else {
                    try {
                        SwingUtilities.invokeAndWait(runnable);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        throw new RuntimeException(invocationTargetException.getMessage(), invocationTargetException);
                    }
                    catch (InterruptedException interruptedException) {
                        throw new RuntimeException("interrupted:" + interruptedException, interruptedException);
                    }
                }
                return partsSetArray[0];
            }
        });
    }

    protected void onOpenProfile() {
        try {
            MainFrame mainFrame = ProfileSelectorDialog.openProfile(this);
            if (mainFrame != null) {
                Point point = this.getLocation();
                point.x += 100;
                mainFrame.setLocation(point);
                mainFrame.setVisible(true);
            }
        }
        catch (Exception exception) {
            ErrorMessageHelper.showErrorDialog(this, exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onChangeBgColor() {
        this.getJMenuBar().setEnabled(false);
        try {
            Properties properties = LocalizedResourcePropertyLoader.getInstance().getLocalizedProperties(STRINGS_RESOURCE);
            Color color = this.partsSelectionManager.getImageBgColor();
            color = JColorChooser.showDialog(this, properties.getProperty("chooseBgColor"), color);
            if (color != null) {
                this.partsSelectionManager.setImageBgColor(color);
                this.requestPreview();
            }
        }
        finally {
            this.getJMenuBar().setEnabled(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onSavePicture() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        BufferedImage bufferedImage = this.previewPane.getPreviewImage();
        Color color = this.partsSelectionManager.getImageBgColor();
        if (bufferedImage == null) {
            toolkit.beep();
            return;
        }
        try {
            File file = this.imageSaveHelper.showSaveFileDialog(this);
            if (file == null) {
                return;
            }
            StringBuilder stringBuilder = new StringBuilder();
            this.setCursor(Cursor.getPredefinedCursor(3));
            try {
                this.imageSaveHelper.savePicture(bufferedImage, color, file, stringBuilder);
            }
            finally {
                this.setCursor(Cursor.getDefaultCursor());
            }
            if (stringBuilder.length() > 0) {
                JOptionPane.showMessageDialog(this, stringBuilder.toString(), "WARNINGS", 2);
            }
        }
        catch (Exception exception) {
            ErrorMessageHelper.showErrorDialog(this, exception);
        }
    }

    protected void onCopy() {
        try {
            BufferedImage bufferedImage = this.previewPane.getPreviewImage();
            Color color = this.partsSelectionManager.getImageBgColor();
            if (bufferedImage == null) {
                Toolkit toolkit = Toolkit.getDefaultToolkit();
                toolkit.beep();
                return;
            }
            ClipboardUtil.setImage(bufferedImage, color);
        }
        catch (Exception exception) {
            ErrorMessageHelper.showErrorDialog(this, exception);
        }
    }

    protected void onPreferences() {
        System.out.println("preferences");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onImport() {
        block10: {
            boolean bl = this.watchAgent.stop();
            try {
                ImportWizardDialog importWizardDialog = new ImportWizardDialog(this, this.characterData);
                importWizardDialog.setVisible(true);
                if (importWizardDialog.getExitCode() != 1) break block10;
                try {
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    try {
                        if (this.characterData.reloadPartsData()) {
                            this.partsSelectionManager.loadParts();
                            this.watchAgent.reset();
                        }
                        CharacterDataPersistent characterDataPersistent = CharacterDataPersistent.getInstance();
                        characterDataPersistent.loadFavorites(this.characterData);
                    }
                    finally {
                        this.setCursor(Cursor.getDefaultCursor());
                    }
                }
                catch (Exception exception) {
                    ErrorMessageHelper.showErrorDialog(this, exception);
                }
                this.requestPreview();
            }
            finally {
                if (bl) {
                    this.watchAgent.start();
                }
            }
        }
    }

    protected void onExport() {
        ExportWizardDialog exportWizardDialog = new ExportWizardDialog(this, this.characterData, this.previewPane.getPreviewImage());
        exportWizardDialog.setVisible(true);
    }

    protected void onResetColor() {
        if (!this.characterData.isValid()) {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            toolkit.beep();
            return;
        }
        Properties properties = LocalizedResourcePropertyLoader.getInstance().getLocalizedProperties(STRINGS_RESOURCE);
        if (JOptionPane.showConfirmDialog(this, properties.get("confirm.resetcolors"), properties.getProperty("confirm"), 0, 3) != 0) {
            return;
        }
        this.characterData.getPartsColorManager().resetPartsColorInfo();
        this.partsColorCoordinator.initColorDialog();
        this.requestPreview();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onCloseProfile() {
        this.saveWorkingSet();
        URL uRL = this.characterData.getDocBase();
        if (uRL != null) {
            Object object = activeCharacterDatas;
            synchronized (object) {
                int n = activeCharacterDatas.get(uRL);
                activeCharacterDatas.put(uRL, --n);
            }
            object = RecentDataPersistent.getInstance();
            try {
                ((RecentDataPersistent)object).saveRecent(this.characterData);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.imageBuilder.stop();
        this.watchAgent.stop();
        this.dispose();
    }

    public static void closeAllProfiles() {
        MainFrame mainFrame = activedMainFrame;
        System.gc();
        for (Frame frame : JFrame.getFrames()) {
            try {
                if (!frame.isDisplayable() || !(frame instanceof MainFrame) || frame == mainFrame) continue;
                ((MainFrame)frame).onCloseProfile();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (activedMainFrame != null && activedMainFrame.isDisplayable()) {
            try {
                activedMainFrame.onCloseProfile();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    protected UserData getWorkingSetUserData() {
        return MainFrame.getWorkingSetUserData(this.characterData);
    }

    public static UserData getWorkingSetUserData(CharacterData characterData) {
        if (characterData == null || !characterData.isValid()) {
            return null;
        }
        String string = characterData.getId() + "-workingset.ser";
        UserDataFactory userDataFactory = UserDataFactory.getInstance();
        UserData userData = userDataFactory.getMangledNamedUserData(characterData.getDocBase(), string);
        return userData;
    }

    protected void saveWorkingSet() {
        if (!this.characterData.isValid()) {
            return;
        }
        try {
            WorkingSet workingSet = new WorkingSet();
            workingSet.setCharacterDocBase(this.characterData.getDocBase());
            workingSet.setCharacterDataRev(this.characterData.getRev());
            PartsSet partsSet = this.partsSelectionManager.createPartsSet();
            workingSet.setPartsSet(partsSet);
            workingSet.setPartsColorInfoMap(this.characterData.getPartsColorManager().getPartsColorInfoMap());
            workingSet.setLastUsedSaveDir(this.imageSaveHelper.getLastUsedSaveDir());
            workingSet.setLastUsedExportDir(ExportWizardDialog.getLastUsedDir());
            UserData userData = this.getWorkingSetUserData();
            userData.save(workingSet);
        }
        catch (Exception exception) {
            ErrorMessageHelper.showErrorDialog(this, exception);
        }
    }

    protected boolean loadWorkingSet() {
        if (!this.characterData.isValid()) {
            return false;
        }
        try {
            UserData userData = this.getWorkingSetUserData();
            if (userData != null && userData.exists()) {
                WorkingSet workingSet = (WorkingSet)userData.load();
                if (!this.characterData.getDocBase().equals(workingSet.getCharacterDocBase())) {
                    System.err.println("data mismatch:" + this.characterData);
                    return false;
                }
                String string = this.characterData.getRev();
                String string2 = workingSet.getCharacterDataRev();
                if (string == null || string2 == null || !string.equals(string2)) {
                    System.out.println("revision mismatch: actual=" + this.characterData + "/workingSet=" + workingSet);
                    return false;
                }
                Map<PartsIdentifier, PartsColorInfo> map = this.characterData.getPartsColorManager().getPartsColorInfoMap();
                for (Map.Entry<PartsIdentifier, PartsColorInfo> entry : workingSet.getPartsColorInfoMap().entrySet()) {
                    PartsIdentifier partsIdentifier = entry.getKey();
                    PartsColorInfo partsColorInfo = entry.getValue();
                    map.put(partsIdentifier, partsColorInfo);
                }
                PartsSet partsSet = workingSet.getPartsSet();
                this.selectPresetParts(partsSet.createCompatible(this.characterData));
                this.imageSaveHelper.setLastUseSaveDir(workingSet.getLastUsedSaveDir());
                ExportWizardDialog.setLastUsedDir(workingSet.getLastUsedExportDir());
                return true;
            }
        }
        catch (Exception exception) {
            ErrorMessageHelper.showErrorDialog(this, exception);
        }
        return false;
    }

    protected void onAbout() {
        try {
            AboutBox aboutBox = new AboutBox(this);
            aboutBox.showAboutBox();
        }
        catch (Exception exception) {
            ErrorMessageHelper.showErrorDialog(this, exception);
        }
    }

    protected void onHelp() {
        System.out.println("help");
    }

    protected void onFlipHolizontal() {
        if (!this.characterData.isValid()) {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            toolkit.beep();
            return;
        }
        double[] dArray = this.partsSelectionManager.getAffineTransformParameter();
        if (dArray == null) {
            Dimension dimension = this.characterData.getImageSize();
            if (dimension != null) {
                dArray = new double[]{-1.0, 0.0, 0.0, 1.0, dimension.width, 0.0};
            }
        } else {
            dArray = null;
        }
        this.partsSelectionManager.setAffineTransformParameter(dArray);
        this.requestPreview();
    }

    protected void onInformation() {
        if (!this.characterData.isValid()) {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            toolkit.beep();
            return;
        }
        PartsSet partsSet = this.partsSelectionManager.createPartsSet();
        InformationDialog informationDialog = new InformationDialog(this, this.characterData, partsSet);
        informationDialog.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onManageFavorites() {
        if (!this.characterData.isValid()) {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            toolkit.beep();
            return;
        }
        ManageFavoriteDialog manageFavoriteDialog = new ManageFavoriteDialog(this, this.characterData);
        manageFavoriteDialog.setVisible(true);
        if (!manageFavoriteDialog.isModified()) {
            return;
        }
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            try {
                CharacterDataPersistent characterDataPersistent = CharacterDataPersistent.getInstance();
                characterDataPersistent.saveFavorites(this.characterData);
            }
            finally {
                this.setCursor(Cursor.getDefaultCursor());
            }
        }
        catch (Exception exception) {
            ErrorMessageHelper.showErrorDialog(this, exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onRegisterFavorite() {
        if (!this.characterData.isValid()) {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            toolkit.beep();
            return;
        }
        try {
            PartsSet partsSet = this.partsSelectionManager.createPartsSet();
            if (partsSet.isEmpty()) {
                return;
            }
            Properties properties = LocalizedResourcePropertyLoader.getInstance().getLocalizedProperties(STRINGS_RESOURCE);
            JCheckBox jCheckBox = new JCheckBox(properties.getProperty("input.favoritesColorInfo"));
            jCheckBox.setSelected(true);
            String string = JOptionPane.showInputDialog(this, jCheckBox, properties.getProperty("input.favorites"), 3);
            if (string == null || string.trim().length() == 0) {
                return;
            }
            boolean bl = jCheckBox.isSelected();
            if (!bl) {
                partsSet.removeColorInfo();
            }
            String string2 = "ps" + UUID.randomUUID().toString();
            partsSet.setPartsSetId(string2);
            partsSet.setLocalizedName(string);
            this.characterData.addPartsSet(partsSet);
            this.setCursor(Cursor.getPredefinedCursor(3));
            try {
                CharacterDataPersistent characterDataPersistent = CharacterDataPersistent.getInstance();
                characterDataPersistent.saveFavorites(this.characterData);
            }
            finally {
                this.setCursor(Cursor.getDefaultCursor());
            }
        }
        catch (Exception exception) {
            ErrorMessageHelper.showErrorDialog(this, exception);
        }
    }

    protected JMenuBar createMenuBar() {
        JMenuBar jMenuBar = new JMenuBar(){
            private static final long serialVersionUID = 1L;

            public void paint(Graphics graphics) {
                ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                super.paint(graphics);
            }
        };
        Properties properties = LocalizedResourcePropertyLoader.getInstance().getLocalizedProperties(MENU_STRINGS_RESOURCE);
        MenuDataFactory[] menuDataFactoryArray = new MenuDataFactory[]{new MenuDataFactory("menu.file", new MenuDataFactory[]{new MenuDataFactory("file.openProfile", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.onOpenProfile();
            }
        }), new MenuDataFactory("file.savePicture", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.onSavePicture();
            }
        }), new MenuDataFactory("file.import", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.onImport();
            }
        }), new MenuDataFactory("file.export", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.onExport();
            }
        }), new MenuDataFactory("file.preferences", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.onPreferences();
            }
        }), null, new MenuDataFactory("file.closeProfile", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.onCloseProfile();
            }
        })}), new MenuDataFactory("menu.edit", new MenuDataFactory[]{new MenuDataFactory("edit.copy", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.onCopy();
            }
        }), new MenuDataFactory("edit.flipHorizontal", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.onFlipHolizontal();
            }
        }), new MenuDataFactory("edit.resetcolor", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.onResetColor();
            }
        }), null, new MenuDataFactory("edit.information", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.onInformation();
            }
        })}), new MenuDataFactory("menu.favorite", new MenuDataFactory[]{new MenuDataFactory("favorite.register", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.onRegisterFavorite();
            }
        }), new MenuDataFactory("favorite.manage", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.onManageFavorites();
            }
        }), null}), new MenuDataFactory("menu.help", new MenuDataFactory[]{new MenuDataFactory("help.help", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.onHelp();
            }
        }), new MenuDataFactory("help.about", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.onAbout();
            }
        })})};
        final HashMap<String, 25> hashMap = new HashMap<String, 25>();
        final HashMap<String, 26> hashMap2 = new HashMap<String, 26>();
        for (MenuDataFactory menuDataFactory : menuDataFactoryArray) {
            JMenu jMenu;
            MenuData menuData = menuDataFactory.createMenuData(properties);
            if (!menuData.makeMenu(jMenu = new JMenu(){
                private static final long serialVersionUID = 1L;

                public void paint(Graphics graphics) {
                    ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                    super.paint(graphics);
                }
            })) continue;
            jMenuBar.add(jMenu);
            hashMap.put(menuDataFactory.getName(), jMenu);
            for (MenuData menuData2 : menuData) {
                if (menuData2 == null) {
                    jMenu.add(new JSeparator());
                    continue;
                }
                JMenuItem jMenuItem = new JMenuItem(){
                    private static final long serialVersionUID = 1L;

                    public void paint(Graphics graphics) {
                        ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                        super.paint(graphics);
                    }
                };
                if (!menuData2.makeMenu(jMenuItem)) continue;
                jMenu.add(jMenuItem);
                hashMap2.put(menuData2.getName(), jMenuItem);
            }
        }
        ((JMenu)hashMap.get("menu.edit")).addMenuListener(new MenuListener(){

            public void menuCanceled(MenuEvent menuEvent) {
            }

            public void menuDeselected(MenuEvent menuEvent) {
            }

            public void menuSelected(MenuEvent menuEvent) {
                ((JMenuItem)hashMap2.get("edit.copy")).setEnabled(MainFrame.this.previewPane.getPreviewImage() != null);
            }
        });
        ((JMenu)hashMap.get("menu.favorite")).addMenuListener(new MenuListener(){

            public void menuCanceled(MenuEvent menuEvent) {
            }

            public void menuDeselected(MenuEvent menuEvent) {
            }

            public void menuSelected(MenuEvent menuEvent) {
                JMenu jMenu = (JMenu)hashMap.get("menu.favorite");
                MainFrame.this.onSelectedFavoriteMenu(jMenu);
            }
        });
        return jMenuBar;
    }

    static {
        activeCharacterDatas = new HashMap();
    }
}

