/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.ui;

import charactermanaj.ui.PreviewImagePanel;
import charactermanaj.util.LocalizedResourcePropertyLoader;
import charactermanaj.util.UIUtility;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.util.EventObject;
import java.util.LinkedList;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.Timer;

public class PreviewPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    protected static final String STRINGS_RESOURCE = "strings/previewpanel";
    private static final long INDECATOR_DELAY = 300L;
    private static final String INDICATOR = " (Loading)";
    private final Timer timer = new Timer(100, new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            PreviewPanel.this.onTimer();
        }
    });
    private final Object lock = new Object();
    private long loadingTicket;
    private long loadedTicket;
    private long firstWaitingTimestamp;
    private boolean indicatorShown;
    private String title;
    private JLabel lblTitle;
    private PreviewImagePanel previewImgPanel;
    private LinkedList<PreviewPanelListener> listeners = new LinkedList();

    public void addNotify() {
        super.addNotify();
        if (!this.timer.isRunning()) {
            this.timer.start();
        }
    }

    public void removeNotify() {
        if (this.timer.isRunning()) {
            this.timer.stop();
        }
        super.removeNotify();
    }

    public PreviewPanel() {
        this.setLayout(new BorderLayout());
        Properties properties = LocalizedResourcePropertyLoader.getInstance().getLocalizedProperties(STRINGS_RESOURCE);
        this.lblTitle = new JLabel();
        this.lblTitle.setBorder(BorderFactory.createEmptyBorder(3, 10, 3, 3));
        UIUtility uIUtility = UIUtility.getInstance();
        JButton jButton = uIUtility.createIconButton("icons/save.png");
        JButton jButton2 = uIUtility.createIconButton("icons/copy.png");
        JButton jButton3 = uIUtility.createIconButton("icons/color.png");
        JButton jButton4 = uIUtility.createIconButton("icons/information.png");
        JButton jButton5 = uIUtility.createIconButton("icons/favorite.png");
        JButton jButton6 = uIUtility.createIconButton("icons/flip.png");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PreviewPanel.this.savePicture(new PreviewPanelEvent(PreviewPanel.this));
            }
        });
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PreviewPanel.this.copyPicture(new PreviewPanelEvent(PreviewPanel.this));
            }
        });
        jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PreviewPanel.this.changeBackgroundColor(new PreviewPanelEvent(PreviewPanel.this));
            }
        });
        jButton4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PreviewPanel.this.showInformation(new PreviewPanelEvent(PreviewPanel.this));
            }
        });
        jButton5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PreviewPanel.this.addFavorite(new PreviewPanelEvent(PreviewPanel.this));
            }
        });
        jButton6.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PreviewPanel.this.flipHolizontal(new PreviewPanelEvent(PreviewPanel.this));
            }
        });
        jButton.setToolTipText(properties.getProperty("tooltip.save"));
        jButton2.setToolTipText(properties.getProperty("tooltip.copy"));
        jButton3.setToolTipText(properties.getProperty("tooltip.changeBgColor"));
        jButton4.setToolTipText(properties.getProperty("tooltip.showInformation"));
        jButton5.setToolTipText(properties.getProperty("tooltip.registerFavorites"));
        jButton6.setToolTipText(properties.getProperty("tooltip.flipHorizontal"));
        JToolBar jToolBar = new JToolBar();
        jToolBar.setFloatable(false);
        jToolBar.add(jButton6);
        jToolBar.add(jButton2);
        jToolBar.add(jButton);
        jToolBar.add(Box.createHorizontalStrut(8));
        jToolBar.add(jButton3);
        jToolBar.add(Box.createHorizontalStrut(4));
        jToolBar.add(jButton5);
        jToolBar.add(jButton4);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.lblTitle, "West");
        jPanel.add((Component)jToolBar, "East");
        this.previewImgPanel = new PreviewImagePanel();
        JScrollPane jScrollPane = new JScrollPane(this.previewImgPanel);
        jScrollPane.setAutoscrolls(false);
        jScrollPane.setVerticalScrollBarPolicy(22);
        jScrollPane.setHorizontalScrollBarPolicy(32);
        this.add((Component)jPanel, "North");
        this.add((Component)jScrollPane, "Center");
    }

    public void setTitle(String string) {
        if (string == null) {
            string = "";
        }
        if (!string.equals(this.title)) {
            this.title = string;
            this.lblTitle.setText(string + (this.indicatorShown ? INDICATOR : ""));
        }
    }

    public String getTitle() {
        return this.title;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onTimer() {
        boolean bl;
        long l;
        boolean bl2;
        Object object = this.lock;
        synchronized (object) {
            bl2 = this.loadingTicket > this.loadedTicket;
            l = this.firstWaitingTimestamp;
        }
        boolean bl3 = bl = bl2 && System.currentTimeMillis() - l > 300L;
        if (this.indicatorShown != bl) {
            this.indicatorShown = bl;
            this.lblTitle.setText(this.title + (bl ? INDICATOR : ""));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLoadingRequest(long l) {
        Object object = this.lock;
        synchronized (object) {
            if (this.loadingTicket <= this.loadedTicket) {
                this.firstWaitingTimestamp = System.currentTimeMillis();
            }
            this.loadingTicket = l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLoadingComplete(long l) {
        Object object = this.lock;
        synchronized (object) {
            this.loadedTicket = l;
        }
    }

    public void setPreviewImage(BufferedImage bufferedImage) {
        this.previewImgPanel.setPreviewImage(bufferedImage);
    }

    public BufferedImage getPreviewImage() {
        return this.previewImgPanel.getPreviewImage();
    }

    public Color getImageBgColor() {
        return this.previewImgPanel.getImageBgColor();
    }

    public void setImageBgColor(Color color) {
        this.previewImgPanel.setImageBgColor(color);
    }

    public void addPreviewPanelListener(PreviewPanelListener previewPanelListener) {
        if (previewPanelListener == null) {
            throw new IllegalArgumentException();
        }
        this.listeners.add(previewPanelListener);
    }

    public void removePreviewPanelListener(PreviewPanelListener previewPanelListener) {
        this.listeners.remove(previewPanelListener);
    }

    protected void savePicture(PreviewPanelEvent previewPanelEvent) {
        for (PreviewPanelListener previewPanelListener : this.listeners) {
            previewPanelListener.savePicture(previewPanelEvent);
        }
    }

    protected void flipHolizontal(PreviewPanelEvent previewPanelEvent) {
        for (PreviewPanelListener previewPanelListener : this.listeners) {
            previewPanelListener.flipHorizontal(previewPanelEvent);
        }
    }

    protected void copyPicture(PreviewPanelEvent previewPanelEvent) {
        for (PreviewPanelListener previewPanelListener : this.listeners) {
            previewPanelListener.copyPicture(previewPanelEvent);
        }
    }

    protected void changeBackgroundColor(PreviewPanelEvent previewPanelEvent) {
        for (PreviewPanelListener previewPanelListener : this.listeners) {
            previewPanelListener.changeBackgroundColor(previewPanelEvent);
        }
    }

    protected void showInformation(PreviewPanelEvent previewPanelEvent) {
        for (PreviewPanelListener previewPanelListener : this.listeners) {
            previewPanelListener.showInformation(previewPanelEvent);
        }
    }

    protected void addFavorite(PreviewPanelEvent previewPanelEvent) {
        for (PreviewPanelListener previewPanelListener : this.listeners) {
            previewPanelListener.addFavorite(previewPanelEvent);
        }
    }

    public static class PreviewPanelEvent
    extends EventObject {
        private static final long serialVersionUID = 1L;

        public PreviewPanelEvent(Object object) {
            super(object);
        }
    }

    public static interface PreviewPanelListener {
        public void savePicture(PreviewPanelEvent var1);

        public void copyPicture(PreviewPanelEvent var1);

        public void changeBackgroundColor(PreviewPanelEvent var1);

        public void showInformation(PreviewPanelEvent var1);

        public void addFavorite(PreviewPanelEvent var1);

        public void flipHorizontal(PreviewPanelEvent var1);
    }
}

