/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.ui;

import charactermanaj.Main;
import charactermanaj.model.AppConfig;
import charactermanaj.model.CharacterData;
import charactermanaj.model.ColorGroup;
import charactermanaj.model.Layer;
import charactermanaj.model.PartsCategory;
import charactermanaj.model.PartsSet;
import charactermanaj.ui.CategoriesTableModel;
import charactermanaj.ui.CategoriesTableRow;
import charactermanaj.ui.ColorGroupsTableModel;
import charactermanaj.ui.ColorGroupsTableRow;
import charactermanaj.ui.FirstItemInjectionComboBoxModelWrapper;
import charactermanaj.ui.LayersTableModel;
import charactermanaj.ui.LayersTableRow;
import charactermanaj.ui.PartssetsTableModel;
import charactermanaj.ui.PresetsTableRow;
import charactermanaj.util.DesktopUtil;
import charactermanaj.util.ErrorMessageHelper;
import charactermanaj.util.LocalizedResourcePropertyLoader;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.table.TableCellRenderer;

public class ProfileEditDialog
extends JDialog {
    private static final long serialVersionUID = 8559918820826437849L;
    protected static final String STRINGS_RESOURCE = "strings/profileditdialog";
    private boolean editable;
    private CharacterData original;
    private JTextField txtCharacterID;
    private JTextField txtCharacterRev;
    private JTextField txtCharacterDocBase;
    private JTextField txtCharacterName;
    private JSpinner txtImageWidth;
    private JSpinner txtImageHeight;
    private JTextField txtAuthor;
    private JTextArea txtDescription;
    private ColorGroupsTableModel colorGroupsTableModel;
    private CategoriesTableModel categoriesTableModel;
    private LayersTableModel layersTableModel;
    private PartssetsTableModel partssetsTableModel;
    private CharacterData result;
    private JButton btnOK;

    public ProfileEditDialog(JDialog jDialog, CharacterData characterData, boolean bl) {
        super((Dialog)jDialog, true);
        if (characterData == null) {
            throw new IllegalArgumentException();
        }
        this.original = characterData;
        this.editable = characterData.canWrite() && !bl;
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ProfileEditDialog.this.onClose();
            }
        });
        AppConfig appConfig = AppConfig.getInstance();
        final Properties properties = LocalizedResourcePropertyLoader.getInstance().getLocalizedProperties(STRINGS_RESOURCE);
        String string = bl ? properties.getProperty("title.view") : (characterData.isValid() ? properties.getProperty("title.edit") : properties.getProperty("title.new"));
        this.setTitle(string);
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 42));
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        String string2 = characterData.isValid() || bl ? properties.getProperty("button.ok.edit") : properties.getProperty("button.ok.new");
        this.btnOK = new JButton(new AbstractAction(string2){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                ProfileEditDialog.this.onOK();
            }
        });
        if (!this.editable) {
            this.btnOK.setEnabled(false);
        }
        AbstractAction abstractAction = new AbstractAction(properties.getProperty("button.openDir")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                ProfileEditDialog.this.onOpenDir();
            }
        };
        abstractAction.setEnabled(characterData.isValid());
        JButton jButton = new JButton(abstractAction);
        AbstractAction abstractAction2 = new AbstractAction(properties.getProperty("button.cancel")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                ProfileEditDialog.this.onClose();
            }
        };
        JButton jButton2 = new JButton(abstractAction2);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 1;
        jPanel.add((Component)jButton, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 1;
        jPanel.add(Box.createGlue(), gridBagConstraints);
        gridBagConstraints.gridx = Main.isMacOSX() ? 3 : 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        jPanel.add((Component)this.btnOK, gridBagConstraints);
        gridBagConstraints.gridx = Main.isMacOSX() ? 2 : 3;
        gridBagConstraints.gridy = 0;
        jPanel.add((Component)jButton2, gridBagConstraints);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)jPanel, "South");
        JRootPane jRootPane = this.getRootPane();
        jRootPane.setDefaultButton(this.btnOK);
        jRootPane.getInputMap(1).put(KeyStroke.getKeyStroke(27, 0), "closeWindow");
        jRootPane.getActionMap().put("closeWindow", abstractAction2);
        JPanel jPanel2 = new JPanel();
        GridBagLayout gridBagLayout2 = new GridBagLayout();
        jPanel2.setLayout(gridBagLayout2);
        this.txtCharacterID = new JTextField();
        this.txtCharacterRev = new JTextField();
        this.txtCharacterDocBase = new JTextField();
        this.txtCharacterID.setEditable(false);
        this.txtCharacterRev.setEditable(false);
        this.txtCharacterDocBase.setEditable(false);
        this.txtCharacterName = new JTextField();
        this.txtImageWidth = new JSpinner(new SpinnerNumberModel(1, 1, 1024, 1));
        this.txtImageHeight = new JSpinner(new SpinnerNumberModel(1, 1, 1024, 1));
        this.txtAuthor = new JTextField();
        this.txtDescription = new JTextArea();
        this.txtDescription.setFont(this.getFont());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(1, 3, 1, 5);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 1;
        jPanel2.add((Component)new JLabel(properties.getProperty("docbase.caption"), 4), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 1;
        jPanel2.add((Component)this.txtCharacterDocBase, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(1, 3, 1, 5);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 1;
        jPanel2.add((Component)new JLabel(properties.getProperty("id.caption"), 4), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 1;
        jPanel2.add((Component)this.txtCharacterID, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(1, 3, 1, 5);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 1;
        jPanel2.add((Component)new JLabel(properties.getProperty("rev.caption"), 4), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 1;
        jPanel2.add((Component)this.txtCharacterRev, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 1;
        jPanel2.add((Component)new JLabel(properties.getProperty("name.caption"), 4), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 1;
        jPanel2.add((Component)this.txtCharacterName, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 1;
        jPanel2.add((Component)new JLabel(properties.getProperty("image-width.caption"), 4), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 1;
        jPanel2.add((Component)this.txtImageWidth, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 1;
        jPanel2.add((Component)new JLabel(properties.getProperty("image-height.caption"), 4), gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 1;
        jPanel2.add((Component)this.txtImageHeight, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 1;
        jPanel2.add((Component)new JLabel(properties.getProperty("author.caption"), 4), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 1;
        jPanel2.add((Component)this.txtAuthor, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 1;
        jPanel2.add((Component)new JLabel(properties.getProperty("description.caption"), 4), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 1;
        jPanel2.add((Component)new JScrollPane(this.txtDescription), gridBagConstraints);
        this.colorGroupsTableModel = new ColorGroupsTableModel();
        this.categoriesTableModel = new CategoriesTableModel();
        this.layersTableModel = new LayersTableModel();
        this.partssetsTableModel = new PartssetsTableModel();
        this.colorGroupsTableModel.setEditable(this.editable);
        this.categoriesTableModel.setEditable(this.editable);
        this.layersTableModel.setEditable(this.editable);
        this.partssetsTableModel.setEditable(this.editable);
        JPanel jPanel3 = new JPanel(new BorderLayout());
        final JTable jTable = new JTable(this.colorGroupsTableModel);
        jTable.setRowHeight(jTable.getRowHeight() + 4);
        jTable.setSelectionMode(0);
        jPanel3.add((Component)new JScrollPane(jTable), "Center");
        JPanel jPanel4 = new JPanel();
        GridBagLayout gridBagLayout3 = new GridBagLayout();
        jPanel4.setLayout(gridBagLayout3);
        AbstractAction abstractAction3 = new AbstractAction(properties.getProperty("colorgroup.add.caption")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                ProfileEditDialog.this.colorGroupsTableModel.addNewColorGroup();
            }
        };
        AbstractAction abstractAction4 = new AbstractAction(properties.getProperty("colorgroup.delete.caption")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                int n = jTable.getSelectedRow();
                if (n >= 0) {
                    ColorGroupsTableRow colorGroupsTableRow = (ColorGroupsTableRow)ProfileEditDialog.this.colorGroupsTableModel.getRow(n);
                    if (ProfileEditDialog.this.layersTableModel.isUsed(colorGroupsTableRow)) {
                        JOptionPane.showMessageDialog(ProfileEditDialog.this, properties.getProperty("warning.used-colorgroup"));
                    } else {
                        ProfileEditDialog.this.colorGroupsTableModel.removeRow(n);
                    }
                }
            }
        };
        AbstractAction abstractAction5 = new AbstractAction(properties.getProperty("colorgroup.moveup.caption")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                int n = jTable.getSelectedRow();
                if (n >= 0) {
                    int n2 = ProfileEditDialog.this.colorGroupsTableModel.moveUp(n);
                    jTable.getSelectionModel().setSelectionInterval(n2, n2);
                }
            }
        };
        AbstractAction abstractAction6 = new AbstractAction(properties.getProperty("colorgroup.movedown.caption")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                int n = jTable.getSelectedRow();
                if (n >= 0) {
                    int n2 = ProfileEditDialog.this.colorGroupsTableModel.moveDown(n);
                    jTable.getSelectionModel().setSelectionInterval(n2, n2);
                }
            }
        };
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 1;
        jPanel4.add((Component)new JButton(abstractAction3), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        jPanel4.add((Component)new JButton(abstractAction4), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        jPanel4.add((Component)new JButton(abstractAction5), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        jPanel4.add((Component)new JButton(abstractAction6), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.weighty = 1.0;
        jPanel4.add(Box.createGlue(), gridBagConstraints);
        jPanel3.add((Component)jPanel4, "East");
        JPanel jPanel5 = new JPanel(new BorderLayout());
        final JTable jTable2 = new JTable(this.categoriesTableModel);
        jTable2.setRowHeight(jTable2.getRowHeight() + 4);
        jTable2.setSelectionMode(0);
        jTable2.setAutoResizeMode(0);
        jPanel5.add((Component)new JScrollPane(jTable2), "Center");
        this.categoriesTableModel.adjustColumnModel(jTable2.getColumnModel());
        JPanel jPanel6 = new JPanel();
        GridBagLayout gridBagLayout4 = new GridBagLayout();
        jPanel6.setLayout(gridBagLayout4);
        AbstractAction abstractAction7 = new AbstractAction(properties.getProperty("categories.add.caption")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                ProfileEditDialog.this.categoriesTableModel.addCategory();
            }
        };
        AbstractAction abstractAction8 = new AbstractAction(properties.getProperty("categories.delete.caption")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                int n = jTable2.getSelectedRow();
                if (n >= 0) {
                    CategoriesTableRow categoriesTableRow = (CategoriesTableRow)ProfileEditDialog.this.categoriesTableModel.getRow(n);
                    if (ProfileEditDialog.this.layersTableModel.isUsed(categoriesTableRow)) {
                        JOptionPane.showMessageDialog(ProfileEditDialog.this, properties.getProperty("warning.used-category"));
                    } else {
                        ProfileEditDialog.this.categoriesTableModel.removeRow(n);
                    }
                }
            }
        };
        AbstractAction abstractAction9 = new AbstractAction(properties.getProperty("categories.moveup.caption")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                int n = jTable2.getSelectedRow();
                if (n >= 0) {
                    int n2 = ProfileEditDialog.this.categoriesTableModel.moveUp(n);
                    jTable2.getSelectionModel().setSelectionInterval(n2, n2);
                }
            }
        };
        AbstractAction abstractAction10 = new AbstractAction(properties.getProperty("categories.movedown.caption")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                int n = jTable2.getSelectedRow();
                if (n >= 0) {
                    int n2 = ProfileEditDialog.this.categoriesTableModel.moveDown(n);
                    jTable2.getSelectionModel().setSelectionInterval(n2, n2);
                }
            }
        };
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 1;
        jPanel6.add((Component)new JButton(abstractAction7), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        jPanel6.add((Component)new JButton(abstractAction8), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        jPanel6.add((Component)new JButton(abstractAction9), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        jPanel6.add((Component)new JButton(abstractAction10), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.weighty = 1.0;
        jPanel6.add(Box.createGlue(), gridBagConstraints);
        jPanel5.add((Component)jPanel6, "East");
        JPanel jPanel7 = new JPanel(new BorderLayout());
        final Color color = appConfig.getInvalidBgColor();
        final JTable jTable3 = new JTable(this.layersTableModel){
            private static final long serialVersionUID = 1L;

            public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n, int n2) {
                Component component = super.prepareRenderer(tableCellRenderer, n, n2);
                LayersTableModel layersTableModel = (LayersTableModel)this.getModel();
                LayersTableRow layersTableRow = (LayersTableRow)layersTableModel.getRow(n);
                component.setForeground(this.getForeground());
                component.setBackground(layersTableRow.isValid() ? this.getBackground() : color);
                return component;
            }
        };
        this.layersTableModel.adjustColumnModel(jTable3.getColumnModel());
        JComboBox<ColorGroupsTableRow> jComboBox = new JComboBox<ColorGroupsTableRow>(new FirstItemInjectionComboBoxModelWrapper<ColorGroupsTableRow>(this.colorGroupsTableModel, ColorGroupsTableRow.NA));
        JComboBox jComboBox2 = new JComboBox(this.categoriesTableModel);
        jTable3.setRowHeight(jTable3.getRowHeight() + 4);
        jTable3.setDefaultEditor(ColorGroupsTableRow.class, new DefaultCellEditor(jComboBox));
        jTable3.setDefaultEditor(CategoriesTableRow.class, new DefaultCellEditor(jComboBox2));
        jTable3.setAutoResizeMode(0);
        jTable3.setSelectionMode(0);
        jPanel7.add((Component)new JScrollPane(jTable3), "Center");
        JPanel jPanel8 = new JPanel();
        GridBagLayout gridBagLayout5 = new GridBagLayout();
        jPanel8.setLayout(gridBagLayout5);
        AbstractAction abstractAction11 = new AbstractAction(properties.getProperty("layers.add.caption")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                ProfileEditDialog.this.layersTableModel.addNewLayer();
            }
        };
        AbstractAction abstractAction12 = new AbstractAction(properties.getProperty("layers.delete.caption")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                int n = jTable3.getSelectedRow();
                if (n >= 0) {
                    ProfileEditDialog.this.layersTableModel.removeRow(n);
                }
            }
        };
        AbstractAction abstractAction13 = new AbstractAction(properties.getProperty("layers.sort.caption")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                ProfileEditDialog.this.layersTableModel.sort();
            }
        };
        AbstractAction abstractAction14 = new AbstractAction(properties.getProperty("layers.moveup.caption")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                int n = jTable3.getSelectedRow();
                if (n >= 0) {
                    int n2 = ProfileEditDialog.this.layersTableModel.moveUp(n);
                    jTable3.getSelectionModel().setSelectionInterval(n2, n2);
                }
            }
        };
        AbstractAction abstractAction15 = new AbstractAction(properties.getProperty("layers.movedown.caption")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                int n = jTable3.getSelectedRow();
                if (n >= 0) {
                    int n2 = ProfileEditDialog.this.layersTableModel.moveDown(n);
                    jTable3.getSelectionModel().setSelectionInterval(n2, n2);
                }
            }
        };
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 1;
        jPanel8.add((Component)new JButton(abstractAction11), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        jPanel8.add((Component)new JButton(abstractAction12), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        jPanel8.add((Component)new JButton(abstractAction14), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        jPanel8.add((Component)new JButton(abstractAction15), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        jPanel8.add((Component)new JButton(abstractAction13), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.weighty = 1.0;
        jPanel8.add(Box.createGlue(), gridBagConstraints);
        jPanel7.add((Component)jPanel8, "East");
        JPanel jPanel9 = new JPanel(new BorderLayout());
        JTable jTable4 = new JTable(this.partssetsTableModel);
        this.partssetsTableModel.adjustColumnModel(jTable4.getColumnModel());
        jTable4.setRowHeight(jTable3.getRowHeight() + 4);
        jTable4.setAutoResizeMode(0);
        jTable4.setSelectionMode(0);
        jPanel9.add((Component)new JScrollPane(jTable4), "Center");
        this.loadCharacterData(characterData);
        final HashMap hashMap = new HashMap();
        final Runnable runnable = new Runnable(){

            public void run() {
                hashMap.clear();
            }
        };
        this.layersTableModel.addListDataListener(new ListDataListener(){

            public void contentsChanged(ListDataEvent listDataEvent) {
                runnable.run();
            }

            public void intervalAdded(ListDataEvent listDataEvent) {
                runnable.run();
            }

            public void intervalRemoved(ListDataEvent listDataEvent) {
                runnable.run();
            }
        });
        this.categoriesTableModel.setUsedCategoryDetector(new CategoriesTableModel.UsedCategoryDetector(){

            @Override
            public List<LayersTableRow> getLayers(CategoriesTableRow categoriesTableRow) {
                if (hashMap.isEmpty()) {
                    int n = ProfileEditDialog.this.layersTableModel.getRowCount();
                    for (int i = 0; i < n; ++i) {
                        LayersTableRow layersTableRow = (LayersTableRow)ProfileEditDialog.this.layersTableModel.getRow(i);
                        CategoriesTableRow categoriesTableRow2 = layersTableRow.getPartsCategory();
                        ArrayList<LayersTableRow> arrayList = (ArrayList<LayersTableRow>)hashMap.get(categoriesTableRow2);
                        if (arrayList == null) {
                            arrayList = new ArrayList<LayersTableRow>();
                            hashMap.put(categoriesTableRow2, arrayList);
                        }
                        arrayList.add(layersTableRow);
                    }
                }
                return (List)hashMap.get(categoriesTableRow);
            }
        });
        this.layersTableModel.addListDataListener(new ListDataListener(){

            public void contentsChanged(ListDataEvent listDataEvent) {
                ProfileEditDialog.this.updateUIState();
            }

            public void intervalAdded(ListDataEvent listDataEvent) {
                ProfileEditDialog.this.updateUIState();
            }

            public void intervalRemoved(ListDataEvent listDataEvent) {
                ProfileEditDialog.this.updateUIState();
            }
        });
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ProfileEditDialog.this.updateUIState();
            }
        };
        this.txtCharacterName.addActionListener(actionListener);
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.add(properties.getProperty("panel.basicinfomation"), jPanel2);
        jTabbedPane.add(properties.getProperty("panel.colorgroup"), jPanel3);
        jTabbedPane.add(properties.getProperty("panel.categories"), jPanel5);
        jTabbedPane.add(properties.getProperty("panel.layers"), jPanel7);
        jTabbedPane.add(properties.getProperty("panel.partssets"), jPanel9);
        container.add((Component)jTabbedPane, "Center");
        this.setSize(500, 500);
        this.setLocationRelativeTo(jDialog);
        if (!this.editable) {
            this.txtAuthor.setEditable(false);
            this.txtDescription.setEditable(false);
            this.txtCharacterName.setEditable(false);
            this.txtImageHeight.setEnabled(false);
            this.txtImageWidth.setEnabled(false);
            abstractAction3.setEnabled(false);
            abstractAction4.setEnabled(false);
            abstractAction5.setEnabled(false);
            abstractAction6.setEnabled(false);
            abstractAction7.setEnabled(false);
            abstractAction8.setEnabled(false);
            abstractAction9.setEnabled(false);
            abstractAction10.setEnabled(false);
            abstractAction11.setEnabled(false);
            abstractAction12.setEnabled(false);
            abstractAction15.setEnabled(false);
            abstractAction14.setEnabled(false);
            abstractAction13.setEnabled(false);
        }
        this.updateUIState();
    }

    protected void loadCharacterData(CharacterData characterData) {
        if (characterData == null) {
            throw new IllegalArgumentException();
        }
        this.colorGroupsTableModel.clear();
        this.categoriesTableModel.clear();
        this.layersTableModel.clear();
        this.partssetsTableModel.clear();
        this.txtCharacterID.setText(characterData.getId());
        this.txtCharacterRev.setText(characterData.getRev());
        this.txtCharacterDocBase.setText(characterData.getDocBase() == null ? "" : characterData.getDocBase().toString());
        this.txtCharacterName.setText(characterData.getName());
        this.txtAuthor.setText(characterData.getAuthor() != null ? characterData.getAuthor() : "");
        this.txtDescription.setText(characterData.getDescription() != null ? characterData.getDescription() : "");
        Dimension dimension = characterData.getImageSize();
        this.txtImageWidth.setValue(dimension != null ? dimension.width : 300);
        this.txtImageHeight.setValue(dimension != null ? dimension.height : 400);
        HashMap<ColorGroup, ColorGroupsTableRow> hashMap = new HashMap<ColorGroup, ColorGroupsTableRow>();
        for (ColorGroup serializable : characterData.getColorGroups()) {
            if (!serializable.isEnabled()) continue;
            ColorGroupsTableRow colorGroupsTableRow = ColorGroupsTableRow.valueOf(serializable);
            this.colorGroupsTableModel.addRow(colorGroupsTableRow);
            hashMap.put(serializable, colorGroupsTableRow);
        }
        for (PartsCategory partsCategory : characterData.getPartsCategories()) {
            this.categoriesTableModel.addRow(new CategoriesTableRow(partsCategory));
            for (Layer layer : partsCategory.getLayers()) {
                LayersTableRow layersTableRow = new LayersTableRow();
                ColorGroupsTableRow colorGroupsTableRow = (ColorGroupsTableRow)hashMap.get(layer.getColorGroup());
                if (colorGroupsTableRow == null) {
                    colorGroupsTableRow = ColorGroupsTableRow.NA;
                }
                layersTableRow.setColorGroup(colorGroupsTableRow);
                layersTableRow.setPartsCategory(new CategoriesTableRow(partsCategory));
                layersTableRow.setDir(layer.getDir());
                layersTableRow.setOrder(layer.getOrder());
                layersTableRow.setLayerId(layer.getId());
                layersTableRow.setLayerName(layer.getLocalizedName());
                this.layersTableModel.addRow(layersTableRow);
            }
        }
        for (PartsSet partsSet : characterData.getPartsSets().values()) {
            this.partssetsTableModel.addRow(new PresetsTableRow(partsSet));
        }
        this.partssetsTableModel.setDefaultPartsSetId(characterData.getDefaultPresetId());
    }

    protected void onOpenDir() {
        try {
            URL uRL = this.original.getDocBase();
            if (!DesktopUtil.browseBaseDir(this.original.getDocBase())) {
                JOptionPane.showMessageDialog(this, uRL);
            }
        }
        catch (Exception exception) {
            ErrorMessageHelper.showErrorDialog(this, exception);
        }
    }

    protected void onClose() {
        this.result = null;
        Properties properties = LocalizedResourcePropertyLoader.getInstance().getLocalizedProperties(STRINGS_RESOURCE);
        if (!this.editable || JOptionPane.showConfirmDialog(this, properties.get("confirm.close"), properties.getProperty("confirm"), 0, 2) == 0) {
            this.dispose();
        }
    }

    protected void updateUIState() {
        this.btnOK.setEnabled(this.editable && this.isValidData());
    }

    protected boolean isValidData() {
        boolean bl = true;
        if (this.txtCharacterName.getText().trim().length() == 0) {
            bl = false;
        } else {
            int n = 0;
            int n2 = this.layersTableModel.getRowCount();
            for (int i = 0; i < n2; ++i) {
                LayersTableRow layersTableRow = (LayersTableRow)this.layersTableModel.getRow(i);
                if (!layersTableRow.isValid()) {
                    bl = false;
                    break;
                }
                ++n;
            }
            if (n == 0) {
                bl = false;
            }
        }
        return bl;
    }

    protected void onOK() {
        if (this.editable && this.isValidData()) {
            this.result = this.createCharacterData();
            this.dispose();
            return;
        }
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        toolkit.beep();
    }

    protected CharacterData createCharacterData() {
        int n;
        Object object;
        CategoriesTableRow categoriesTableRow;
        CharacterData characterData = new CharacterData();
        characterData.setDocBase(this.original.getDocBase());
        characterData.setId(this.original.getId());
        characterData.setRev(this.original.getRev());
        characterData.setName(this.txtCharacterName.getText().trim());
        characterData.setAuthor(this.txtAuthor.getText().trim());
        characterData.setDescription(this.txtDescription.getText());
        Dimension dimension = new Dimension();
        dimension.width = ((Number)this.txtImageWidth.getValue()).intValue();
        dimension.height = ((Number)this.txtImageHeight.getValue()).intValue();
        characterData.setImageSize(dimension);
        int n2 = this.colorGroupsTableModel.getRowCount();
        ArrayList<ColorGroup> arrayList = new ArrayList<ColorGroup>();
        for (int i = 0; i < n2; ++i) {
            arrayList.add(((ColorGroupsTableRow)this.colorGroupsTableModel.getRow(i)).convert());
        }
        characterData.setColorGroups(arrayList);
        HashMap<CategoriesTableRow, ArrayList<Layer>> hashMap = new HashMap<CategoriesTableRow, ArrayList<Layer>>();
        int n3 = this.layersTableModel.getRowCount();
        for (int i = 0; i < n3; ++i) {
            LayersTableRow layersTableRow = (LayersTableRow)this.layersTableModel.getRow(i);
            Layer layer = layersTableRow.toLayer();
            categoriesTableRow = layersTableRow.getPartsCategory();
            if (layer == null || categoriesTableRow == null) continue;
            object = (ArrayList<Layer>)hashMap.get(categoriesTableRow);
            if (object == null) {
                object = new ArrayList<Layer>();
                hashMap.put(categoriesTableRow, (ArrayList<Layer>)object);
            }
            object.add(layer);
        }
        ArrayList<PartsCategory> arrayList2 = new ArrayList<PartsCategory>();
        int n4 = this.categoriesTableModel.getRowCount();
        for (n = 0; n < n4; ++n) {
            categoriesTableRow = (CategoriesTableRow)this.categoriesTableModel.getRow(n);
            object = (List)hashMap.get(categoriesTableRow);
            if (object == null) continue;
            categoriesTableRow.setLayers((Collection<Layer>)object);
            arrayList2.add(categoriesTableRow.convert());
        }
        characterData.setPartsCategories(arrayList2.toArray(new PartsCategory[arrayList2.size()]));
        n = this.partssetsTableModel.getRowCount();
        for (int i = 0; i < n; ++i) {
            object = ((PresetsTableRow)this.partssetsTableModel.getRow(i)).convert();
            characterData.addPartsSet((PartsSet)object);
        }
        characterData.setDefaultPresetId(this.partssetsTableModel.getDefaultPartsSetId());
        return characterData;
    }

    public CharacterData getResult() {
        return this.result;
    }
}

