/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.util;

import java.awt.Toolkit;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;

public class DesktopUtil {
    private static Object desktopObj;
    private static Method methodBrowse;
    private static Method methodEdit;

    private DesktopUtil() {
    }

    public static boolean isSupported() {
        return desktopObj != null;
    }

    public static boolean browse(URI uRI) throws IOException {
        if (desktopObj == null) {
            return false;
        }
        try {
            methodBrowse.invoke(desktopObj, uRI);
            return true;
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getCause();
            if (throwable != null && throwable instanceof IOException) {
                throw (IOException)throwable;
            }
            throw new RuntimeException(invocationTargetException.getMessage(), invocationTargetException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException.getMessage(), illegalAccessException);
        }
    }

    public static boolean browseBaseDir(URL uRL) throws IOException {
        Object object;
        URI uRI = null;
        try {
            if (uRL != null) {
                object = new File(uRL.getPath()).getParentFile();
                uRI = ((File)object).toURI();
            }
        }
        catch (Exception exception) {
            uRI = null;
        }
        if (uRI == null) {
            object = Toolkit.getDefaultToolkit();
            ((Toolkit)object).beep();
            return false;
        }
        return DesktopUtil.browse(uRI);
    }

    public static boolean edit(File file) throws IOException {
        if (desktopObj == null) {
            return false;
        }
        try {
            methodEdit.invoke(desktopObj, file);
            return true;
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getCause();
            if (throwable != null && throwable instanceof IOException) {
                throw (IOException)throwable;
            }
            throw new RuntimeException(invocationTargetException.getMessage(), invocationTargetException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException.getMessage(), illegalAccessException);
        }
    }

    static {
        try {
            Class<?> clazz = Class.forName("java.awt.Desktop");
            Method method = clazz.getMethod("getDesktop", new Class[0]);
            methodBrowse = clazz.getMethod("browse", URI.class);
            methodEdit = clazz.getMethod("edit", File.class);
            desktopObj = method.invoke(null, new Object[0]);
        }
        catch (ClassNotFoundException classNotFoundException) {
            desktopObj = null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            desktopObj = null;
        }
    }
}

