/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.util;

import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.AbstractList;
import java.util.Arrays;

public abstract class ResourceLoader {
    protected ClassLoader getClassLoader() {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                if (classLoader == null) {
                    classLoader = ResourceLoader.class.getClassLoader();
                }
                return classLoader;
            }
        });
    }

    protected URL getResource(String string) {
        if (string == null) {
            throw null;
        }
        return this.getClassLoader().getResource(string);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static final class ResourceNames
    extends AbstractList<String> {
        private final String[] resourceNames;

        ResourceNames(String[] stringArray) {
            if (stringArray == null) {
                throw new IllegalArgumentException();
            }
            this.resourceNames = stringArray;
        }

        @Override
        public int hashCode() {
            return Arrays.hashCode(this.resourceNames);
        }

        @Override
        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object != null && object instanceof ResourceNames) {
                ResourceNames resourceNames = (ResourceNames)object;
                return Arrays.equals(this.resourceNames, resourceNames.resourceNames);
            }
            return false;
        }

        @Override
        public int size() {
            return this.resourceNames.length;
        }

        @Override
        public String get(int n) {
            return this.resourceNames[n];
        }
    }
}

