/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.zip;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import java.util.zip.ZipException;
import org.apache.tools.zip.UnicodeCommentExtraField;
import org.apache.tools.zip.UnicodePathExtraField;
import org.apache.tools.zip.ZipEncoding;
import org.apache.tools.zip.ZipEncodingHelper;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipLong;
import org.apache.tools.zip.ZipShort;

public class ZipOutputStream
extends FilterOutputStream {
    private static final int BYTE_MASK = 255;
    private static final int SHORT = 2;
    private static final int WORD = 4;
    private static final int BUFFER_SIZE = 512;
    private static final int DEFLATER_BLOCK_SIZE = 8192;
    public static final int DEFLATED = 8;
    public static final int DEFAULT_COMPRESSION = -1;
    public static final int STORED = 0;
    static final String DEFAULT_ENCODING = null;
    public static final int UFT8_NAMES_FLAG = 2048;
    public static final int EFS_FLAG = 2048;
    private ZipEntry entry;
    private String comment = "";
    private int level = -1;
    private boolean hasCompressionLevelChanged = false;
    private int method = 8;
    private final List entries = new LinkedList();
    private final CRC32 crc = new CRC32();
    private long written = 0L;
    private long dataStart = 0L;
    private long localDataStart = 0L;
    private long cdOffset = 0L;
    private long cdLength = 0L;
    private static final byte[] ZERO = new byte[]{0, 0};
    private static final byte[] LZERO = new byte[]{0, 0, 0, 0};
    private final Map offsets = new HashMap();
    private String encoding = null;
    private ZipEncoding zipEncoding = ZipEncodingHelper.getZipEncoding(DEFAULT_ENCODING);
    protected Deflater def = new Deflater(this.level, true);
    protected byte[] buf = new byte[512];
    private RandomAccessFile raf = null;
    private boolean useUTF8Flag = true;
    private boolean fallbackToUTF8 = false;
    private UnicodeExtraFieldPolicy createUnicodeExtraFields = UnicodeExtraFieldPolicy.NEVER;
    protected static final byte[] LFH_SIG = ZipLong.getBytes(67324752L);
    protected static final byte[] DD_SIG = ZipLong.getBytes(134695760L);
    protected static final byte[] CFH_SIG = ZipLong.getBytes(33639248L);
    protected static final byte[] EOCD_SIG = ZipLong.getBytes(101010256L);
    private static final byte[] DOS_TIME_MIN = ZipLong.getBytes(8448L);

    public ZipOutputStream(OutputStream outputStream) {
        super(outputStream);
    }

    public ZipOutputStream(File file) throws IOException {
        super(null);
        try {
            this.raf = new RandomAccessFile(file, "rw");
            this.raf.setLength(0L);
        }
        catch (IOException iOException) {
            if (this.raf != null) {
                try {
                    this.raf.close();
                }
                catch (IOException iOException2) {
                    // empty catch block
                }
                this.raf = null;
            }
            this.out = new FileOutputStream(file);
        }
    }

    public boolean isSeekable() {
        return this.raf != null;
    }

    public void setEncoding(String string) {
        this.encoding = string;
        this.zipEncoding = ZipEncodingHelper.getZipEncoding(string);
        this.useUTF8Flag &= ZipEncodingHelper.isUTF8(string);
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setUseLanguageEncodingFlag(boolean bl) {
        this.useUTF8Flag = bl && ZipEncodingHelper.isUTF8(this.encoding);
    }

    public void setCreateUnicodeExtraFields(UnicodeExtraFieldPolicy unicodeExtraFieldPolicy) {
        this.createUnicodeExtraFields = unicodeExtraFieldPolicy;
    }

    public void setFallbackToUTF8(boolean bl) {
        this.fallbackToUTF8 = bl;
    }

    public void finish() throws IOException {
        this.closeEntry();
        this.cdOffset = this.written;
        Iterator iterator = this.entries.iterator();
        while (iterator.hasNext()) {
            this.writeCentralFileHeader((ZipEntry)iterator.next());
        }
        this.cdLength = this.written - this.cdOffset;
        this.writeCentralDirectoryEnd();
        this.offsets.clear();
        this.entries.clear();
    }

    public void closeEntry() throws IOException {
        long l;
        if (this.entry == null) {
            return;
        }
        long l2 = this.crc.getValue();
        this.crc.reset();
        if (this.entry.getMethod() == 8) {
            this.def.finish();
            while (!this.def.finished()) {
                this.deflate();
            }
            this.entry.setSize(ZipOutputStream.adjustToLong(this.def.getTotalIn()));
            this.entry.setCompressedSize(ZipOutputStream.adjustToLong(this.def.getTotalOut()));
            this.entry.setCrc(l2);
            this.def.reset();
            this.written += this.entry.getCompressedSize();
        } else if (this.raf == null) {
            if (this.entry.getCrc() != l2) {
                throw new ZipException("bad CRC checksum for entry " + this.entry.getName() + ": " + Long.toHexString(this.entry.getCrc()) + " instead of " + Long.toHexString(l2));
            }
            if (this.entry.getSize() != this.written - this.dataStart) {
                throw new ZipException("bad size for entry " + this.entry.getName() + ": " + this.entry.getSize() + " instead of " + (this.written - this.dataStart));
            }
        } else {
            l = this.written - this.dataStart;
            this.entry.setSize(l);
            this.entry.setCompressedSize(l);
            this.entry.setCrc(l2);
        }
        if (this.raf != null) {
            l = this.raf.getFilePointer();
            this.raf.seek(this.localDataStart);
            this.writeOut(ZipLong.getBytes(this.entry.getCrc()));
            this.writeOut(ZipLong.getBytes(this.entry.getCompressedSize()));
            this.writeOut(ZipLong.getBytes(this.entry.getSize()));
            this.raf.seek(l);
        }
        this.writeDataDescriptor(this.entry);
        this.entry = null;
    }

    public void putNextEntry(ZipEntry zipEntry) throws IOException {
        this.closeEntry();
        this.entry = zipEntry;
        this.entries.add(this.entry);
        if (this.entry.getMethod() == -1) {
            this.entry.setMethod(this.method);
        }
        if (this.entry.getTime() == -1L) {
            this.entry.setTime(System.currentTimeMillis());
        }
        if (this.entry.getMethod() == 0 && this.raf == null) {
            if (this.entry.getSize() == -1L) {
                throw new ZipException("uncompressed size is required for STORED method when not writing to a file");
            }
            if (this.entry.getCrc() == -1L) {
                throw new ZipException("crc checksum is required for STORED method when not writing to a file");
            }
            this.entry.setCompressedSize(this.entry.getSize());
        }
        if (this.entry.getMethod() == 8 && this.hasCompressionLevelChanged) {
            this.def.setLevel(this.level);
            this.hasCompressionLevelChanged = false;
        }
        this.writeLocalFileHeader(this.entry);
    }

    public void setComment(String string) {
        this.comment = string;
    }

    public void setLevel(int n) {
        if (n < -1 || n > 9) {
            throw new IllegalArgumentException("Invalid compression level: " + n);
        }
        this.hasCompressionLevelChanged = this.level != n;
        this.level = n;
    }

    public void setMethod(int n) {
        this.method = n;
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.entry.getMethod() == 8) {
            if (n2 > 0 && !this.def.finished()) {
                if (n2 <= 8192) {
                    this.def.setInput(byArray, n, n2);
                    this.deflateUntilInputIsNeeded();
                } else {
                    int n3;
                    int n4 = n2 / 8192;
                    for (n3 = 0; n3 < n4; ++n3) {
                        this.def.setInput(byArray, n + n3 * 8192, 8192);
                        this.deflateUntilInputIsNeeded();
                    }
                    n3 = n4 * 8192;
                    if (n3 < n2) {
                        this.def.setInput(byArray, n + n3, n2 - n3);
                        this.deflateUntilInputIsNeeded();
                    }
                }
            }
        } else {
            this.writeOut(byArray, n, n2);
            this.written += (long)n2;
        }
        this.crc.update(byArray, n, n2);
    }

    public void write(int n) throws IOException {
        byte[] byArray = new byte[]{(byte)(n & 0xFF)};
        this.write(byArray, 0, 1);
    }

    public void close() throws IOException {
        this.finish();
        if (this.raf != null) {
            this.raf.close();
        }
        if (this.out != null) {
            this.out.close();
        }
    }

    public void flush() throws IOException {
        if (this.out != null) {
            this.out.flush();
        }
    }

    protected final void deflate() throws IOException {
        int n = this.def.deflate(this.buf, 0, this.buf.length);
        if (n > 0) {
            this.writeOut(this.buf, 0, n);
        }
    }

    protected void writeLocalFileHeader(ZipEntry zipEntry) throws IOException {
        boolean bl = this.zipEncoding.canEncode(zipEntry.getName());
        ZipEncoding zipEncoding = !bl && this.fallbackToUTF8 ? ZipEncodingHelper.UTF8_ZIP_ENCODING : this.zipEncoding;
        ByteBuffer byteBuffer = zipEncoding.encode(zipEntry.getName());
        if (this.createUnicodeExtraFields != UnicodeExtraFieldPolicy.NEVER) {
            String string;
            if (this.createUnicodeExtraFields == UnicodeExtraFieldPolicy.ALWAYS || !bl) {
                zipEntry.addExtraField(new UnicodePathExtraField(zipEntry.getName(), byteBuffer.array(), byteBuffer.arrayOffset(), byteBuffer.limit()));
            }
            if ((string = zipEntry.getComment()) != null && !"".equals(string)) {
                boolean bl2 = this.zipEncoding.canEncode(string);
                if (this.createUnicodeExtraFields == UnicodeExtraFieldPolicy.ALWAYS || !bl2) {
                    ByteBuffer byteBuffer2 = zipEncoding.encode(string);
                    zipEntry.addExtraField(new UnicodeCommentExtraField(string, byteBuffer2.array(), byteBuffer2.arrayOffset(), byteBuffer2.limit()));
                }
            }
        }
        this.offsets.put(zipEntry, ZipLong.getBytes(this.written));
        this.writeOut(LFH_SIG);
        this.written += 4L;
        int n = zipEntry.getMethod();
        this.writeVersionNeededToExtractAndGeneralPurposeBits(n, !bl && this.fallbackToUTF8);
        this.written += 4L;
        this.writeOut(ZipShort.getBytes(n));
        this.written += 2L;
        this.writeOut(ZipOutputStream.toDosTime(zipEntry.getTime()));
        this.written += 4L;
        this.localDataStart = this.written;
        if (n == 8 || this.raf != null) {
            this.writeOut(LZERO);
            this.writeOut(LZERO);
            this.writeOut(LZERO);
        } else {
            this.writeOut(ZipLong.getBytes(zipEntry.getCrc()));
            this.writeOut(ZipLong.getBytes(zipEntry.getSize()));
            this.writeOut(ZipLong.getBytes(zipEntry.getSize()));
        }
        this.written += 12L;
        this.writeOut(ZipShort.getBytes(byteBuffer.limit()));
        this.written += 2L;
        byte[] byArray = zipEntry.getLocalFileDataExtra();
        this.writeOut(ZipShort.getBytes(byArray.length));
        this.written += 2L;
        this.writeOut(byteBuffer.array(), byteBuffer.arrayOffset(), byteBuffer.limit());
        this.written += (long)byteBuffer.limit();
        this.writeOut(byArray);
        this.written += (long)byArray.length;
        this.dataStart = this.written;
    }

    protected void writeDataDescriptor(ZipEntry zipEntry) throws IOException {
        if (zipEntry.getMethod() != 8 || this.raf != null) {
            return;
        }
        this.writeOut(DD_SIG);
        this.writeOut(ZipLong.getBytes(this.entry.getCrc()));
        this.writeOut(ZipLong.getBytes(this.entry.getCompressedSize()));
        this.writeOut(ZipLong.getBytes(this.entry.getSize()));
        this.written += 16L;
    }

    protected void writeCentralFileHeader(ZipEntry zipEntry) throws IOException {
        this.writeOut(CFH_SIG);
        this.written += 4L;
        this.writeOut(ZipShort.getBytes(zipEntry.getPlatform() << 8 | 0x14));
        this.written += 2L;
        int n = zipEntry.getMethod();
        boolean bl = this.zipEncoding.canEncode(zipEntry.getName());
        this.writeVersionNeededToExtractAndGeneralPurposeBits(n, !bl && this.fallbackToUTF8);
        this.written += 4L;
        this.writeOut(ZipShort.getBytes(n));
        this.written += 2L;
        this.writeOut(ZipOutputStream.toDosTime(zipEntry.getTime()));
        this.written += 4L;
        this.writeOut(ZipLong.getBytes(zipEntry.getCrc()));
        this.writeOut(ZipLong.getBytes(zipEntry.getCompressedSize()));
        this.writeOut(ZipLong.getBytes(zipEntry.getSize()));
        this.written += 12L;
        ZipEncoding zipEncoding = !bl && this.fallbackToUTF8 ? ZipEncodingHelper.UTF8_ZIP_ENCODING : this.zipEncoding;
        ByteBuffer byteBuffer = zipEncoding.encode(zipEntry.getName());
        this.writeOut(ZipShort.getBytes(byteBuffer.limit()));
        this.written += 2L;
        byte[] byArray = zipEntry.getCentralDirectoryExtra();
        this.writeOut(ZipShort.getBytes(byArray.length));
        this.written += 2L;
        String string = zipEntry.getComment();
        if (string == null) {
            string = "";
        }
        ByteBuffer byteBuffer2 = zipEncoding.encode(string);
        this.writeOut(ZipShort.getBytes(byteBuffer2.limit()));
        this.written += 2L;
        this.writeOut(ZERO);
        this.written += 2L;
        this.writeOut(ZipShort.getBytes(zipEntry.getInternalAttributes()));
        this.written += 2L;
        this.writeOut(ZipLong.getBytes(zipEntry.getExternalAttributes()));
        this.written += 4L;
        this.writeOut((byte[])this.offsets.get(zipEntry));
        this.written += 4L;
        this.writeOut(byteBuffer.array(), byteBuffer.arrayOffset(), byteBuffer.limit());
        this.written += (long)byteBuffer.limit();
        this.writeOut(byArray);
        this.written += (long)byArray.length;
        this.writeOut(byteBuffer2.array(), byteBuffer2.arrayOffset(), byteBuffer2.limit());
        this.written += (long)byteBuffer2.limit();
    }

    protected void writeCentralDirectoryEnd() throws IOException {
        this.writeOut(EOCD_SIG);
        this.writeOut(ZERO);
        this.writeOut(ZERO);
        byte[] byArray = ZipShort.getBytes(this.entries.size());
        this.writeOut(byArray);
        this.writeOut(byArray);
        this.writeOut(ZipLong.getBytes(this.cdLength));
        this.writeOut(ZipLong.getBytes(this.cdOffset));
        ByteBuffer byteBuffer = this.zipEncoding.encode(this.comment);
        this.writeOut(ZipShort.getBytes(byteBuffer.limit()));
        this.writeOut(byteBuffer.array(), byteBuffer.arrayOffset(), byteBuffer.limit());
    }

    protected static ZipLong toDosTime(Date date) {
        return new ZipLong(ZipOutputStream.toDosTime(date.getTime()));
    }

    protected static byte[] toDosTime(long l) {
        Date date = new Date(l);
        int n = date.getYear() + 1900;
        if (n < 1980) {
            return DOS_TIME_MIN;
        }
        int n2 = date.getMonth() + 1;
        long l2 = n - 1980 << 25 | n2 << 21 | date.getDate() << 16 | date.getHours() << 11 | date.getMinutes() << 5 | date.getSeconds() >> 1;
        return ZipLong.getBytes(l2);
    }

    protected byte[] getBytes(String string) throws ZipException {
        try {
            ByteBuffer byteBuffer = ZipEncodingHelper.getZipEncoding(this.encoding).encode(string);
            byte[] byArray = new byte[byteBuffer.limit()];
            System.arraycopy(byteBuffer.array(), byteBuffer.arrayOffset(), byArray, 0, byArray.length);
            return byArray;
        }
        catch (IOException iOException) {
            throw new ZipException("Failed to encode name: " + iOException.getMessage());
        }
    }

    protected final void writeOut(byte[] byArray) throws IOException {
        this.writeOut(byArray, 0, byArray.length);
    }

    protected final void writeOut(byte[] byArray, int n, int n2) throws IOException {
        if (this.raf != null) {
            this.raf.write(byArray, n, n2);
        } else {
            this.out.write(byArray, n, n2);
        }
    }

    protected static long adjustToLong(int n) {
        if (n < 0) {
            return 0x100000000L + (long)n;
        }
        return n;
    }

    private void deflateUntilInputIsNeeded() throws IOException {
        while (!this.def.needsInput()) {
            this.deflate();
        }
    }

    private void writeVersionNeededToExtractAndGeneralPurposeBits(int n, boolean bl) throws IOException {
        int n2;
        int n3 = 10;
        int n4 = n2 = this.useUTF8Flag || bl ? 2048 : 0;
        if (n == 8 && this.raf == null) {
            n3 = 20;
            n2 |= 8;
        }
        this.writeOut(ZipShort.getBytes(n3));
        this.writeOut(ZipShort.getBytes(n2));
    }

    public static final class UnicodeExtraFieldPolicy {
        public static final UnicodeExtraFieldPolicy ALWAYS = new UnicodeExtraFieldPolicy("always");
        public static final UnicodeExtraFieldPolicy NEVER = new UnicodeExtraFieldPolicy("never");
        public static final UnicodeExtraFieldPolicy NOT_ENCODEABLE = new UnicodeExtraFieldPolicy("not encodeable");
        private final String name;

        private UnicodeExtraFieldPolicy(String string) {
            this.name = string;
        }

        public String toString() {
            return this.name;
        }
    }
}

